# $Id: SwitchPort.pm 6701 2012-10-09 12:24:35Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/libnoc-infra-perl/lib/NOC/InfraStructure/SwitchPort.pm $

use strict;
use warnings FATAL => 'all';

package NOC::InfraStructure::SwitchPort;

use InfraStructure::Patch;

use Clarity -base;

field name;
field description;
field ifIndex;
field fwdb;
field patch => undef;

sub toString
{
	my ($self) = @_;

	my $patch = $self->patch;
	return "name=" . $self->name . ", ifIndex=" . $self->ifIndex . ", fwdb=" . $self->fwdb .  ", patch=" . ($patch ? "[$patch]" : "");
}

use overload '""' => \&toString;

1;

=pod

=head1 InfraStructure::Switchport

Deze klasse doet X Y Z.

=head2 METHODS

=head3 dsfljsklfjs()

...

etc




