# $Id: Host.pm 6701 2012-10-09 12:24:35Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/libnoc-infra-perl/lib/NOC/InfraStructure/Host.pm $

use strict;
use warnings FATAL => 'all';

package NOC::InfraStructure::Host;

use NOC::Util::ArrayUtil;
use Clarity -base;

field ip;
field name => [];

sub new
{
	my($class, $ip, $name) = @_;

	my @hostnames = ();
	if (defined $name) { @hostnames = uniq(split(/ /, $name)) }	
	return super(
       			ip => $ip,
			name => [ @hostnames ]
	);
}

sub addHostName
{
	my ($self, $hostname) = @_;

	return unless defined $hostname;

	if ($self->hasHostName($hostname))
	{
		warn("WARNING : Hostname '$hostname' already exists on host with ip " . $self->ip . ". Hostname not added!");
		return;
	}

	push(@{$self->name}, $hostname);
}

sub addHostNames
{
	my ($self, @hostnames) = @_;

    foreach my $hostname (@hostnames)
    {
    	$self->addHostName($hostname);
    }
}

sub hasHostName
{
	my ($self, $hostname) = @_;

	return unless defined $hostname;

	return grep ($_ eq $hostname, @{$self->name})
}

sub removeHostName
{
	my ($self, $hostname) = @_;

	if ($self->hasHostName($hostname))
    {
		remove(\@{$self->name}, $hostname);
    }
}

sub removeHostNames
{
	my ($self, @hostnames) = @_;
        
    foreach my $hostname (@hostnames)
    {
		$self->removeHostName($hostname);
	}
}

sub removeAllHostNames
{
	my ($self) = @_;

	@{$self->name} = ();
}

sub toString
{
        my ($self) = @_;

        return "ip address=" . $self->ip . ", hostname(s)=" . join(',', @{$self->name});
}

use overload '""' => \&toString;

1;
