# $Id: FileUtil.pm 5911 2012-02-24 13:50:41Z wsl $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-infra/lib/NOC/FileUtil.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package NOC::Util::FileUtil;

use IO::File;
use Exporter qw(import);

our @EXPORT = qw(stringFromFile stringToFile);
our @EXPORT_OK = @EXPORT;

our $debug;


# Functienaam : stringFromFile
#
# Parameters : (1x)
#       1) de locatie van de te lezen file
#
# Return : (1x)
#       1) de inhoud van de file als string
#
# Omschrijving :
#       Functie om een file te lezen en de inhoud te retourneren als string

sub stringFromFile
{
	my $file = shift;

	if ($debug) { warn "Processing file '$file' ...\n" };

	my $filehandle = IO::File->new($file, O_RDONLY) or die "Couldn't open $file for reading: $!\n";
	my @string = $filehandle->getlines;
	$filehandle->close();
	return join('', @string);
}


# Functienaam : stringToFile
#
# Parameters : (2x)
#       1) de locatie van de te schrijven file
#	2) de string met text om weg te schrijven
#
# Omschrijving :
#       Functie om een string weg te schrijven naar een file

sub stringToFile
{
    my ($file, $string) = @_;

    if ($debug) { warn "Creating file '$file' ...\n" };

    # Schrijf de resultaten naar de infra-file
    my $filehandle = IO::File->new( $file, O_WRONLY|O_TRUNC|O_CREAT|O_TEXT ) or die "Couldn't open $file for writing: $!\n";
    if (defined $filehandle)
    {
        print $filehandle $string;

        $filehandle->flush;
        $filehandle->sync;
        $filehandle->close;
    }
}

sub debug
{
	$debug = shift;
}

1;
