# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package NOC::InfraStructure::SwitchList;

use NOC::InfraStructure::Switch;

use Clarity -base;

field switches => {};

sub addSwitch
{
    my ($self, $switch) = @_;

    return unless defined $switch;

    if($self->hasSwitch($switch))
	{
		warn("### Warning : Switch '" . $switch->name . "' already exists in SwitchList! Switch not added!");
		return;
    }

    $self->switches->{$switch->name} = $switch;
}

sub removeSwitch
{
	my ($self, $switch) = @_;

	return unless defined $switch;

	my $name = ref $switch ? $switch->name : $switch;

	delete $self->switches->{$name};
}

sub hasSwitch
{
	my ($self, $switch) = @_;
	return defined $self->getSwitchByName($switch->name);
}

sub getSwitchByName
{
	my ($self, $name) = @_;

	return unless defined $name;
	return $self->switches->{$name};
}

sub getSwitchByIp
{
	my ($self, $ip) = @_;

	if (defined($ip))
	{
		foreach my $switch ($self->getSwitches())
		{
			if ($switch->ip eq $ip) { return $switch };
		}
	}
}

sub getSwitches
{
	my ($self) = @_;

	return values %{$self->switches};
}

sub removeAllSwitches
{
	my ($self) = @_;

	delete $self->{switches};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->switches};
}

# TODO ...
sub toString
{
	my($self) = @_;
    my $string = "";

    my @switches = $self->getSwitches();
    for my $i (0..$#switches)
    {
        $string .= "switch=[" . $switches[$i]->toString() . "]" . ( $i < $#switches ? "\n" : ""); 
    }

    return $string;
}

use overload '""' => \&toString;

1;

