# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package NOC::InfraStructure::Switch;

use NOC::InfraStructure::Port;

use Clarity -base;

field name;
field ip;
field ports => {};

sub new
{
        my($class, $name, $ip) = @_;

		return super(
			name => $name,
			ip => $ip,
			#ports => [ () ]
        );
}

sub addPort
{
        my ($self, $port) = @_;

        return unless defined $port;

        if ($self->hasPort($port))
        {
                warn("WARNING : Port '$port->name' already exists on switch '" . $self->name . "'. Switchport not added!");
                return;
        }

		$self->ports->{$port->name} = $port;
}

sub removePort
{
	my ($self, $port) = @_;

        return unless defined $port;

        my $name = ref $port ? $port->name : $port;

        delete $self->ports->{$name};
}

sub hasPort
{
        my ($self, $port) = @_;

	return defined $self->getPortByName($port->name);
}


sub getPortByName
{
	my ($self, $name) = @_;

	return unless defined $name;

	return $self->ports->{$name};
}

sub getPorts
{
	my ($self) = @_;

        return values %{$self->ports};
}


#sub removePort
#{
#        my ($self, $port) = @_;
#
#        if ($self->hasPort($port))
#	{
#		remove(\@{$self->port}, $port);
#	}
#}

sub removeAllPorts
{
        my ($self) = @_;

	delete $self->{ports};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->ports};
}

sub toString
{
        my ($self) = @_;

	my $string = "name=" . $self->name . ", ip=" . $self->ip . ", ports=[";

	my @ports = $self->getPorts();
	for my $i (0..$#ports)
	{
		$string .= "[" . $ports[$i]->toString() . "]" . ( $i < $#ports ? ", " : "");
	}
       #$string .= join('', (map { ", port=[$_]" } $self->getPorts));
	$string .= "]";
	return $string;
#        return "name=" . $self->name . ", ip=" . $self->ip . ", port(s)=" . join(',', @{$self->port});

}

use overload '""' => \&toString;

1;
