use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Aselect;

use Aselect::Client;
use KUB::Aselect::Request;
use KUB::Aselect::Document;

use Xyzzy::Handler -self;

field aselect_id => sub { shift->cfg->aselect_id };
field snoop => undef;

sub handle {
	my $req = new KUB::Aselect::Request(ctx => shift, cfg => $self);

	if($req->aselect_credentials && ($req->cur_aselect_ticket ne (my $ticket = $req->new_aselect_ticket))) {
		my $doc = new KUB::Aselect::Document(req => $req);
		if($self->snoop) {
			my $res = eval { super($req, @_) };
			my $err = $@;
			$res = $err if UNIVERSAL::isa($err, 'Xyzzy::Response');
			die "internal error" unless $res;
			if($res->headers->{Location}) {
				my $cookie = $doc->bakecookie(aselect => $ticket);
				$cookie->setparameter(HttpOnly => 1);
				$res->setcookie($cookie);
				die $res if $err;
				return $res;
			}
		}
		return $doc->response;
	}

	return super($req, @_);
}
