\encoding UTF8

\quit

FAIL

BEGIN;

DROP SCHEMA IF EXISTS kub CASCADE;
CREATE SCHEMA kub;

SET search_path TO kub;

CREATE SEQUENCE seq;

CREATE TABLE urls (
	url BIGINT
		NOT NULL
		DEFAULT nextval('seq')
		PRIMARY KEY,
	name TEXT
		NOT NULL,
	destination TEXT
		NOT NULL,
	private BOOL
		NOT NULL
		DEFAULT TRUE,
	owner BIGINT
		NOT NULL,
	visits BIGINT
		NOT NULL
		DEFAULT 0,
	ctime TIMESTAMP
		NOT NULL
		DEFAULT CURRENT_TIMESTAMP,
	mtime TIMESTAMP
		NOT NULL
		DEFAULT CURRENT_TIMESTAMP,
	atime TIMESTAMP
);

CREATE INDEX urls_owner ON urls (owner);
CREATE INDEX urls_visits ON urls (visits);
CREATE INDEX urls_ctime ON urls (ctime);
CREATE INDEX urls_mtime ON urls (mtime);
CREATE INDEX urls_atime ON urls (atime);
CREATE UNIQUE INDEX urls_name ON urls (lower(name));

COMMIT;

--REINDEX DATABASE kiki;
--VACUUM FULL ANALYZE;
