use strict;
use warnings FATAL => 'all';
use utf8;

package KUB::Document;

use Xyzzy::Document::XHTML -self;

sub getStylesheet {
	my $lang = $self->req->lang
		or return super;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub transform {
	return if $self->req->raw;
	return super;
}

sub build {
	$self->hook_next;
	my $name = $self->xml->documentElement->nodeName;
	$name =~ tr|:|/|;
	eval { $self->transform($name) };
	warn $@ if $@;
}

sub response {
	my $res = super;

	# DOM/XSL system protects against XSS
	$res->setheader('X-XSS-Protection' => 0);

	return $res;
}
