# $Id: Domain.pm 37389 2012-07-09 14:13:13Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Database/Domain.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::Database::Domain;

use Clarity -self;

field db;

field id;
field name => sub { shift->names->[0] };
field names;

sub same {
	my $name = lc(shift);
	return scalar grep { lc($_) eq $name } @{$self->names};
}

sub TO_JSON {
    return {name => $self->name, names => $self->names};
}
