// $Id: json.js 37363 2012-07-04 15:55:45Z wsl $

function json(x) {
	var res = [];
	json.encode.call(json, x, res);
	return res.join('');
}

json.isArray = Array.isArray || function(a) {
	return Object.prototype.toString.call(a) == '[object Array]';
};

json.encode = function(a, res) {
	var t = typeof(a);
	if(a === undefined || a === null) {
		res.push('null');
	} else if(a === true) {
		res.push('true');
	} else if(a === false) {
		res.push('false');
	} else if(t == 'object') {
		if(json.isArray(a)) {
			res.push('[');
			for(var i = 0; i < a.length; i++) {
				if(i > 0)
					res.push(',');
				this.encode(a[i], res);
			}
			res.push(']');
		} else {
			res.push('{');
			var i = 0;
			for(var k in a) {
				if(i++ > 0)
					res.push(',');
				this.encode(k, res);
				res.push(':');
				this.encode(a[k], res);
			}
			res.push('}');
		}
	} else if(t == 'number') {
		res.push(a);
	} else {
		res.push('"');
		res.push(a.replace(/[\\"]/g, "\\$&"));
		res.push('"');
	}
};
