use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::CAS::Document;

use UvT::Kiki::UI::Document -self;

field url;
field session;

use constant rootname => 'cas';

sub response {
	my $res = super;
	$res->status(302);
	$res->setheader(Location => $self->url);
	my $cookie = $self->bakecookie(session => $self->session);
	$cookie->setparameter(HttpOnly => 1);
	$res->setcookie($cookie);
	return $res;
}
