package Tablecollector;
use strict;
use Baseobject;
use DBI;

our @ISA=('Baseobject' );
our @EXPORT = qw (verbosity);

my $sth;

sub new
{
  my $pkg=shift;
  my $self= bless (new Baseobject(@_),$pkg);

  $self->needs ( [ qw (
		       dsn
               user
		       pwd
		       )]);

  $self->needs (
		 {
		   oracle_home=>'/etc/oracle'
		 });

  $self->allows ( [qw (
			dbh
			)]);

  $self->fields(@_);
  $self->checkneeds();
  return $self if ($self->error());

  $self->connect();

  return $self;
}


sub connect
{
  my $self=shift;
  $ENV{ORACLE_HOME}=$self->{fields}->{'oracle_home'};
  $ENV{NLS_LANG}="American_america.UTF8";

  our $dbi_options = {
	  AutoCommit => 0,
	  PrintError => 0,
	  RaiseError => 1,
	  ShowErrorStatement => 1,
  };

  $self->{fields}->{dbh} = DBI->connect( $self->{fields}->{dsn},
										 $self->{fields}->{user},
										 $self->{fields}->{pwd},
										 $dbi_options,
	  );
  unless (defined($self->{fields}->{dbh}))
  {
    $self->error( "ORACLE ERROR  Connect-error", $DBI::errstr);
    return 0;
  }
  return 1;
}

sub DESTROY
{
  my $self=shift;
  $self->debug( "Tablecollector: Disconnecting");
  $self->disconnect();
}

sub disconnect
{
  my $self=shift;
  $sth->finish() if (defined ($sth));
  $self->{fields}->{dbh}->disconnect() if ($self->{fields}->{dbh});
}

sub collect
{
  my $self=shift;
  my $sql=shift;
  my $row=shift;
  my $hall;

  $self->debug("sql: $sql");

  $sth = $self->{fields}->{dbh}->prepare($sql);
  unless (defined ($sth))
  {
    $self->error( "can't prepare: $sql: ",$DBI::errstr);
    return;
  }

  my $res=$sth->execute();

  unless ($res)
  {
    $self->error( "tablecollector: execute failed: $DBI::errstr");
    return ;
  }

  if (defined ($row))
  {
    $self->debug( "fetchrow");
    $hall=($sth->fetchrow_hashref(  ));
    $hall={} unless (defined ($hall));
  }
  else
  {
    $self->debug( "fetchall");
    $hall=($sth->fetchall_hashref( 'ANR' ));
  }
  unless (defined ($hall))
  {
    warn "fetch failed for query: $sql", $sth->errstr;
  }
  if ($sth->err)
  {
    $self->error( "fetchall_hashref failed: ",$sth->errstr);
  }

  $hall;
}

sub count
{
  my $self=shift;
  my ($sql)=shift;
  my $all;

  $self->debug("sql: $sql");

  $sth = $self->{fields}->{dbh}->prepare($sql);
  unless (defined ($sth))
  {
    $self->error( "can't prepare: $sql: ",$DBI::errstr);
  }

  my $res=$sth->execute();

  unless ($res)
  {
    die "tablecounter: execute failed: $DBI::errstr";
  }

  (@$all)=$sth->fetch();

  unless (defined ($all))
  {
    die "fetch failed for query: $sql", $sth->errstr;
  }
  if ($sth->err)
  {
    $self->error( "fetchall_hashref failed: ",$sth->errstr);
  }
  $all->[0]->[0];
}


sub collectall
{

  my $self=shift;
  my $sql=shift;
  my $all=$self->{fields}->{dbh}->selectall_arrayref( $sql);

  unless (defined ($all))
  {
    warn "fetch failed for query: $sql", $sth->errstr;
  }

  $all;
}

42;
