# $Id: MailUser.pm 36942 2012-05-03 14:37:50Z anton $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/keymaster/lib/MailUser.pm $
use strict;
use warnings FATAL => 'all';
package MailUser;
use Data::Dumper;

use Spiffy -Base;

field 'cf', -init => 'die "no cf configured\n"';
field 'params', -init => 'die "no params provided\n"';
field 'log', -init => 'die "no log provided\n"';
field 'ldap';

sub mailUser {
	my $params = $self->params;
	my $cf = $self->cf;
	my $cfh = $cf->hash();
	my $log = $self->log;

	my $userinfo = $params->{userinfo};

	unless (-x $cfh->{mailprogram}) {
		warn "No executable mailprogram configured, no mail sent!";
		return;
	}

	my %h = (%$cfh, %{$params->{userinfo}}, %$params);

	my $sql = $params->{sql};
	my $anr = $params->{anr};

	my ($extramail, $time) = $sql->getMail($anr);

    $h{time} = scalar(localtime);

	my $command = $params->{command};
	my $mailTag = lc("mail$command");
	$log->debug("mailTag: $mailTag");

	my $mailstring = $cf->value($mailTag);

	if ($cf->error)	{
		my $err = $cf->error;
		chomp $err;
		die "configuration error: $err";
	}

	# NB expliciet gebruik van $cf->value in een list context
	$h{mailtext} = join("\n",map { s/\\n//; $_} $cf->value($mailTag));

	die $cf->error if $cf->error();

	$h{adminMailPrefix} = '';
	if ($params->{admin}) {
		$h{adminMailPrefix}	= join("\n",map { s/\\n//; $_} $cf->value('adminMailPrefix'));
	}

	$h{subject} = $cfh->{"${mailTag}subject"};
	my $changed_by = $params->{userinfo}->{changed_by};
	if($changed_by || $changed_by ne '_self_') {
		$h{requestfrom} = '';
		$log->debug( "requestfrom: $changed_by");
	}

	$log->expandvars (\$h{adminMailPrefix}, \%h);

	foreach my $el qw(mailtext subject lau) {
		die "expand error for: '$el'" unless $log->expandvars (\$h{$el}, \%h);
	}

	my $mailto = $params->{userinfo}->{mail};

	my @maillist;
	my $actuallyMailto = '';

	my $mailalso = "$cfh->{mailalso2}\@uvt.nl" if( ($cfh->{mailalso2}));

	if($cfh->{dryrun} && $cfh->{dryrun} eq 'yes') {
		warn "Not mailing because of dryrun";
		return ;
	}

	if($params->{stealthmode}) {
		warn "Not mailing because of stealthmode";
		$log->debug( "mailtext: $h{mailtext}");
		return 1;
	}

	my $privateEmail = $userinfo->{privateEmail};
	warn "privateEmail: $privateEmail";
	my $tiasPrivateEmail = $userinfo->{tiasPrivateEmail};
	my %mailed2;
	foreach my $mailtarget ($mailto, $extramail, $params->{adminMailAddress}, $mailalso, $tiasPrivateEmail, $privateEmail) {
		next unless $mailtarget;
		warn "mailtarget: $mailtarget";
		next if exists($mailed2{lc($mailtarget)});
		$mailed2{lc($mailtarget)} = 1;

		$log->debug("mailtarget: $mailtarget");
		my $mail;
		my $adminMailPrefix ='';
		if ($params->{admin}) {
			$adminMailPrefix = $h{adminMailPrefix} 	if $mailtarget eq $params->{adminMailAddress};
		}

		my $mailhandle = new FileHandle();
		if (open($mailhandle, '|-', $cfh->{mailprogram}, '-oi', '-f', $cfh->{mailerrorsto}, '--', $mailtarget)) {
			$mail = join("\n",
						  (
						   "To: <$mailtarget>",
						   "X-mailer: perl $]",
						   "Subject: $h{subject}",
						   "Precedence: bulk",
						   "From: $cfh->{mailfrom}",
						   "Errors-To: $cfh->{mailerrorsto}",
						   "Mime-Version: 1.0",
						   "Content-Type: text/plain; charset=utf-8",
						   "Content-Disposition: inline",
						   "Content-Transfer-Encoding: 8bit",
						   "",
						   $adminMailPrefix,
						   $h{mailtext},
						  ));
			print $mailhandle $mail;
			close $mailhandle ;

			if ($params->{anr}) {
				$log->verbose("mail sent to $mailtarget ($params->{anr}");
			} else {
				warn "no anr found!";
				warn Dumper($params->{userinfo});
			}
		}  	else {
			die "Could not mail: $!";
		}
		#$log->debug( "mail: $mail");
	}
	return scalar(keys %mailed2);
}
