/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.components.accessor;

import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

/**
 * @version $Id: SessionAccessor.java 449189 2006-09-23 06:52:29Z crossley $
 */
public class SessionAccessor extends ObjectModelAccessor {

    /**
     * @see org.apache.cocoon.components.accessor.ObjectModelAccessor#getObject()
     */
    public Object getObject() {
        Request request = ObjectModelHelper.getRequest(getObjectModel());
        Session session = request.getSession(false);
        return session;
    }
}
