/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by org.apache.cocoon.components.serializers.encoding.Compiler */

package org.apache.cocoon.components.serializers.encoding;

/**
 * The <b>x-IBM949</b> character set encoding representation.
 *
 * @author Generated by <code>org.apache.cocoon.components.serializers.encoding.Compiler</code>
 */
class cs_X_IBM949 extends CompiledCharset {

    /** The name of this charset (<b>x-IBM949</b>). */
    public static final String CS_NAME = "x-IBM949";

    /** The array of alias names of this charset. */
    public static final String CS_ALIASES[] = {
        "ibm-949",
        "cp949",
        "949",
        "ibm949",
    };

    /** The array all characters encoded by this encoding. */
    public static final byte CS_ENCODING[] = {
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
          0,   0,   0,   0, -42,  21,  95,  -9,  64,   0,-127, -63,  64,   0,-127,  65,
          0,   0,   2,   0, -64,   0,  14,-127,   7,  14,  12,   0, -64,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   4,-128,   0,   1,  63,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,  -2,  -1,  -5,   3,  -2,  -1,  -5,   3,   0,   0,   0,   0,   0,   0,
          2,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   2,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,  17,  51,  99,   0,  13,  72,   0,   0,   0,   0,   0,   0,  16,-128,
         30,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          8,   2,  72,   0,  70,  12,   0,   0,   0,   0,  24, 120,  -1,   3,  -1,   3,
          0,   0,  -1,   3,   0,   0,   0,   0,   0,   0,  20,   0,   0,   0,   0,   0,
       -115,-119,   2, 100, -95,  95,  48,  32,   0,   0,   4,   0, -13,  12,   0,   0,
        -52,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  -1, 127, -16,  -1,
          7,   0,   0, -16,  -1,  -1,  63,   0,   0,   0,  -1,  -1,  -1,   3,   0,   0,
         15, -16,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  15,   0,   0,   0,   0,   0,   0,
          0,   0,   4,   0,  -5,   3, -52,  48, -61, -53,   3,   0,   0,   0,   0,   0,
         96, -64,   0,  80,   0,   0,   0,   0,   5,   0,   0,   0, -69,  55,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         15,  -1,  59,  16,   0,   0,   0,   0,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  15,   0,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 127,   8,
          0,   0,   0,   0,   0,   0,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1, 127,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         -1,  -1,  -1,  31,   0,   0,   0,   0,   0,   0,   0,   0,  -1,  -1,  -1,-113,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         31,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-121,  73,  57,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       -117,  47, 114,  67,   0,  32,   5,  11,  44, -24,  64, -29,   0,  40, -56,  64,
         68,  89,  55,  73, 118, 121,  64,   4, -45,  44, -16, -29,  56,   0, -59,   8,
          2, -18,   3,   0,   0,-128,  80,  53, -56, -31,  35, 126,   0,-126,  73, -60,
         90, -83,  66,  41,   0, -64,  96,-128,  28,  70,-102, -84,   3, -64,  42,   5,
         68,  42,  70, -42, -38,  61,   0,   8,-120,-125,  32,  20,  32,   0, 113,   1,
         33,  32,   2,   3,   0,  48, -68,  64,  36,-122,  98,  68, -96,  32,   0,-118,
         83,   2,   4,-128,   2,   4,-124,  20,  -5, 123,   4,  20, -92, 127, -30,  17,
         65,  36, -92,   0,  33,  20, -60,  32,  80,  58,   0, 120,   2,   0,  67,  39,
        -55,  69,-126,  32,  48,  70, -61,  15,-120,  60,  80,  40,   2,-122,  36, -96,
       -120,  35,   6,-120,  25,  14,   0,  64, -86,  34, 100, -21,  28,   0,  40, -51,
         32, -95, -31,   2,  11,-124,   0,-126,-101,  39, -98,  84,  65,-127, -77, -96,
         16,   0,   8,-123,  97,  32,   0,   8,   8,  47, -48,-120,  62, -66,  15,   1,
         26,  -9,   3, -88,  65,  10,   8,  91,   4,   5,   2,   0,   0,   5,  42,  56,
         81,  80,   1,   0,  16,  25,   8,  33,  19,   3,   0,   0,  34,  97,   4,  36,
        -48,  64,   1,  16,   0,-128,  34,  64,  80,-128,  72,  64,   8,   0,   0,  24,
        -39,   6,   0,  55,-128,  94,   0,   0, -96,   0,  16,-108,  24,   0,   0,  96,
         64,   2,-112,   0,   0,-128,  84,   0,   0,   0,   8,   0,   0,  29,  16,   0,
         64,   0,   0,   0,  32,  80,  16,  16,   5,  36,   2,  76,   1,   0,   1,-122,
         24,  41,  76,-111,   0,  33,   1,   8,-123, 100,   3,   0,  82,  68,  33,  16,
          4,  25,   8,   0,  13,   0,   0,   0,-120,  73,   8,-128,   1,   0,-111,  22,
        101,   7,   0,  64,-110,-124,  51,   4,   0,-116,-110,  69,  22,   2,  32,  82,
         40,   2,   8, -48,   0,  67,   8,  76, -94,  64,  42, -61,  16,-104,   0,  46,
          0,-128, 112,  22,-124, 110,-126,  64,-112, -61, -77,   4,-123, 124,  24,  33,
         28,   4, -56,   2,  40,  17,   0,  74,  72,  10,  31,  54,  64,  85,   0,-119,
         10,   0,   2,-103,  33,   2,  64,  16,  66,   2,   0,   4,  68,   0,   0,-128,
          0,   0,  12,  12,  16,   0,   0, 112,  22,  18,-128,   0,  66,   2,   0,   0,
         32,  26,  64,   0,   0,   4,   1,   0,   9,   0, -77, -75,  56,  10,  35,  21,
        -96,-101, -24,  31, 124,  80, 121,-125,  -3,  16, -99, -64, -10, -37,  96,   5,
       -110, -17,  66,   2,  17,   1,   2, -33,  97, 105,  34,   8,  53,-112,   2,   2,
          0,  16,   3,   0,  66,  26, -86,  69,   1,   0,   0,   2,   1, -95,  81,  40,
       -128,  96, -46,   2,-128,   2,   0,   0,   0,  24,   5,   0,   0,-110,   0,   0,
       -124,   8,   0,  32,   5,   4,   0,  53,   0,  32,  76,  96, -26,  73, -66,  98,
         76,  16,  66,  42,  32,  40, -56, -95, -71,  16,  32,-128,  14,   0, -98, 123,
       -112,-124, -32,  20, -63,  40, -32,  65,   4,   7,  73,-116,  13,  19, -56,  12,
         18,-124, -70,-119, -64,   2,  34,  20,  64,  85, -64,  10, -60,  62,-125,-110,
        -93,  28,-121,  67,   3,  71, -80,  34,  40,  48, -64,   3,   1,   8,  34, -88,
          0,-128,  68,  56, -93,-123,  10,   0,  14,  32,  37,  38,  60, -73,   1,   0,
         32,  50,  80,-116,-103,   0, 125,  49, -96,   0,   2,-108,   3,   0,  75,  14,
         74, -29,  32,-116,-128,   0,-111, -48,-108,  29,  40, -89,-100,  73, -63,  96,
          6,  68,  19,   7,-112,  90,  68,  68,-120,  15,   0,   0,  64,   0, -60, -75,
       -127, 117,  71, -60,   2,  68,  83, -64,-117,  43,   8,   1,   0,  64,  66,-110,
         17,   6, -90,   9,   0,   8,  34,  50, -60, -77, -35,  27,   0, -16,-118, -64,
       -126,   3,   2,   0,   0,-120,   0, 110,   0,-110,  33,   0,-128,  65,-124,-116,
          8,  19,  68,   9, -89,  23,   0,   0,  81,-128,  65,  12,   2,  96, -48,   0,
          0, -96, -48,  16,   4,  48,   0,  68,   0,   0,   0,   1,-127,-126,   0,   7,
          0,   1,  14,  68,  48, 104,   5,   8, -78, 100,  20,   5, -26,-112,  22,  68,
         17,   0,   0,  33,   8,-100, -64, -53,  32, -31, -46,  64,  76,  48, -76,  65,
        -84,  16,-125,-102, -78,-104,-127,  50,  34,-104,-124,   0, 105,  51,  18, -68,
        -64, -42,  59, -64, -79, -95,  83,  12,  30,-118,   0, -22, -12, -37, -40,   5,
       -112,  67, -61,  33,   5,  72,  28,  74, -48,   2,  64,  50,  65,   2, -99, -41,
          9,  43, -80, -24, -64, 125,  82,  36,  64, -62,  75, -48,   0, -96, -81, -56,
       -128,-118, -87,  52,   0,-128, -55,  65,  16,-128,  31, 100,   4,-110, 123,  72,
          0,   0, -52,   0,   6, -60,   2,  51,  15,  65,  27,   0,   0,  32,  64,-128,
         42,-128,-104, -96,-122, -95, 107,   0,  48,  42, -92,-123,-127,  65,   4,   6,
         49,  96,   4,   0,-128,   0,   1, -96,   4,   4, -72,  70,  15, -23, -96,   3,
          0,   0,  48,  24, -96,  64,  16,   8,  10, 124,   9,   0,   0,   5,   0, -88,
         36,   4,-118, -62,  10,   0,  32,  39,-112,   9,  13,-125,   2,   8,   0,   0,
         17,  98,-128,  16,  13,   0,   8,  24,  12,   0,   8,-116,   0,   0,  64,   8,
         20,  20,  68,   0,  11,   0,   4, 101, -56,  80,   1,-128, 126,   4,-124,-119,
         88,   6,  64,  65,  16, -64, -92,-108,  98, -88, -36,   9,   0,  24,   0,   0,
         32,-127,  10,   0,   8,   0,-112,  65,   7,  64, -95, -28,   1,  37,  85, 100,
        -18,  17, 125,  15,   0,  72,   8,  -5,  22,  22, -88,   8,  47, -55,   9,   0,
          0,  24,-126,  74, -96,   6, 100, 107,   2,   0,   0,  22,  72,  86,-112,-125,
        -96, 115,  42,   0,   0,-128,  36,  16,  -7,-120,   2,  71,   2,  77, -86,  15,
          0,   0,-128,-114, 123, -72,  84, 117,  24,  36,  64, -39,-128, -56,  12,   4,
          0,   0,  65, -80,  36,-116,  70,   4,  52,  90,  58,   0,   0,-128,  16, -63,
         70,-110,  58,   0,  13,  24,   6,-127,   2,   0,-110, -35,  84,  96,   1, 116,
         18,  97,-111,   0,-104, -64,  10,  66,  15,   4,  32,-116,  19,-102,   2,  68,
         98,-118,  34,  -3,-120,-127,-127,  64,   0,  16,   3,  33,   8,-120,   1,  49,
         32,  68,  36,   7,  18,  -8,-120,   3,   0,-119,   0, -93,   0,   0,   2,  34,
         16,  18,   0,  70,  66,   0,  65,   0,-128,  86,  65,  82, -16,  82,   0,  32,
         16,-122,  20,-126,   4,  17,   6,  70,  10,  67,  53,-128, -32,  96,   0, -38,
         65,   0,   1,   8,   0,  52, 101, 108, -63,  17,  20, -85,-122,   2,   4,  34,
          3,   0,  64,   0,-124,-112,   0,   0,  21,  64,-127,   2,   2,   2,   0,  51,
          0,   4,  64,  56,  32,  14, -48, -64,  48,   0,-123,   0,   0,   5,  37,  13,
        -48,  74, -48,-127,-128,  34,  12,   2,   5, -74,  64,  98, 125,  38,-128,  98,
        -22,   2,   8,   8, 103, -35, 121,-123,  59,   8, -96, -34,  61,-121,   0,  64,
       -116,  10,   0, -47, -86,   5,  37, -94,  64,-124,  16,  21,  77,  64,-128,   0,
         26,  16,  34,-115, 104,  25,-113,   5,-128,-108,  26,  58, 100,-124,  97,-123,
        -64, -52,   2,  32,  32,   8,  46, 115, -92,  32,  52,  11,  12,   0,  29,  20,
          1,  32,   0,-126, -41,   0,  16,   8,   4,  80,  68,   1,  18,  18,   5, 121,
        -46,  64,   9,  68,   0,  64,   0,-124,  76,   5,  68, -40, -70,  64,  20,  81,
         18,  11,   0,  72,  33,   2,-128,  21,   1,  32,   0,   8, 106,   9,   0, -62,
          0,   8,   2,  64,  32,  48,   9, -72,-128,   0,-128,  24, -84, -30,   8,   0,
          4,  16,   4,   0, -32,  16,  20,   0,  32,-128,   0,  32,   0,-104,   0,  16,
       -126, 112,-118,   0,-120,   2,   0,  28,  34,  76,   1,   4,   0,-111,  32,   8,
          2,  64,  64,   2,   0,  28,   0,  68,-125,   3, -63,  -4,  33,  33,   0,-124,
          2, -32,   2,   0, -64,  68,  10, -22,   3,  14,  38,-127, -48,   2,   0,   8,
         33,  41,-112,-106,   1,  64, -62, -72,  65,  98,-128,   0,   6,  10,  81, -90,
         26,   1,  44,-127,   0, -58,   0,-124, -80,  13,-128, -94,  41, -92,  64,-122,
          0,-123,   2,  74,  97,  48,   0,   2,  64, -70,  87,   0,   1,  80,  32,  32,
       -128,-120, -76,  52,   2,  32,  18,   1, -45,  26,   4,   8,  81,   2,   0,   0,
       -127,   0,   4,  64,-126,  12,-128, -32,   8,  48,   0,-128,  49,  16,   8,   0,
          8,   2, -92,-127, -92,  64,  14,  66,   0,   4,  64, -48,-127,-128,  80,  72,
        -11,  45,-111,  15,   7, -40,  41,   6, 124,   0,   1,  72,  70,  69,  78,-126,
          8, -64,   8,  16,   5,  48,  54, -19,-128,  12,  64, 101,  75,-109,  16,   8,
          0,   6,  32, -24,  10, -56,-126,  96, -54,   0,  52,  64,   2,  46,   1,  18,
          4,-112,  88,  25,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,  64,   5,   0,  16,  49,   1,   0,  76, -91,   2,
         32,  85,  16,  69,  16,-125,   4,  35,  34,  84,  52,-128,  67,  10,   9,  26,
        123,  18, -79,   1,   0,  32,  72, -96,  72,   4,  64,  69,   0,-128,-115, -32,
        -16,  26,  64,  45,  38,-122,  22,   4,  24,  80,  64,  76,  50,   0,  18,  33,
        -28,   7,   0,  13,   8,-118,   0,  66,   0,  72,  59,   0,  96,   8,   3,-121,
          5,-123,   0,  52,   9,   1,  40, -28,  69,  32,   0,-125, -88,  37,  24,  92,
        -92,  53,  68, -40,   2,  28, -24,   2, -95,   0,   0,   3,  80, -56,  70,  65,
          0, 104,   4, -90,  96, -14,-118, -69,   0,   0, -66, -56, -30,   0,   2, 108,
         62,   2,-128,   0,   0,-119, 114,   3,-127,-122,   6,   0,   0,   0,-120,   8,
          0,  70,  64,  65,   4,  14,   0,  32,  34,  22,  72,-112,   0,-118,  23,  34,
         24, 116,   0,   0,   0,  18,   2,  49,   0,   2,-126,   8,  74,-104,  34,   4,
          0,   0,  17,  18,   2,   0,   4,-101,  85,  42,  66,   4,   0,  80,  16,  16,
          0,   0,-102, -59,  42, -80,   0, -96,  10,  74,   8,   3,  26,  39,   0,  64,
       -111,-128,  18,   8,  64,-121,   1,   4,   2, -30,  32,  48,  48,   6,-128,-116,
        -60,  12, -64,   4,   0,  32,   0,-128,   0,  64,  49, -40,-128,   0,   2,   2,
          0,  20,  40,   0,  24,   6,   0,   0, -64,  10,  16,-118,  16,  32,   0,  66,
         13,   3,   0,  21,   0,   0,  16,-120,   0,  80, -96,-126,  65,   1,  80,   1,
          4,  32,   0,-128,   4,  32,   8,   4,-111,   0,   0,   0,   1,-112,-124,  74,
         32,   0,  32,-128,  14,   0,  66,   8,  65,  48,-116, 106,  14,   9,-123, -64,
          6,  41, -60,  64,   0,   8,  16,   0,  38,-128,  48, -78,   2,   1,  56,  33,
       -128,   0,  13,   3,  32,   4,  64,   9,  18,   0,   0,-128,  16,   4,   4,-128,
        -54,-120,  72,   0,   2,-122,   4,  36,   1,   0,   4,  16,   8,   0,  16,   1,
         13,  85, -56, -87,  40,  36,  82,  28,   2,   0,  49,  72,  77,  98,  47,   2,
        -80,  48,  40,  65, 123,   5,   5, -46,-108, -88,  68,  24, -62, 108, -54,  69,
         23,  64, -47,  46,   1,  25,   8,  66,   2, -62,   0,  21,  64,-112,-111,  32,
          1,  20,  77,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,-128,-128,  66,  21,  32,   4,   2,  28,   0,   6,
          4,  20,   0,  96,-121, -97, -39, -71, -97,   5,  10,  84,  93,  36,  16,  56,
        -80,  45,  72,   0,   0,   0,   0,   0,   0,   0,   0,   0,  80,  40,-103,   0,
         32,   4,   0,   2,   8,   1,   8,  68,  64,-104,   0,  40,  10,-123,   8,   0,
          0,-124,   1,  64,   0,   4,  97,   0,-108,   7,  32,-126,  17,   0,  80,   0,
        -94,  36,   2,   0,   0,  28,   0,   0,   1,  60,   4,-128,   0,   8,   0,  73,
         40,   2,  60,  -8, -64,-122,   8, -53, 112,  98,   0, -96,  22,   0,   0,   0,
          0,   0,   0,-104,  72, -31,   7,   0,  52,  64,  18,   0,  64,  44,-123,  39,
        111, -87, -77, -26,  15,  64,  38,  81,-122, -20,  59, 114,  11, -29, -92, -75,
        -97,-123,  34,   2,  76,-123,  35,   1,   2,   4,   0,  64,   2,  33,  32,  32,
          4,   0,  36,   2,-128,  32,   4,   0,   0, 126,   4,   0,  12,  22, -96,   1,
       -128,  42,   5,  16,   0, -40,  50,   0,-127,  -6,-125,  49,-120,   4,  32,   0,
          0,  32,-105,  64,   0,   0,  16,-124,  33,  10,-128,  72, 116,   0,   0,  65,
         41,   0,  74,  17,   0,   0, -56,   2,   0,-112,   4,   0,  16,   4,   0,  17,
         16,   0,   1, -59,  87, -55,   0,   0,   0,  45,  16,   8,  16,  64,  32,  80,
          0,  16,  80,   4,-120,  48,   1,   0,   8,   0,   2,  96,  18,   0,  64,   0,
         16,   0,   0,   3,  32,   8,  32,   1,  16,   4,   6,   8,   5,   0,   0, -96,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,-128,   0,
          9,-118,  30,   1,  56,  35,   2,  24,-128,   4, 112,  16,  38,   0,   0,   0,
          0,   0,   0,  16,   2,  69,   4,-120,  21,  56,   1,  -8,  28,   4, -23,  33,
         96, 108,  48,  27,-120,   5,-126,  24, -13, 122,  96,  90,  12,-121, -59,  10,
        -47,  96,  74,  82,-128,   0,   5,  34,  84,   3,  66,  80,   6,  34,-112,  20,
         48, -88,   0,   1,  65,  41,   0,   0,  72,   8,   8,  16,   0,   0,  72,-120,
        111,  21,-113,   1,  10,  40,   1,  11,  64, 112,  16,  69, -96,-120,   1,   0,
          0,   0,   0,   0,   0,-127,  66,   0,-112,   0,   0,-104,   6, -32,  16, 112,
          8,  22,   9,  65,   1,   1,   0,   0,  32,  58,-106,  16,   0,   0,   0,   0,
          0,   0,  64,  34,  32, 113,  26,   2,  18,   0,  39, -94,   4,  32,   2,-128,
          2, -63,   0,   2,   0,   8, -63,   0,  41,  32, -96,-116,  36,   6,   0,   0,
          0,   0,   0,   0,   0,   1,   0,  17,   1,-128,  26,   1,  40,  64,  16,   0,
          0,   0,   0,-123,-116,   4,   2,  24,  62, -32,  18,   4,   0,-128,  16,   0,
          0,  64,   6,-128,   0,  72,   0,   0,   0,   2,  64,   8,  16,   1,   0,   0,
          0,  32,  45,   0,  32,  96,   4,   8,-128,   2,-128,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, -96,   2,  88,   0,
       -128,   3,   0,   8,  64,   1,   0,   8,  16,   0,   2,  32,   3,  16,   4,   0,
          0,   2,   0,   0,   0,-126,  16,   8,  16,   0,-128,   0,   0,   0,  12,   7,
          0,   0,   0,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32, -94,
          2,   0,-116, -96,  48,   0,  48,  72,   8,  96,  18, 121,   0,-127,  16,  24,
       -128,  65,   8,   0,   1,   0,   0,   8,   0,  76,   4,-128, -62,  20,-128,   0,
          0,  32,  33,  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       -105,  15,  -1,  62,  17, -80,   3,  19,   1,  40,  16,  17,   0,   0,-109,   7,
         -5,  30,  25, -80,   3,-105,   1,  59,  18,  17, -96,   0,-109,-105, 107,  52,
         81, -80,   2,  19,   1,  59,  48,  17, -80,   2,  17,   1,  10,  48, 121, -72,
          6,  19,   1,  56,  16,   0,-128,   0,  19,   1,  43,  16,  17,  16,   0,-109,
          7, -85,  18,   0,-128,   0,-109,  21, 123, 118,  81, -80,  39,  19,   1,  59,
         48,  16,   0,   0,   1,   0,   0, 112,  17, -80,   3,  19,   0,  41,  16,  17,
       -112,  33,   1,   0,   0,  48,  29, -80,  14,  19,   1,  57,  48,   1,   0,   2,
         17,   1,  43,  16,   0,   0,   4,-109,-127, 107,  16,  17,-128,   3,  19,   1,
         19,  48,  17,  48,   2,   1,   0,   0,  48,  85, -72,  34,   1,   0,   0,  48,
         17, -80,   3,-105,   7,  -5,  58,  25, -80,   3,  19,   1,  33,  16,   0,   0,
          0,-101,  13, 123,  56,  17, -80,   3,-109,   1,  59,  19,   1,-128,   0,  23,
          5,  43,  28,  17,-128,   1,   1,   0,   0,  16,  17, -80,   0,  19,   1,  42,
         48,  25, -80,   2,   1,   0,  24,  16,   0,   0,   0,  17,   1,   3,  48,  16,
         48,   2,  19,   7, -21,  20,  17,   0,   2,  19,   7,  43, 117,  -7, -72,-113,
         19,   1,  59,  16,   0,   0,   2,   1,   0,   0, 112, -39, -80,  79,  19,   1,
         59,  16,  17,  16,   3,  17,   0,   0,  48,  89, -71,  42,  17,   1,   0,  16,
          1,-128,   1,  17,   1,  27,  16,   0,   0,   0,-109,   1,  43,  16,   0,-128,
          1,   1,   0,  32,  16,  17, -80,   2,  19,   1,  33,  48, -39, -80,   2,   1,
          0,   0,  48,  25, -80,  71,-105,-127,  59,  56,  17, -80,   3,   1,   0,   0,
         16,   0,   0,   0,  19,  13,  59,  56,  17, -80,   3,   1,   0,  16,  16,   0,
          0,   0,  19,   1,  32,  16,  16,   0,   0,   1,   0,   0,  16,   1,   0,   0,
          1,   0,   0,  48,  17,  24,   2,   1,   0,   0,  16,   0,   0,   0,  17,   1,
         35,  16,   0,   0,   0,-109,   1,  11,  16,  17,  48,   0,  17,   1,  43,  48,
         17, -80, -57,  19,   1,  59,  48,   1,-128,   2,   1,   0,   0,  48,  17, -80,
       -125,-109,   1,  43,  48,  17, -80,   3,  17,   0,  10,  48,  17, -80,   2,  17,
          0,  32,  16,   0,   0,   1,  17,   1,  43,  16,  17, -80,   2,  19,   1,  43,
         16,   0,-128,   1,   1,   0,   0,  48,  17,-112,   2,  19,   1,  43,  48,  17,
        -80, 102,   1,   0,   0,  48,  17, -80,   2, -45,   7, -21,  58,  17, -80,  15,
          3,   1,  32,  16,   0,   0,   0,  19,   5, 107,  56,  17, -80,  43,  19,   1,
        -71,  16,   0,   0,   0,-101,   5,  43,  24,   1,   0,   3,   1,   0,   0,  16,
         17, -96,   2,  17,   1,  10, 112, 121, -80, -94,  17,   1,  10,  16,   0,   0,
          0,  17,   1,   0,  16,  17,-112,   0,  19,   1,  41,  16,   1,   0,   0,-109,
          5,  -5, -14,  -7, -80,  35,-109,   1,  59,  50,   1,  48,   0,   1,   0,   0,
         48,  89, -80,  23,-109,   1,  59,  50,  17, -80,  63,  17,   0,   0, 112,  17,
        -80,   2,  17,   0,  24,  16,   0,   0,   1,  19,   1,   3,  16,   1,   0,   0,
       -109,   7, -85,  22,  16,   0,  17,   1,   0,   0,  48,  17,   0,   2,  17,   1,
         41,  48,  17, -79,   2,   1,   0,   0,  48,  89, -80,  14,  19,   5,  59,  56,
         17, -80,   3,  19,   0,   1,  16,   0,   0,   0,-109,   1,  57,  48,  17,-128,
          2,   3,   0,  59,  16,   0,   0,   0,  19,   1,  35,  16,   0,   0,   0,   1,
          0,   0,  16,   0,   0,   0,   1,   0,  33,  48,  49, -80,   2,   1,   0,   0,
         16,   0,   0,   0,   1,   0,   0,  16,   0,   0,   2,  19,   1,   3,  16,   0,
          0,   0,  19,   1,  43, -16,  -7, -72, -85,-109,   1,  59,  48,  17, -80,   2,
         17,   1,  33, -16,  -7, -80,  67,-109,   1,  59, -78,  17, -80,   3,  17,   1,
         32, 112,  89, -80,  34,  19,   1,  40,  16,  17,-112,   1,  17,   1,  11,  48,
         17, -80,   2,-109,   1, -85,  22,   0,   0,   1,  19,   1,  33,  48,  17, -80,
          2,  19,   1,  41,  48,  49, -72,   2,   1,   0,   0,  48,  89, -72,  66,  27,
          5,  59,  56,  17, -80,   3,   1,   0,  40,  16,   0,   0,   0,  19,   5,  59,
         48,  17,   0,   2,   1,   0,   0,  16,   1,   0,   0,-109,   5,  35,  48,  17,
          0,   1,   1,   0,  16,  16,  17, -80,   0,   1,   0,   0,  48,  17, -80,   2,
          1,   0,  24,  16,   0,   0,   0,  17,   0,   0,  24,   0,   0,   2,  19,-123,
          3,  16,  17,  16,   0,  19,   1, -69,  48,  -9, -72, -29,  19,   1,  59,  48,
       -111, -80, -93,  17,   1,  10, 112, 123, -16,  87,  19,   1,  43, 112, -37, -16,
        -29,  17,   1,  59,  48, 121, -71,  14,  19,   1,  59,  48,   1,-112,   2,  19,
          1,  43,  48,  17, -80,   2,-109,   7,  43,  48,  17, -80,   3,  19,   1,  35,
         48,  25, -80,   2,  19,   1, -21,  48,  17, -76,  -2,  17,   1,   9,  48, 121,
        -72,  71, -45,   5,  -5,  52,  17, -80,   3,  83,   1,  33,  16,  17,   0,   0,
       -109,   5, 123,  56,  17, -80,   2,  19,   1,  59,  16,   0,   0,   0,  19,   5,
        -21,  56,  17, -80,   3,  17,   1,  49,  16,  17, -80,   2,  19,   1,  35,  48,
        113, -80,   2,   1,   0,  24,  16,   0,   0,   0,  19,   1,  11,  48,  17,  16,
          0,  19,   1,  43,  16,   0,   0,   0,-109,   5, 123,  54,-107, -80,   3,  19,
          1,  59,  16,   1,   0,   2,   1,   0,   0,  48,-111, -80,   3,   1,   1,  32,
         16,   0,-128,   1,   1,   0,   0,  48,  17, -80,  14,   3,   1,  16,  16,   0,
          0,   1,  17,   1,   3,  16,   0,   0,   2,  19,   1,  35,  16,   0,   0,   3,
          1,   0,   0,  16,   0,   0,   0,   1,   0,   0,  16,   0, -80,   2,   1,   0,
          0,  48,  17, -80, -58, -45,   1,  -5,  52,  17, -80,   3,  81,   1,  35,  16,
          0,   0,   0,  19,   1,  59,  48,  17, -80,   2,  17,   0,  56,  16,   1,   0,
          2,  19,   1,  43,  16,  17,   0,   2,   1,   0,   0,  16,  17, -80,   2,   1,
          0,   1,  48,  17, -80,   2,   1,   0,  24,  16,   1,   0,   0,  17,   1,  43,
         16,  17,  16,   2,  19,   1,  43,  16,   0,   0,   0,-109,   3,  43,  48,  25,
        -80,   2,-109,   1,  59,  50,   0,   0,   2,   1,   0,   0,  48,  25, -80,  35,
         19,   1,  43,  18,  17, -80,   3,   1,   0,   0,  48,  17, -80,   2,  19,   1,
         33,  48,   1,-128,   2,  17,   1,  32,  16,   0,   0,   0,  19,   1,  43,  16,
         17,   0,   2,   1,   0,  32,  48,  17, -80,   2,  17,   1,   1,  48,  17,  48,
          2,   1,   0,   0,  48,  17, -80,   2,  19,   3,  59,  48,  17, -80,   3,   1,
          0,  32,  16,   0,   0,   0,  19,   5,  59,  48,  17, -80,   3,  19,   0,  16,
         16,   1,   0,   0,  19,   1,  43,  20,   1,   0,   0,   1,   0,   0,  16,   1,
       -128,   2,   1,   0,   0,  48,  17, -80,   2,   1,   0,  16,  16,   0,-128,   0,
         19,   1,  43,  16,  17,  16,   2,-109,   5,  43,  16,  17, -80,   0,  19,   1,
         43, 116,  81, -80,  99,  19,   1,  59,  48,   0,   0,   2,   1,   0,   0,  48,
         17, -80,   3,  19,   1,  43,  52,  17, -80,   3,   1,   1,  10,  48,  17, -80,
          2,   1,   0,  32,  16,   0,   0,   0,  17,   0,   0,  16,  17, -96,   0,-109,
          5,  43,  16,   0,   0,   2,   1,   0,   0,  16,  17,-112,   0,  19,   1,  41,
         48,  17, -79,   2,  17,   0,   0,  48,  17, -80,   2,-109,  35,  59,  50,  17,
        -80,   3,   1,   0,  32,  16,   0,   0,   0,-109,   5,  43,  48,  17, -80,   2,
         19,   1,  59,  16,  17,  48,   0,  19,  33,  43,  50,  17,-128,   2,  19,   0,
         40,  48,  17, -96,   2,  19,   1,  11,  48,  17, -78,   2,  17,   1,  33,  48,
         17,  16,   2,  19,   1,  43,  48,  17,-112,   2, -45,   3,  43,  50,  17,  48,
          2,  19,   1,  43,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   7,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,  -8,  -1,  -1,  -1,  -1, 127,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
         -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  63,   0,   0,   0,   0,
          0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 127,   0,   0,   0
    };

    /**
     * Create a new instance of the <b>x-IBM949</b> caracter
     * encoding as a <code>Charset</code>.
     */
    public cs_X_IBM949() {
        super(CS_NAME, CS_ALIASES, CS_ENCODING);
    }

    /**
     * Operation not supported.
     */
    public boolean compile(char c) {
        throw new UnsupportedOperationException();
    }

}
