/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.UAProfValidatorImpl;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;

public class UAProfValidator {
    public static void main(String[] args) {
        try {
            UAProfValidatorImpl v = new UAProfValidatorImpl();
            Workspace.getInstance().configure(null, "config/deliValidatorConfig.xml");
            if (args.length < 1) {
                System.out.println("DELI Validator http://delicon.sourceforge.net/");
                System.out.println("Running automated test for all profiles specified in profiles.rdf");
                System.out.println("IMPORTANT If you run this behind a firewall you must configure proxy e.g. ");
                System.out.println("java -Dhttp.proxyHost=<hostaddress> -Dhttp.proxyPort=<hostport> com.hp.hpl.deli.UAProfValidator");
                System.out.println();
                Model profiles = ModelFactory.createDefaultModel();
                InputStream in = Workspace.getInstance().getResource("config/rdf/profiles.rdf");
                profiles.read(in, "");
                String delins = "http://delicon.sourceforge.net/manufacturerProfiles#";
                Property manufacturerName = profiles.createProperty(delins + "manufacturedBy");
                Property uri = profiles.createProperty(delins + "uaprofUri");
                Property rdftype = profiles.createProperty(Workspace.getInstance().rdfUri + "type");
                String rdfsUri = (String)Workspace.getInstance().rdfsUri.get(0);
                Property label = profiles.createProperty(rdfsUri + "label");
                Property provider = profiles.createProperty(delins + "provider");
                Resource profile = profiles.createResource(delins + "Profile");
                ResIterator profilesIter = profiles.listSubjectsWithProperty(rdftype, (RDFNode)profile);
                while (profilesIter.hasNext()) {
                    Resource p = profilesIter.nextResource();
                    Resource m = (Resource)p.getProperty(manufacturerName).getObject();
                    if (m.getProperty(label).getObject().toString().equals("DELI") || p.getProperty(uri) == null) continue;
                    if (p.getProperty(provider) != null) {
                        System.out.println("PROFILE NOT CREATED BY VENDOR - PROVIDER: " + p.getProperty(provider).getProperty(label).getObject().toString());
                    }
                    System.out.println("MANUFACTURER: " + m.getProperty(label).getObject().toString());
                    System.out.println("DEVICE NAME:  " + p.getProperty(profiles.createProperty(delins + "deviceName")).getObject().toString());
                    String profileUri = p.getProperty(uri).getObject().toString();
                    v.process(profileUri);
                    if (!profileUri.startsWith("http:")) continue;
                    UAProfValidator.download(profileUri);
                }
            } else if (args[0].equals("truststamp") && args.length == 2) {
                v.setTruststamp(true);
                System.out.println("<!--");
                v.process(args[1]);
                System.out.println("-->");
            } else {
                for (int i = 0; i < args.length; ++i) {
                    v.process(args[i]);
                }
            }
            v.results();
        }
        catch (Exception f) {
            System.out.println("DELI error:" + f.toString());
        }
    }

    static void download(String uri) {
        InputStream s = null;
        StringBuffer b = new StringBuffer();
        try {
            int ch;
            URL theURL = new URL(uri);
            String filepath = "profiles/manufacturerProfiles/" + theURL.getHost() + theURL.getFile();
            String path = filepath.substring(0, filepath.lastIndexOf(47));
            File theParent = new File(path);
            theParent.mkdirs();
            File theFile = new File(filepath);
            theFile.createNewFile();
            FileOutputStream theFileStream = new FileOutputStream(theFile);
            s = theURL.openStream();
            while ((ch = s.read()) != -1) {
                b.append((char)ch);
                theFileStream.write(ch);
            }
            s.close();
            theFileStream.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

