/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.CachedProfile;
import com.hp.hpl.deli.Profile;
import com.hp.hpl.deli.Workspace;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class ProfileCache {
    private Map cache;

    protected ProfileCache() {
        this.cache = new HashMap(Workspace.getInstance().maxCacheSize * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Profile get(String profileURL) throws Exception {
        Workspace.printDebug("ProfileCache: Retrieving profile");
        if (Workspace.getInstance().cacheReferenceProfiles) {
            CachedProfile theCachedProfile;
            if (this.cache.containsKey(profileURL)) {
                Workspace.printDebug("ProfileCache: Retrieving cached profile");
                theCachedProfile = (CachedProfile)this.cache.get(profileURL);
            } else {
                boolean result;
                if (this.cache.size() > Workspace.getInstance().maxCacheSize) {
                    ProfileCache profileCache = this;
                    synchronized (profileCache) {
                        int profileToRemove = new Random().nextInt(Workspace.getInstance().maxCacheSize);
                        Object[] theArray = this.cache.keySet().toArray();
                        this.cache.remove(theArray[profileToRemove]);
                    }
                }
                if (!(result = (theCachedProfile = new CachedProfile()).set(profileURL))) {
                    Workspace.printDebug("ProfileCache: Unable to retrieve the profile");
                    return null;
                }
                ProfileCache profileCache = this;
                synchronized (profileCache) {
                    this.cache.put(profileURL, theCachedProfile);
                }
            }
            return theCachedProfile.get();
        }
        return new Profile(profileURL);
    }
}

