/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.JenaProcessProfile;
import com.hp.hpl.deli.ProcessHttpRequest;
import com.hp.hpl.deli.ProfileAttribute;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class Profile
extends Vector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap attributeNameToAttributePosition;

    public Profile(String resource) {
        Workspace.printDebug("Profile: Processing profile reference");
        JenaProcessProfile temp = null;
        Vector unresolved = new Vector();
        try {
            temp = new JenaProcessProfile();
        }
        catch (Exception e) {
            Workspace.printDebug("Profile: Could not create an object to process profile");
        }
        try {
            unresolved.addAll(temp.process(resource));
        }
        catch (Exception e) {
            Workspace.printDebug("Profile: Could not process " + resource + ": ");
            e.printStackTrace();
        }
        this.finishConstruction(unresolved);
    }

    public Profile(HttpServletRequest request) {
        Workspace.printDebug("Profile: Processing HTTP request");
        ProcessHttpRequest theRequest = new ProcessHttpRequest(request);
        Vector profileReferences = theRequest.referenceVector;
        Vector unresolved = new Vector();
        for (int i = 0; i < profileReferences.size(); ++i) {
            String reference = (String)profileReferences.get(i);
            Workspace.printDebug("Retrieving profile " + reference);
            try {
                unresolved.addAll(Workspace.getInstance().profileCache.get(reference));
                continue;
            }
            catch (Exception e) {
                Workspace.printDebug("Profile: While using cache ");
                e.printStackTrace(System.out);
            }
        }
        if (theRequest.diffVector.size() > 0) {
            JenaProcessProfile temp = null;
            try {
                temp = new JenaProcessProfile();
            }
            catch (Exception e) {
                Workspace.printDebug("Profile: Could not create an object to process profile");
            }
            try {
                unresolved.addAll(temp.process(theRequest.diffVector));
            }
            catch (Exception e) {
                Workspace.printDebug("Profile: Could not process profile-diffs");
            }
        }
        this.finishConstruction(unresolved);
    }

    private void finishConstruction(Vector unresolved) {
        if (Workspace.getInstance().printProfileBeforeMerge) {
            Workspace.printDebug(this.toString());
        }
        if (this.attributeNameToAttributePosition == null) {
            this.attributeNameToAttributePosition = new HashMap();
        }
        Iterator i = unresolved.iterator();
        while (i.hasNext()) {
            ProfileAttribute pa = (ProfileAttribute)i.next();
            if (this.attributeNameToAttributePosition.containsKey(pa.getQName())) {
                Vector list = (Vector)this.attributeNameToAttributePosition.get(pa.getQName());
                Iterator listIterator = list.iterator();
                boolean resolved = false;
                while (listIterator.hasNext()) {
                    int currentIntRef = (Integer)listIterator.next();
                    ProfileAttribute currentPa = (ProfileAttribute)this.get(currentIntRef);
                    Resource paURI = pa.getProperty("ccppComponent");
                    Resource currentPaURI = currentPa.getProperty("ccppComponent");
                    if (paURI == null || currentPaURI == null || !paURI.equals(currentPaURI)) continue;
                    ((ProfileAttribute)this.get(currentIntRef)).set(pa);
                    resolved = true;
                }
                if (resolved) continue;
                ((Vector)this.attributeNameToAttributePosition.get(pa.getQName())).add(new Integer(this.size()));
                this.add(pa);
                continue;
            }
            Vector<Integer> v = new Vector<Integer>();
            v.add(new Integer(this.size()));
            this.attributeNameToAttributePosition.put(pa.getQName(), v);
            this.add(pa);
        }
    }

    public ProfileAttribute getAttribute(Resource attributeName) {
        if (this.attributeNameToAttributePosition.get(attributeName) != null) {
            Integer i = (Integer)((Vector)this.attributeNameToAttributePosition.get(attributeName)).firstElement();
            return (ProfileAttribute)this.get(i);
        }
        return null;
    }

    public ProfileAttribute getAttribute(String attributeName) {
        if (this.attributeNameToAttributePosition == null) {
            this.attributeNameToAttributePosition = new HashMap();
        }
        Set keys = this.attributeNameToAttributePosition.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Resource qn = (Resource)i.next();
            if (!qn.getLocalName().equals(attributeName)) continue;
            return (ProfileAttribute)this.get((Integer)((Vector)this.attributeNameToAttributePosition.get(qn)).firstElement());
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            ProfileAttribute p = (ProfileAttribute)this.get(i);
            if (p == null) continue;
            result.append(p.toString());
        }
        return result.toString();
    }
}

