/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.InputStream;
import java.util.Vector;

class LocalProfiles {
    private Vector useragents = new Vector();
    private Vector profileRefs = new Vector();

    protected LocalProfiles(String localProfile) {
        try {
            Model profiles = ModelFactory.createDefaultModel();
            InputStream in = Workspace.getInstance().getResource(localProfile);
            profiles.read(in, "");
            String delins = "http://delicon.sourceforge.net/manufacturerProfiles#";
            Property file = profiles.createProperty(delins + "file");
            Property supportsUAProf = profiles.createProperty(delins + "supportsUAProf");
            Property useragent = profiles.createProperty(delins + "useragent");
            ResIterator profilesIter = profiles.listSubjectsWithProperty(profiles.createProperty(Workspace.getInstance().rdfUri + "type"), (RDFNode)profiles.createResource(delins + "Profile"));
            Property uri = profiles.createProperty(delins + "uaprofUri");
            while (profilesIter.hasNext()) {
                Resource p = profilesIter.nextResource();
                if (p.getProperty(supportsUAProf) != null && p.getProperty(useragent) != null && p.getProperty(uri) != null) {
                    this.profileRefs.add(p.getProperty(uri).getObject().toString());
                    this.useragents.add(p.getProperty(useragent).getObject().toString());
                }
                if (p.getProperty(file) == null || p.getProperty(useragent) == null) continue;
                String profile = Workspace.getInstance().localProfilesPath + "/" + p.getProperty(file).getObject().toString();
                this.profileRefs.add(profile);
                this.useragents.add(p.getProperty(useragent).getObject().toString());
            }
        }
        catch (Exception e) {
            Workspace.printDebug("LocalProfiles: Cannot load local profiles configuration file from " + localProfile);
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    protected String getReference(String s) {
        for (int i = 0; i < this.useragents.size(); ++i) {
            if (s.lastIndexOf((String)this.useragents.get(i)) == -1) continue;
            String localProfile = (String)this.profileRefs.get(i);
            Workspace.printDebug("LocalProfiles: Useragent string " + s);
            Workspace.printDebug(" maps on to " + localProfile);
            return localProfile;
        }
        return null;
    }
}

