/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.ExtendedStatement;
import com.hp.hpl.deli.UAProfProfileAttribute;
import com.hp.hpl.deli.UAProfValidatorImpl;
import com.hp.hpl.deli.VectorUnique;
import com.hp.hpl.deli.Vocabulary;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SelectorImpl;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Vector;

class JenaProcessProfile
implements RDFErrorHandler {
    protected Model jenaProfile;
    private Property componentProperty;
    private Property typeProperty;
    private boolean validationOn = true;
    protected boolean validFlag = true;
    private boolean defaultFlag = false;
    private Vector profileAttributes = new Vector();
    Vocabulary vocabulary = null;
    Workspace workspace = Workspace.getInstance();
    private JenaReader arpReader;
    boolean warnedAboutMissingTypes = false;

    protected JenaProcessProfile() {
        this.vocabulary = this.workspace.vocabulary;
        this.arpReader = new JenaReader();
        this.arpReader.setErrorHandler((RDFErrorHandler)this);
        this.arpReader.setProperty("WARN_RESOLVING_URI_AGAINST_EMPTY_BASE", (Object)"EM_IGNORE");
    }

    public void warning(Exception e) {
    }

    public void error(Exception e) {
    }

    public void fatalError(Exception e) {
    }

    protected Vector process(String resource) throws Exception {
        this.jenaProfile = ModelFactory.createDefaultModel();
        try {
            InputStream in = this.workspace.getResource(resource);
            if (resource.startsWith("http")) {
                this.arpReader.read(this.jenaProfile, in, resource);
            } else {
                this.arpReader.read(this.jenaProfile, in, "");
            }
        }
        catch (RDFException e) {
            Workspace.printDebug("JenaProcessProfile: Could not load profile " + resource);
            Workspace.printDebug(e.toString());
            e.printStackTrace();
        }
        return this.processModel(false);
    }

    protected Vector process(Vector profileVector) throws Exception {
        for (int i = 0; i < profileVector.size(); ++i) {
            StringReader reader = new StringReader((String)profileVector.get(i));
            this.jenaProfile = ModelFactory.createDefaultModel();
            try {
                this.arpReader.read(this.jenaProfile, (Reader)reader, "");
            }
            catch (Exception e) {
                Workspace.printDebug("JenaProcessProfile: Could not process profile-diff");
                Workspace.printDebug(e.toString());
                e.printStackTrace();
            }
            this.processModel(false);
        }
        return this.profileAttributes;
    }

    protected void println(String message) {
        if (this.validationOn) {
            System.out.println(message);
        } else {
            Workspace.printDebug(message);
        }
    }

    protected Vector processModel(boolean validationMode) throws RDFException, Exception {
        this.validationOn = validationMode;
        NsIterator namespaces = this.jenaProfile.listNameSpaces();
        if (!namespaces.hasNext()) {
            this.println("The profile does not contain any RDF information - use W3C RDF Validator");
            this.validFlag = false;
        }
        this.typeProperty = this.jenaProfile.createProperty(this.workspace.rdfUri + "type");
        while (namespaces.hasNext()) {
            String theNamespace = namespaces.nextNs();
            if (theNamespace.equals(this.workspace.rdfUri)) continue;
            this.componentProperty = this.jenaProfile.createProperty(theNamespace + this.workspace.componentProperty);
            if (!this.vocabulary.getRealNamespace(theNamespace).equals(theNamespace)) {
                this.println("WARNING: The profile uses namespace aliasing");
                this.println("Aliased namespace is:    " + theNamespace);
                this.println("Real namespace is: " + this.vocabulary.getRealNamespace(theNamespace));
            } else {
                this.println("The profile uses " + theNamespace);
            }
            String currentComponent = null;
            Resource component = null;
            NodeIterator componentList = this.jenaProfile.listObjectsOfProperty(this.componentProperty);
            if (!componentList.hasNext() && !this.validationOn) continue;
            while (componentList.hasNext()) {
                component = (Resource)componentList.next();
                if (component.hasProperty(this.typeProperty)) {
                    currentComponent = component.getProperty(this.typeProperty).getObject().toString();
                } else if (!this.warnedAboutMissingTypes) {
                    this.println("WARNING: Profile omits type information");
                    this.warnedAboutMissingTypes = true;
                }
                new ProcessAttributeList(component, currentComponent);
            }
        }
        if (this.validationOn) {
            StmtIterator rootProperties = this.findRoot().listProperties();
            while (rootProperties.hasNext()) {
                Statement s = rootProperties.nextStatement();
                if (s.getPredicate().getLocalName().equals("component")) continue;
                this.println("Error: " + s.getPredicate().toString() + " there is a problem with components");
                this.validFlag = false;
            }
        }
        return this.profileAttributes;
    }

    private Resource findRoot() throws Exception {
        Resource root = null;
        RDFNode currentNode = this.jenaProfile.listStatements().nextStatement().getObject();
        while (root == null) {
            StmtIterator iter = this.jenaProfile.listStatements((Selector)new SelectorImpl((Resource)null, (Property)null, currentNode));
            if (iter.hasNext()) {
                currentNode = iter.nextStatement().getSubject();
                continue;
            }
            root = (Resource)currentNode;
        }
        return root;
    }

    private void validatorError(String component, String attribute, String message) {
        this.println("Error [C: " + component + ", A: " + attribute + "] " + message);
        this.validFlag = false;
    }

    private class ProcessAttributeList {
        String currentComponent;

        ProcessAttributeList(Resource theResource, String _currentComponent) throws Exception {
            this.currentComponent = _currentComponent;
            NsIterator namespaces = JenaProcessProfile.this.jenaProfile.listNameSpaces();
            while (namespaces.hasNext()) {
                String vocabularyURI = namespaces.nextNs();
                if (vocabularyURI.equals(JenaProcessProfile.this.workspace.rdfUri)) continue;
                Property defaultProperty = JenaProcessProfile.this.jenaProfile.createProperty(vocabularyURI + "defaults");
                Property capsDefaultProperty = JenaProcessProfile.this.jenaProfile.createProperty(vocabularyURI + "Defaults");
                StmtIterator theProperties = theResource.listProperties();
                while (theProperties.hasNext()) {
                    Statement statement = theProperties.nextStatement();
                    String property = statement.getPredicate().toString();
                    String propertyNamespace = statement.getPredicate().getNameSpace();
                    if (statement.getPredicate().equals(JenaProcessProfile.this.typeProperty)) continue;
                    if (statement.getPredicate().equals(defaultProperty) || statement.getPredicate().equals(capsDefaultProperty)) {
                        this.processDefaultBlock(statement);
                        continue;
                    }
                    if (JenaProcessProfile.this.validationOn || statement.getPredicate().getLocalName().equals(JenaProcessProfile.this.workspace.componentProperty) || JenaProcessProfile.this.vocabulary.namespaceLookup.get(vocabularyURI) == null && !JenaProcessProfile.this.workspace.processUnconfiguredNamespaces || !vocabularyURI.equals(propertyNamespace) || this.currentComponent != null) continue;
                    JenaProcessProfile.this.println("Component is null for: " + property);
                    Vector props = JenaProcessProfile.this.vocabulary.getAttPropertiesWithAttName(property);
                    if (props != null) {
                        JenaProcessProfile.this.println("Determining component from vocabulary");
                        this.currentComponent = ((Resource)((HashMap)props.firstElement()).get("ccppComponent")).toString();
                        continue;
                    }
                    JenaProcessProfile.this.println("Determining component from local ID");
                    this.currentComponent = vocabularyURI + theResource.getLocalName();
                }
            }
            StmtIterator theProperties = theResource.listProperties();
            while (theProperties.hasNext()) {
                Statement statement = theProperties.nextStatement();
                if (statement.getPredicate().equals(JenaProcessProfile.this.typeProperty)) continue;
                new ProcessAttribute(statement, this.currentComponent);
            }
        }

        private void processDefaultBlock(Statement statement) throws Exception {
            StmtIterator iter = ((Resource)statement.getObject()).listProperties();
            if (!iter.hasNext()) {
                String url = statement.getObject().toString();
                JenaProcessProfile.this.println("Retrieving profile " + url);
                if (JenaProcessProfile.this.validationOn) {
                    UAProfValidatorImpl tempValidator = new UAProfValidatorImpl();
                    if (!tempValidator.process(url)) {
                        JenaProcessProfile.this.println("Referenced profile " + url + " is invalid");
                        JenaProcessProfile.this.validFlag = false;
                    }
                } else {
                    JenaProcessProfile tempProfile = new JenaProcessProfile();
                    tempProfile.defaultFlag = true;
                    JenaProcessProfile.this.profileAttributes.addAll(tempProfile.process(url));
                }
            } else {
                JenaProcessProfile.this.defaultFlag = true;
                new ProcessAttributeList((Resource)statement.getObject(), this.currentComponent);
                JenaProcessProfile.this.defaultFlag = false;
            }
        }
    }

    private class ProcessAttribute {
        String currentComponent;
        String attributeName;
        ExtendedStatement attributeStatement;
        Resource ccppType;
        Resource ccppCollectionType;
        Resource qn;

        ProcessAttribute(Statement _attributeStatement, String _currentComponent) throws RDFException, Exception {
            this.attributeStatement = new ExtendedStatement(_attributeStatement, JenaProcessProfile.this.jenaProfile);
            this.currentComponent = JenaProcessProfile.this.vocabulary.getRealNamespace(_currentComponent);
            String qualifiedAttribute = this.attributeStatement.getPredicate().toString();
            this.qn = ResourceFactory.createResource((String)JenaProcessProfile.this.vocabulary.getRealNamespace(qualifiedAttribute));
            this.attributeName = this.attributeStatement.getPredicate().getLocalName();
            Resource currentComponentUri = null;
            if (this.currentComponent != null) {
                currentComponentUri = ResourceFactory.createResource((String)JenaProcessProfile.this.vocabulary.getRealNamespace(this.currentComponent));
            }
            Resource ccppComponent = JenaProcessProfile.this.vocabulary.getAttributeProperty(this.qn, "ccppComponent");
            this.ccppCollectionType = JenaProcessProfile.this.vocabulary.getAttributeProperty(this.qn, "ccppCollectionType");
            this.ccppType = JenaProcessProfile.this.vocabulary.getAttributeProperty(this.qn, "ccppType");
            HashMap attribute = JenaProcessProfile.this.vocabulary.getAttribute(this.qn);
            if (attribute == null) {
                JenaProcessProfile.this.validatorError(this.currentComponent, qualifiedAttribute, "Attribute not defined in vocabulary");
                if (!JenaProcessProfile.this.validationOn && JenaProcessProfile.this.workspace.processUndefinedAttributes) {
                    String collectionType = this.attributeStatement.determineCollectionType();
                    JenaProcessProfile.this.vocabulary.addAttributeToVocabulary(qualifiedAttribute, this.currentComponent, collectionType);
                }
            } else if (JenaProcessProfile.this.validationOn) {
                this.processValues();
                if (!(ccppComponent == null || this.currentComponent == null || ccppComponent.getURI().equals(this.currentComponent) || this.currentComponent == null || this.attributeName.equals("CcppAccept") || this.attributeName.equals("CcppAccept-Language") || this.attributeName.equals("CcppAccept-Charset"))) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Attribute is in wrong component should be " + ccppComponent.toString());
                }
            }
            if (!JenaProcessProfile.this.validationOn && (attribute == null && JenaProcessProfile.this.workspace.processUndefinedAttributes || attribute != null)) {
                VectorUnique attributeValue = this.getValues();
                if (JenaProcessProfile.this.vocabulary.getAttributeProperty(this.qn, "ccppComponent") == null) {
                    JenaProcessProfile.this.println("Could not retrieve " + this.attributeName);
                    JenaProcessProfile.this.println(this.qn.toString());
                    if (currentComponentUri != null) {
                        Workspace.printDebug(currentComponentUri.toString());
                    }
                }
                UAProfProfileAttribute newAttribute = new UAProfProfileAttribute();
                newAttribute.set(this.qn, currentComponentUri, attributeValue, JenaProcessProfile.this.defaultFlag);
                JenaProcessProfile.this.profileAttributes.add(newAttribute);
            }
        }

        private void processValues() throws Exception {
            if (this.ccppCollectionType.getLocalName().equals("Simple")) {
                this.checkDatatype(this.attributeStatement.getObject());
            } else {
                this.validateContainer("Bag");
                this.validateContainer("Seq");
            }
        }

        private void validateContainer(String container) throws Exception {
            if (this.ccppCollectionType.getLocalName().equals(container)) {
                if (!(this.attributeStatement.getObject() instanceof Resource)) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "does not match collection type " + container);
                } else if (!this.attributeStatement.getContainer(container).hasNext()) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "does not match collection type " + container);
                } else {
                    NodeIterator i = this.attributeStatement.getContainerIterator();
                    if (i != null) {
                        while (i.hasNext()) {
                            this.checkDatatype(i.nextNode());
                        }
                    }
                }
            }
        }

        private void checkDatatype(RDFNode value) throws Exception {
            if (!this.ccppType.getLocalName().equals("Any")) {
                if (!(value instanceof Literal)) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Expected literal found resource");
                } else {
                    this.checkRDFdatatype((Literal)value);
                    if (JenaProcessProfile.this.workspace.datatypeValidationOn) {
                        String valueString = ((Literal)value).getLexicalForm();
                        String type = this.ccppType.getLocalName();
                        String regExpression = (String)JenaProcessProfile.this.workspace.datatypeExpressions.get(type);
                        if (regExpression == null) {
                            JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Datatype error: " + type + " is not defined");
                        } else if (!valueString.matches(regExpression)) {
                            JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, "Datatype error:" + valueString + " does not match datatype " + type);
                        }
                    }
                }
            }
        }

        private void checkRDFdatatype(Literal object) throws Exception {
            if (object.getDatatype() != null) {
                String profileDtype = object.getDatatypeURI();
                String vocabDtype = JenaProcessProfile.this.vocabulary.getAttributeProperty(this.qn, "ccppType").toString();
                if (!vocabDtype.toLowerCase().equals(profileDtype.toLowerCase())) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, " datatypes do not match " + profileDtype + " " + vocabDtype);
                }
            } else {
                String prfURI = ResourceFactory.createResource((String)this.qn.toString()).getNameSpace();
                if (JenaProcessProfile.this.vocabulary.usesRDFDatatyping(prfURI)) {
                    JenaProcessProfile.this.validatorError(this.currentComponent, this.attributeName, " UAProf 2 profile omits RDF datatyping information");
                }
            }
        }

        private VectorUnique getValues() throws Exception {
            VectorUnique attributeValue = new VectorUnique();
            if (this.attributeStatement.getObject() instanceof Literal) {
                Literal object = this.attributeStatement.getLiteral();
                attributeValue.add(new String(object.getValue().toString().trim()));
                this.checkRDFdatatype(object);
            } else {
                NodeIterator i = this.attributeStatement.getContainerIterator();
                if (i != null) {
                    while (i.hasNext()) {
                        Object object;
                        RDFNode theNode = i.nextNode();
                        if (theNode instanceof Literal) {
                            object = (Literal)theNode;
                            attributeValue.add(new String(object.getValue().toString().trim()));
                            this.checkRDFdatatype((Literal)object);
                            continue;
                        }
                        object = ((Resource)theNode).getURI();
                        attributeValue.add(new String(((String)object).trim()));
                    }
                }
            }
            return attributeValue;
        }
    }
}

