/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.client.Data;
import org.apache.excalibur.instrument.client.InstrumentSampleSnapshotData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPInstrumentSampleElementData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;

class HTTPInstrumentSampleSnapshotData
extends AbstractHTTPInstrumentSampleElementData
implements InstrumentSampleSnapshotData {
    private int[] m_samples;

    HTTPInstrumentSampleSnapshotData(HTTPInstrumentManagerConnection connection, String name) {
        super(connection, null, name);
    }

    public Data getParent() {
        throw new IllegalStateException("getParent() can not be called for snapshots.");
    }

    protected void update(Configuration configuration) throws ConfigurationException {
        super.update(configuration);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updated Instrument Sample snapshot '" + this.getName() + "' " + "to version " + this.getStateVersion());
        }
        int count = configuration.getAttributeAsInteger("count", this.getSize());
        this.m_samples = new int[count];
        String rawSamples = configuration.getChild("values").getValue("");
        StringTokenizer st = new StringTokenizer(rawSamples, ", ");
        for (int i = 0; st.hasMoreTokens() && i < this.m_samples.length; ++i) {
            int value;
            try {
                value = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.m_samples[i] = value;
        }
    }

    public boolean update() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("snapshot.xml?packed=true&name=" + this.urlEncode(this.getName()) + "&compact=true");
        if (configuration != null) {
            try {
                this.update(configuration);
                return true;
            }
            catch (ConfigurationException e) {
                this.getLogger().debug("Unable to update.", (Throwable)e);
            }
        }
        return false;
    }

    public int[] getSamples() {
        return this.m_samples;
    }
}

