/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.client.InstrumentManagerData;
import org.apache.excalibur.instrument.client.InstrumentableData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentableData;

class HTTPInstrumentManagerData
extends AbstractHTTPData
implements InstrumentManagerData {
    private String m_name;
    private boolean m_batchedUpdates;
    private boolean m_readOnly;
    private List m_instrumentables = new ArrayList();
    private HTTPInstrumentableData[] m_instrumentableAry;
    private Map m_instrumentableMap = new HashMap();

    HTTPInstrumentManagerData(HTTPInstrumentManagerConnection connection) {
        super(connection, connection.getURL().toExternalForm());
        this.m_name = connection.getURL().toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Configuration configuration, boolean recurse) throws ConfigurationException {
        super.update(configuration);
        this.m_name = configuration.getAttribute("name");
        this.m_batchedUpdates = configuration.getAttributeAsBoolean("batched-updates", false);
        this.m_readOnly = configuration.getAttributeAsBoolean("read-only", false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updated InstrumentManager '" + this.getName() + "' to version " + this.getStateVersion());
        }
        Configuration[] instrumentableConfs = configuration.getChildren("instrumentable");
        for (int i = 0; i < instrumentableConfs.length; ++i) {
            HTTPInstrumentableData iaData;
            Configuration iaConf = instrumentableConfs[i];
            String iaName = iaConf.getAttribute("name");
            int iaStateVersion = iaConf.getAttributeAsInteger("state-version");
            List list = this.m_instrumentables;
            synchronized (list) {
                iaData = (HTTPInstrumentableData)this.m_instrumentableMap.get(iaName);
                if (iaData == null) {
                    iaData = new HTTPInstrumentableData(this, iaName);
                    iaData.enableLogging(this.getLogger().getChildLogger(iaName));
                    this.m_instrumentables.add(iaData);
                    this.m_instrumentableAry = null;
                    this.m_instrumentableMap.put(iaName, iaData);
                }
            }
            if (recurse) {
                iaData.update(iaConf, recurse);
                continue;
            }
            if (iaStateVersion == iaData.getStateVersion()) continue;
            iaData.update();
        }
    }

    public boolean update() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("instrument-manager.xml?packed=true");
        if (configuration != null) {
            try {
                this.update(configuration, false);
                return true;
            }
            catch (ConfigurationException e) {
                this.getLogger().debug("Unable to update.", (Throwable)e);
            }
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    private boolean isSupportsBatchedUpdates() {
        return this.m_batchedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentableData[] getInstrumentables() {
        InstrumentableData[] instrumentables = this.m_instrumentableAry;
        if (instrumentables == null) {
            List list = this.m_instrumentables;
            synchronized (list) {
                this.m_instrumentableAry = new HTTPInstrumentableData[this.m_instrumentables.size()];
                this.m_instrumentables.toArray(this.m_instrumentableAry);
                instrumentables = this.m_instrumentableAry;
            }
        }
        return instrumentables;
    }

    public boolean updateAll() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("instrument-manager.xml?packed=true&recurse=true");
        if (configuration != null) {
            try {
                this.update(configuration, true);
                return true;
            }
            catch (ConfigurationException e) {
                this.getLogger().debug("Unable to update.", (Throwable)e);
            }
        }
        return false;
    }

    public void createInstrumentSample(String instrumentName, String description, long interval, int sampleCount, long leaseTime, int sampleType) {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        connection.getState("create-sample.xml?name=" + this.urlEncode(instrumentName) + "&description=" + this.urlEncode(description) + "&interval=" + interval + "&size=" + sampleCount + "&lease=" + leaseTime + "&type=" + sampleType);
    }

    public void createInstrumentSamples(String[] instrumentNames, String[] descriptions, long[] intervals, int[] sampleCounts, long[] leaseTimes, int[] sampleTypes) {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        if (instrumentNames.length != descriptions.length || instrumentNames.length != intervals.length || instrumentNames.length != sampleCounts.length || instrumentNames.length != leaseTimes.length || instrumentNames.length != sampleTypes.length) {
            throw new IllegalArgumentException("Array lengths of all parameters must be equal.");
        }
        if (this.isSupportsBatchedUpdates()) {
            StringBuffer sb = new StringBuffer();
            sb.append("create-samples.xml?");
            for (int i = 0; i < instrumentNames.length; ++i) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append("name=");
                sb.append(this.urlEncode(instrumentNames[i]));
                sb.append("&description=");
                sb.append(this.urlEncode(descriptions[i]));
                sb.append("&interval=");
                sb.append(intervals[i]);
                sb.append("&size=");
                sb.append(sampleCounts[i]);
                sb.append("&lease=");
                sb.append(leaseTimes[i]);
                sb.append("&type=");
                sb.append(sampleTypes[i]);
            }
            connection.getState(sb.toString());
        } else {
            for (int i = 0; i < instrumentNames.length; ++i) {
                this.createInstrumentSample(instrumentNames[i], descriptions[i], intervals[i], sampleCounts[i], leaseTimes[i], sampleTypes[i]);
            }
        }
    }
}

