/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.client.Data;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;

abstract class AbstractHTTPData
extends AbstractLogEnabled
implements Data {
    private HTTPInstrumentManagerConnection m_connection;
    private String m_description;
    private int m_stateVersion;

    protected AbstractHTTPData(HTTPInstrumentManagerConnection connection, String description) {
        this.m_connection = connection;
        this.m_description = description;
        this.m_stateVersion = -1;
    }

    public InstrumentManagerConnection getConnection() {
        return this.m_connection;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getStateVersion() {
        return this.m_stateVersion;
    }

    protected void update(Configuration configuration) throws ConfigurationException {
        this.m_description = configuration.getAttribute("description", "");
        this.m_stateVersion = configuration.getAttributeAsInteger("state-version", 0);
    }

    protected String urlEncode(String val) {
        return this.m_connection.urlEncode(val);
    }
}

