/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.io.File;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;

public class Main {
    private static void showUsage() {
        System.out.println("Usage:");
        System.out.println("java -classpath {classpath} org.apache.excalibur.instrument.client.Main [-debug] [state file]");
        System.out.println();
        System.out.println("    -debug     - Enables debug output.");
        System.out.println("    state file - Name of a state file to read at startup.  Defaults to: ../conf/default.desktop");
        System.out.println();
    }

    public static void main(String[] args) {
        boolean debug = false;
        String defaultStateFileName = "../conf/default.desktop";
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                if (args[0].equalsIgnoreCase("-debug")) {
                    debug = true;
                    break;
                }
                defaultStateFileName = args[0];
                break;
            }
            case 2: {
                if (args[0].equalsIgnoreCase("-debug")) {
                    debug = true;
                } else {
                    Main.showUsage();
                    System.exit(1);
                }
                defaultStateFileName = args[1];
                break;
            }
            default: {
                Main.showUsage();
                System.exit(1);
            }
        }
        File defaultStateFile = new File(defaultStateFileName);
        InstrumentClientFrame client = new InstrumentClientFrame("Instrument Client");
        int logLevel = debug ? 0 : 1;
        client.enableLogging((Logger)new ConsoleLogger(logLevel));
        client.initialize();
        client.setDefaultStateFile(defaultStateFile);
        client.show();
    }
}

