/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import org.apache.avalon.framework.configuration.ConfigurationException;

public class InstrumentSampleUtils {
    public static int resolveInstrumentSampleType(String type) throws ConfigurationException {
        if (type.equalsIgnoreCase("max") || type.equalsIgnoreCase("maximum")) {
            return 103;
        }
        if (type.equalsIgnoreCase("min") || type.equalsIgnoreCase("minimum")) {
            return 102;
        }
        if (type.equalsIgnoreCase("mean")) {
            return 104;
        }
        if (type.equalsIgnoreCase("ctr") || type.equalsIgnoreCase("counter")) {
            return 101;
        }
        throw new ConfigurationException("'" + type + "' is not a valid sample type.");
    }

    public static String getInstrumentSampleTypeName(int type) {
        switch (type) {
            case 103: {
                return "maximum";
            }
            case 102: {
                return "minimum";
            }
            case 104: {
                return "mean";
            }
            case 101: {
                return "counter";
            }
        }
        return "unknown-" + type;
    }

    public static String generateInstrumentSampleName(int sampleType, long sampleInterval, int sampleSize) {
        return InstrumentSampleUtils.getInstrumentSampleTypeName(sampleType) + "_" + sampleInterval + "_" + sampleSize;
    }

    public static String generateFullInstrumentSampleName(String instrumentName, int sampleType, long sampleInterval, int sampleSize) {
        return instrumentName + "." + InstrumentSampleUtils.generateInstrumentSampleName(sampleType, sampleInterval, sampleSize);
    }

    public static String getDefaultDescriptionForType(int type, long interval) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 101: {
                sb.append("Count each ");
                break;
            }
            case 103: {
                sb.append("Max Value each ");
                break;
            }
            case 104: {
                sb.append("Mean Value each ");
                break;
            }
            case 102: {
                sb.append("Min Value each ");
                break;
            }
            default: {
                return "Unknown Type " + type;
            }
        }
        if (interval == 1000L) {
            sb.append("Second");
        } else if (interval == 60000L) {
            sb.append("Minute");
        } else if (interval == 3600000L) {
            sb.append("Hour");
        } else if (interval == 86400000L) {
            sb.append("Day");
        } else if (interval % 86400000L == 0L) {
            sb.append(interval / 86400000L);
            sb.append(" Days");
        } else if (interval % 3600000L == 0L) {
            sb.append(interval / 3600000L);
            sb.append(" Hours");
        } else if (interval % 60000L == 0L) {
            sb.append(interval / 60000L);
            sb.append(" Minutes");
        } else if (interval % 1000L == 0L) {
            sb.append(interval / 1000L);
            sb.append(" Seconds");
        } else {
            sb.append(interval);
            sb.append(" Milliseconds");
        }
        return sb.toString();
    }
}

