/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerTreeCellRenderer;
import org.apache.excalibur.instrument.client.NodeData;

class InstrumentManagerTree
extends JComponent {
    private final InstrumentManagerConnection m_connection;
    private final TreeModel m_treeModel;
    private final JTree m_tree;

    InstrumentManagerTree(InstrumentManagerConnection connection) {
        this.m_connection = connection;
        this.m_treeModel = this.m_connection.getTreeModel();
        this.m_tree = new JTree(this.m_treeModel);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new InstrumentManagerTreeCellRenderer());
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        this.m_tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                int row;
                if (event.isPopupTrigger() && (row = InstrumentManagerTree.this.m_tree.getRowForLocation(event.getX(), event.getY())) >= 0) {
                    InstrumentManagerTree.this.showNodePopup(row, event.getX(), event.getY());
                }
                if (event.getClickCount() == 2 && (row = InstrumentManagerTree.this.m_tree.getRowForLocation(event.getX(), event.getY())) >= 0) {
                    InstrumentManagerTree.this.nodeSelected(row);
                }
            }

            public void mousePressed(MouseEvent event) {
                int row;
                if (event.isPopupTrigger() && (row = InstrumentManagerTree.this.m_tree.getRowForLocation(event.getX(), event.getY())) >= 0) {
                    InstrumentManagerTree.this.showNodePopup(row, event.getX(), event.getY());
                }
            }

            public void mouseReleased(MouseEvent event) {
                int row;
                if (event.isPopupTrigger() && (row = InstrumentManagerTree.this.m_tree.getRowForLocation(event.getX(), event.getY())) >= 0) {
                    InstrumentManagerTree.this.showNodePopup(row, event.getX(), event.getY());
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    void dispose() {
        ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
        this.m_tree.setModel(null);
    }

    private void nodeSelected(int row) {
        DefaultMutableTreeNode treeNode;
        TreePath treePath = this.m_tree.getPathForRow(row);
        if (treePath.getLastPathComponent() instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf() && treeNode.getUserObject() instanceof NodeData) {
            NodeData nodeData = (NodeData)treeNode.getUserObject();
            nodeData.select();
        }
    }

    private void showNodePopup(int row, int mouseX, int mouseY) {
        NodeData nodeData;
        JPopupMenu popup;
        DefaultMutableTreeNode treeNode;
        TreePath treePath = this.m_tree.getPathForRow(row);
        if (treePath.getLastPathComponent() instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof NodeData && (popup = (nodeData = (NodeData)treeNode.getUserObject()).getPopupMenu()) != null) {
            Rectangle bounds = this.m_tree.getRowBounds(row);
            int x = mouseX;
            int y = mouseY;
            popup.show(this.m_tree, x, y);
        }
    }
}

