/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.URIAbsolutizer;

public abstract class AbstractSourceResolver
implements SourceResolver {
    protected URL m_baseURL;

    public void setBaseURL(URL baseurl) {
        this.m_baseURL = baseurl;
    }

    protected boolean isDebugEnabled() {
        return false;
    }

    protected void debug(String text) {
    }

    protected abstract SourceFactory getSourceFactory(String var1);

    protected void releaseSourceFactory(SourceFactory factory) {
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        if (this.isDebugEnabled()) {
            this.debug("Resolving '" + location + "' with base '" + baseURI + "' in context '" + this.m_baseURL + "'");
        }
        if (location == null) {
            throw new MalformedURLException("Invalid System ID");
        }
        if (null != baseURI && SourceUtil.indexOfSchemeColon(baseURI) == -1) {
            throw new MalformedURLException("BaseURI is not valid, it must contain a protocol: " + baseURI);
        }
        if (baseURI == null) {
            baseURI = this.m_baseURL.toExternalForm();
        }
        String systemID = location;
        if (location.length() > 1 && location.charAt(1) == ':') {
            systemID = "file:/" + location;
        } else if (location.length() > 2 && location.charAt(0) == '/' && location.charAt(2) == ':') {
            systemID = "file:" + location;
        }
        int protocolPos = SourceUtil.indexOfSchemeColon(systemID);
        String protocol = protocolPos != -1 ? systemID.substring(0, protocolPos) : ((protocolPos = SourceUtil.indexOfSchemeColon(baseURI)) != -1 ? baseURI.substring(0, protocolPos) : "*");
        Source source = null;
        SourceFactory factory = null;
        try {
            factory = this.getSourceFactory(protocol);
            if (factory != null) {
                systemID = this.absolutize(factory, baseURI, systemID);
                if (this.isDebugEnabled()) {
                    this.debug("Resolved to systemID : " + systemID);
                }
                source = factory.getSource(systemID, parameters);
            }
        }
        finally {
            this.releaseSourceFactory(factory);
        }
        if (null == source) {
            try {
                factory = this.getSourceFactory("*");
                if (factory == null) {
                    throw new SourceException("Unable to select source factory for '" + systemID + "'. No default factory found.");
                }
                systemID = this.absolutize(factory, baseURI, systemID);
                if (this.isDebugEnabled()) {
                    this.debug("Resolved to systemID : " + systemID);
                }
                source = factory.getSource(systemID, parameters);
            }
            finally {
                this.releaseSourceFactory(factory);
            }
        }
        return source;
    }

    private String absolutize(SourceFactory factory, String baseURI, String systemID) {
        systemID = factory instanceof URIAbsolutizer ? ((URIAbsolutizer)((Object)factory)).absolutize(baseURI, systemID) : SourceUtil.absolutize(baseURI, systemID);
        return systemID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Source source) {
        if (source == null) {
            return;
        }
        String scheme = source.getScheme();
        SourceFactory factory = null;
        try {
            factory = this.getSourceFactory(scheme);
            if (factory == null && (factory = this.getSourceFactory("*")) == null) {
                throw new RuntimeException("Unable to select source factory for '" + source.getURI() + "'.");
            }
            factory.release(source);
        }
        finally {
            this.releaseSourceFactory(factory);
        }
    }
}

