/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringUtils {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    public static final String lineSeparator;

    public static String packageOf(Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("StringUtils: Argument \"aClass\" cannot be null.");
        }
        String result = "";
        int index = aClass.getName().lastIndexOf(".");
        if (index >= 0) {
            result = aClass.getName().substring(0, index);
        }
        return result;
    }

    public static String nameOf(Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("StringUtils: Argument \"aClass\" cannot be null.");
        }
        String className = aClass.getName();
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            className = className.substring(index + 1);
        }
        return className;
    }

    public static String pathOf(String aRoot, String aPath) {
        if (aPath == null) {
            throw new IllegalArgumentException("StringUtils: Argument \"aPath\" cannot be null.");
        }
        String result = null;
        if (aPath.startsWith("/") || aPath.startsWith("\\") || aPath.length() >= 2 && aPath.charAt(1) == ':') {
            result = aPath;
        } else {
            if (aRoot == null) {
                throw new IllegalArgumentException("StringUtils: Argument \"aRoot\" cannot be null.");
            }
            StringBuffer temp = new StringBuffer(aRoot);
            if (!aRoot.endsWith("/") && !aRoot.endsWith("\\")) {
                temp.append('/');
            }
            temp.append(aPath);
            result = temp.toString();
        }
        return result.toString();
    }

    public static Boolean booleanOf(String aValue) {
        Boolean result = null;
        if (aValue != null) {
            if (aValue == "true" || aValue == "yes" || aValue.equalsIgnoreCase("true") || aValue.equalsIgnoreCase("yes")) {
                result = Boolean.TRUE;
            } else if (aValue == "false" || aValue == "no" || aValue.equalsIgnoreCase("false") || aValue.equalsIgnoreCase("no")) {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    public static String replace(String source, String pattern, String replace) {
        if (source == null || source.length() == 0 || pattern == null || pattern.length() == 0) {
            return source;
        }
        int k = source.indexOf(pattern);
        if (k == -1) {
            return source;
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        int l = pattern.length();
        while (k != -1) {
            out.append(source.substring(i, k));
            if (replace != null) {
                out.append(replace);
            }
            i = k + l;
            k = source.indexOf(pattern, i);
        }
        out.append(source.substring(i));
        return out.toString();
    }

    public static void newLine(StringBuffer buffer, int indent) {
        buffer.append(lineSeparator);
        StringUtils.indent(buffer, indent);
    }

    public static void indent(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
    }

    public static String encode(String s) {
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                out.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('x');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    public static String decode(String s) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    if (s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '9' && s.charAt(i + 2) >= '0' && s.charAt(i + 2) <= '9') {
                        try {
                            sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException();
                        }
                        i += 2;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        try {
            byte[] inputBytes = result.getBytes("8859_1");
            result = new String(inputBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String[] copy(String[] source) {
        if (source == null) {
            return null;
        }
        int length = source.length;
        String[] result = new String[length];
        System.arraycopy(source, 0, result, 0, length);
        return result;
    }

    public static Map copyParameters(Map parameters) {
        HashMap result = new HashMap(parameters);
        Iterator iter = result.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Parameter map keys must not be null and of type java.lang.String.");
            }
            try {
                entry.setValue(StringUtils.copy((String[])entry.getValue()));
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Parameter map values must not be null and of type java.lang.String[].");
            }
        }
        return result;
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        lineSeparator = System.getProperty("line.separator");
    }
}

