/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.information.PortletURLProvider;
import org.apache.pluto.util.StringUtils;

public class PortletURLImpl
implements PortletURL {
    protected DynamicInformationProvider provider;
    protected PortletMode mode = null;
    protected Map parameters = new HashMap();
    protected PortletWindow portletWindow;
    protected boolean secure;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected WindowState state;
    protected boolean isAction;

    public PortletURLImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean isAction) {
        this.portletWindow = portletWindow;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.secure = servletRequest.isSecure();
        this.isAction = isAction;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.provider == null) {
            this.provider = InformationProviderAccess.getDynamicProvider(this.servletRequest);
        }
        if (windowState != null && this.provider.isWindowStateAllowed(windowState)) {
            this.state = windowState;
            return;
        }
        throw new WindowStateException("unsupported Window State used: " + windowState, windowState);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.provider == null) {
            this.provider = InformationProviderAccess.getDynamicProvider(this.servletRequest);
        }
        if (portletMode != null && this.provider.isPortletModeAllowed(portletMode) && this.isPortletModeSupported(portletMode, this.portletWindow)) {
            this.mode = portletMode;
            return;
        }
        throw new PortletModeException("unsupported Portlet Mode used: " + portletMode, portletMode);
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must not be null");
        }
        this.parameters.put(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        if (name == null || values == null || values.length == 0) {
            throw new IllegalArgumentException("name and values must not be null or values be an empty array");
        }
        this.parameters.put(name, StringUtils.copy(values));
    }

    public void setParameters(Map parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        Iterator iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Key must not be null and of type java.lang.String.");
            }
            if (entry.getValue() instanceof String[]) continue;
            throw new IllegalArgumentException("Value must not be null and of type java.lang.String[].");
        }
        this.parameters = StringUtils.copyParameters(parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.secure = secure;
    }

    public String toString() {
        StringBuffer url = new StringBuffer(200);
        PortletURLProvider urlProvider = InformationProviderAccess.getDynamicProvider(this.servletRequest).getPortletURLProvider(this.portletWindow);
        if (this.mode != null) {
            urlProvider.setPortletMode(this.mode);
        }
        if (this.state != null) {
            urlProvider.setWindowState(this.state);
        }
        if (this.isAction) {
            urlProvider.setAction();
        }
        if (this.secure) {
            urlProvider.setSecure();
        }
        urlProvider.clearParameters();
        urlProvider.setParameters(this.parameters);
        url.append(((Object)urlProvider).toString());
        return url.toString();
    }

    private boolean isPortletModeSupported(PortletMode requestedPortletMode, PortletWindow referencedPortletWindow) {
        if (requestedPortletMode.equals((Object)PortletMode.VIEW) || requestedPortletMode.toString().equalsIgnoreCase("view")) {
            return true;
        }
        PortletDefinition portletDefinition = referencedPortletWindow.getPortletEntity().getPortletDefinition();
        ContentTypeSet contentTypes = portletDefinition.getContentTypeSet();
        return contentTypes.supportsPortletMode(requestedPortletMode);
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public String[] getParameters(String name) {
        return (String[])this.parameters.get(name);
    }

    public PortletMode getPortletMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.state;
    }
}

