/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util.resourcekind;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.DaslConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlledImpl;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlledImpl;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliantCollectionImpl;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliantUnmappedUrlImpl;
import org.apache.slide.webdav.util.resourcekind.PrincipalImpl;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.VersionHistoryImpl;
import org.apache.slide.webdav.util.resourcekind.VersionImpl;
import org.apache.slide.webdav.util.resourcekind.VersionableImpl;
import org.apache.slide.webdav.util.resourcekind.WorkingImpl;
import org.apache.slide.webdav.util.resourcekind.WorkspaceImpl;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractResourceKind
implements ResourceKind,
WebdavConstants,
DeltavConstants,
AclConstants,
DaslConstants,
BindConstants {
    public static final String EMPTY_STRING = "";
    protected static Set supportedFeatures = new HashSet();
    protected static Set liveProperties = new HashSet();
    protected static Set protectedProperties = new HashSet();
    protected static Set computedProperties = new HashSet();
    protected static final String[] SUPPORTED_AUTO_VERSION_ELEMENTS = new String[]{"", "checkout", "checkout-ignore-unlock", "checkout-checkin", "checkout-unlocked-checkin", "locked-checkout"};
    protected static final String[] SUPPORTED_CHECKOUT_FORK_ELEMENTS = new String[]{"", "discouraged", "forbidden"};
    protected static final String[] SUPPORTED_CHECKIN_FORK_ELEMENTS = new String[]{"", "discouraged", "forbidden"};
    protected static final List SUPPORTED_AUTO_VERSION_ELEMENTS_LIST = Collections.unmodifiableList(Arrays.asList(SUPPORTED_AUTO_VERSION_ELEMENTS));
    protected static final List SUPPORTED_CHECKOUT_FORK_ELEMENTS_LIST = Collections.unmodifiableList(Arrays.asList(SUPPORTED_CHECKOUT_FORK_ELEMENTS));
    protected static final List SUPPORTED_CHECKIN_FORK_ELEMENTS_LIST = Collections.unmodifiableList(Arrays.asList(SUPPORTED_CHECKIN_FORK_ELEMENTS));
    protected static final Map RESTRICTED_PROPERTY_VALUE_MAP = new HashMap();

    public static ResourceKind getInstance() {
        return null;
    }

    public static ResourceKind determineResourceKind(NamespaceAccessToken nsaToken, NodeRevisionDescriptors nrds, NodeRevisionDescriptor nrd) {
        UriHandler uh = UriHandler.getUriHandler(nrds, nrd);
        return AbstractResourceKind.determineResourceKind(nsaToken, uh.toString(), nrd);
    }

    public static ResourceKind determineResourceKind(NamespaceAccessToken nsaToken, String resourcePath, NodeRevisionDescriptor nrd) {
        UriHandler uh = UriHandler.getUriHandler(resourcePath);
        NamespaceConfig config = nsaToken.getNamespaceConfig();
        if (nrd == null) {
            return DeltavCompliantUnmappedUrlImpl.getInstance();
        }
        if (uh.isHistoryUri()) {
            return VersionHistoryImpl.getInstance();
        }
        if (uh.isVersionUri()) {
            return VersionImpl.getInstance();
        }
        if (uh.isWorkspaceUri()) {
            return WorkspaceImpl.getInstance();
        }
        if (uh.isWorkingresourceUri()) {
            return WorkingImpl.getInstance();
        }
        if (nrd.exists("checked-in")) {
            return CheckedInVersionControlledImpl.getInstance();
        }
        if (nrd.exists("checked-out")) {
            return CheckedOutVersionControlledImpl.getInstance();
        }
        if (config.isPrincipal(resourcePath)) {
            return PrincipalImpl.getInstance();
        }
        if (nrd.propertyValueContains("resourcetype", "collection")) {
            return DeltavCompliantCollectionImpl.getInstance();
        }
        return VersionableImpl.getInstance();
    }

    protected static boolean isSupportedFeature(String feature) {
        return supportedFeatures.contains(feature);
    }

    protected static boolean isSupportedFeature(String feature, String[] excludedFeatures) {
        return supportedFeatures.contains(feature) && Arrays.binarySearch(excludedFeatures, feature) < 0;
    }

    public static boolean isLiveProperty(String propName) {
        return liveProperties.contains(propName);
    }

    public static boolean isProtectedProperty(String propName) {
        return protectedProperties.contains(propName);
    }

    public static boolean isComputedProperty(String propName) {
        return computedProperties.contains(propName);
    }

    public static Set getAllLiveProperties() {
        return Collections.unmodifiableSet(liveProperties);
    }

    public static Set getAllProtectedProperties() {
        return Collections.unmodifiableSet(protectedProperties);
    }

    public static Set getAllComputedProperties() {
        return Collections.unmodifiableSet(computedProperties);
    }

    public Set getSupportedLiveProperties() {
        return this.getSupportedLiveProperties(new String[0]);
    }

    public Set getSupportedLiveProperties(String filter) {
        Set s = this.getSupportedLiveProperties(new String[0]);
        if ("computed-only".equals(filter)) {
            s.retainAll(computedProperties);
        }
        if ("protected-only".equals(filter)) {
            s.retainAll(protectedProperties);
        }
        return s;
    }

    public Set getSupportedLiveProperties(String[] excludedFeatures) {
        HashSet s = new HashSet();
        Iterator it = this.getSuperKinds().iterator();
        while (it.hasNext()) {
            ResourceKind superkind = (ResourceKind)it.next();
            s.addAll(superkind.getSupportedLiveProperties(excludedFeatures));
        }
        return s;
    }

    public Set getSupportedLiveProperties(String filter, String[] excludedFeatures) {
        Set s = this.getSupportedLiveProperties(excludedFeatures);
        if ("computed-only".equals(filter)) {
            s.retainAll(computedProperties);
        }
        if ("protected-only".equals(filter)) {
            s.retainAll(protectedProperties);
        }
        return s;
    }

    public Set getSupportedMethods() {
        HashSet result = new HashSet();
        Iterator it = this.getSuperKinds().iterator();
        while (it.hasNext()) {
            ResourceKind superkind = (ResourceKind)it.next();
            result.addAll(superkind.getSupportedMethods());
        }
        return result;
    }

    public boolean isSupportedLiveProperty(String prop) {
        return this.getSupportedLiveProperties().contains(prop);
    }

    public boolean isSupportedMethod(String method) {
        return this.getSupportedMethods().contains(method);
    }

    public Set getSupportedReports() {
        HashSet result = new HashSet();
        Iterator it = this.getSuperKinds().iterator();
        while (it.hasNext()) {
            ResourceKind superkind = (ResourceKind)it.next();
            result.addAll(superkind.getSupportedReports());
        }
        return result;
    }

    public boolean isSupportedPropertyValue(String propertyName, Object value) {
        boolean isSupported = true;
        List listOfRestrictedValues = (List)RESTRICTED_PROPERTY_VALUE_MAP.get(propertyName);
        if (listOfRestrictedValues != null) {
            if (value == null) {
                return false;
            }
            if (EMPTY_STRING.equals(value.toString())) {
                return listOfRestrictedValues.contains(EMPTY_STRING);
            }
            XMLValue xmlValue = null;
            if (value instanceof XMLValue) {
                xmlValue = (XMLValue)value;
            } else {
                try {
                    xmlValue = new XMLValue(value.toString());
                }
                catch (JDOMException e) {
                    return false;
                }
            }
            isSupported = xmlValue.size() > 0 && listOfRestrictedValues.contains(((Element)xmlValue.iterator().next()).getName());
        }
        return isSupported;
    }

    public String toString() {
        return this.plainClassName(this.getClass());
    }

    protected List getSuperKinds() {
        ArrayList<Object> result = new ArrayList<Object>();
        Class<?> myclass = this.getClass();
        String myclassName = this.plainClassName(myclass);
        Class<?>[] ifs = myclass.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            Class<?> myif = ifs[i];
            String myifName = this.plainClassName(myif);
            if (!myclassName.startsWith(myifName)) continue;
            Class<?>[] superifs = myif.getInterfaces();
            for (int j = 0; j < superifs.length; ++j) {
                Class<?> superif = superifs[j];
                String superifName = this.plainClassName(superif);
                if ("ResourceKind".equals(superifName)) continue;
                Class<?> superclass = null;
                Object superkind = null;
                try {
                    superclass = Class.forName(superif.getName() + "Impl");
                    Class[] ptypes = new Class[]{};
                    Method facmeth = superclass.getMethod("getInstance", ptypes);
                    Object[] parms = new Object[]{};
                    result.add(facmeth.invoke(null, parms));
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    throw new IllegalStateException(x.getMessage());
                }
            }
        }
        return result;
    }

    private String plainClassName(Class c) {
        String n = c.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public static void main(String[] args) {
        String rkn = args[0];
        Class[] pt = new Class[]{};
        Object[] p = new Object[]{};
        if (rkn == null || rkn.length() == 0) {
            return;
        }
        try {
            Class<?> rkc = Class.forName("org.apache.slide.webdav.util.resourcekind." + rkn + "Impl");
            ResourceKind rk = (ResourceKind)rkc.getMethod("getInstance", pt).invoke(null, p);
            System.out.println("\nResource kind: " + rk);
            System.out.println("\nSupported live properties:");
            Iterator i = rk.getSupportedLiveProperties().iterator();
            while (i.hasNext()) {
                System.out.println("- " + i.next());
            }
            System.out.println("\nSupported methods:");
            i = rk.getSupportedMethods().iterator();
            while (i.hasNext()) {
                System.out.println("- " + i.next());
            }
            System.out.println("\nSupported reports:");
            i = rk.getSupportedReports().iterator();
            while (i.hasNext()) {
                System.out.println("- " + i.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static {
        supportedFeatures.add("1");
        supportedFeatures.add("slide");
        if (Configuration.useIntegratedLocking()) {
            supportedFeatures.add("2");
        }
        if (Configuration.useIntegratedSecurity()) {
            supportedFeatures.add("access-control");
        }
        if (Configuration.useSearch()) {
            supportedFeatures.add("searching-and-locating");
        }
        if (Configuration.useVersionControl()) {
            supportedFeatures.add("version-control");
            supportedFeatures.add("version-history");
            supportedFeatures.add("checkout-in-place");
            supportedFeatures.add("workspace");
            supportedFeatures.add("working-resource");
            supportedFeatures.add("label");
            supportedFeatures.add("update");
        }
        if (Configuration.useGlobalBinding()) {
            supportedFeatures.add("binding");
        }
        computedProperties.add("acl");
        computedProperties.add("acl-restrictions");
        computedProperties.add("activity-checkout-set");
        computedProperties.add("activity-version-set");
        computedProperties.add("baseline-controlled-collection-set");
        computedProperties.add("creationuser");
        computedProperties.add("current-user-privilege-set");
        computedProperties.add("current-workspace-set");
        computedProperties.add("eclipsed-set");
        computedProperties.add("group-membership");
        computedProperties.add("inherited-acl-set");
        computedProperties.add("lockdiscovery");
        computedProperties.add("modificationuser");
        computedProperties.add("owner");
        computedProperties.add("principal-collection-set");
        computedProperties.add("privilege-collection-set");
        computedProperties.add("root-version");
        computedProperties.add("successor-set");
        computedProperties.add("supportedlock");
        computedProperties.add("supported-live-property-set");
        computedProperties.add("supported-method-set");
        computedProperties.add("supported-privilege-set");
        computedProperties.add("supported-report-set");
        computedProperties.add("version-controlled-configuration");
        computedProperties.add("version-history");
        computedProperties.add("workspace");
        computedProperties.add("workspace-checkout-set");
        protectedProperties.addAll(computedProperties);
        protectedProperties.add("alternate-URI-set");
        protectedProperties.add("auto-update");
        protectedProperties.add("baseline-collection");
        protectedProperties.add("baseline-controlled-collection");
        protectedProperties.add("checked-in");
        protectedProperties.add("checked-out");
        protectedProperties.add("checkout-set");
        protectedProperties.add("creationdate");
        protectedProperties.add("modificationdate");
        protectedProperties.add("getlastmodified");
        protectedProperties.add("getcontentlength");
        protectedProperties.add("getetag");
        protectedProperties.add("label-name-set");
        protectedProperties.add("parent-set");
        protectedProperties.add("predecessor-set");
        protectedProperties.add("resource-id");
        protectedProperties.add("resourcetype");
        protectedProperties.add("source");
        protectedProperties.add("subbaseline-set");
        protectedProperties.add("version-controlled-binding-set");
        protectedProperties.add("version-name");
        protectedProperties.add("version-set");
        protectedProperties.add("privilege-membership");
        liveProperties.addAll(WebdavConstants.WEBDAV_PROPERTY_LIST);
        liveProperties.addAll(AclConstants.ACL_PROPERTY_LIST);
        liveProperties.addAll(DeltavConstants.DELTAV_PROPERTY_LIST);
        liveProperties.addAll(BindConstants.BIND_PROPERTY_LIST);
        RESTRICTED_PROPERTY_VALUE_MAP.put("auto-version", SUPPORTED_AUTO_VERSION_ELEMENTS_LIST);
        RESTRICTED_PROPERTY_VALUE_MAP.put("checkout-fork", SUPPORTED_CHECKOUT_FORK_ELEMENTS_LIST);
        RESTRICTED_PROPERTY_VALUE_MAP.put("checkin-fork", SUPPORTED_CHECKIN_FORK_ELEMENTS_LIST);
    }
}

