/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.Hashtable;

public class WebdavStatus {
    private static Hashtable mapStatusCodes = new Hashtable();
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_PROCESSING = 102;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_TOO_LONG = 413;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static final int SC_METHOD_FAILURE = 420;
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    public static final int SC_LOCKED = 423;
    public static final int SC_FAILED_DEPENDENCY = 424;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int SC_INSUFFICIENT_STORAGE = 507;

    public static String getStatusText(int nHttpStatusCode) {
        Integer intKey = new Integer(nHttpStatusCode);
        if (!mapStatusCodes.containsKey(intKey)) {
            return null;
        }
        return (String)mapStatusCodes.get(intKey);
    }

    private static void addStatusCodeMap(int nKey, String strVal) {
        mapStatusCodes.put(new Integer(nKey), strVal);
    }

    static {
        WebdavStatus.addStatusCodeMap(200, "OK");
        WebdavStatus.addStatusCodeMap(201, "Created");
        WebdavStatus.addStatusCodeMap(202, "Accepted");
        WebdavStatus.addStatusCodeMap(204, "No Content");
        WebdavStatus.addStatusCodeMap(301, "Moved Permanently");
        WebdavStatus.addStatusCodeMap(302, "Moved Temporarily");
        WebdavStatus.addStatusCodeMap(304, "Not Modified");
        WebdavStatus.addStatusCodeMap(400, "Bad Request");
        WebdavStatus.addStatusCodeMap(401, "Unauthorized");
        WebdavStatus.addStatusCodeMap(403, "Forbidden");
        WebdavStatus.addStatusCodeMap(404, "Not Found");
        WebdavStatus.addStatusCodeMap(500, "Internal Server Error");
        WebdavStatus.addStatusCodeMap(501, "Not Implemented");
        WebdavStatus.addStatusCodeMap(502, "Bad Gateway");
        WebdavStatus.addStatusCodeMap(503, "Service Unavailable");
        WebdavStatus.addStatusCodeMap(100, "Continue");
        WebdavStatus.addStatusCodeMap(405, "Method Not Allowed");
        WebdavStatus.addStatusCodeMap(406, "Not Acceptable");
        WebdavStatus.addStatusCodeMap(409, "Conflict");
        WebdavStatus.addStatusCodeMap(412, "Precondition Failed");
        WebdavStatus.addStatusCodeMap(413, "Request Too Long");
        WebdavStatus.addStatusCodeMap(415, "Unsupported Media Type");
        WebdavStatus.addStatusCodeMap(416, "Requested Range Not Satisfiable");
        WebdavStatus.addStatusCodeMap(101, "Switching Protocols");
        WebdavStatus.addStatusCodeMap(203, "Non Authoritative Information");
        WebdavStatus.addStatusCodeMap(205, "Reset Content");
        WebdavStatus.addStatusCodeMap(504, "Gateway Timeout");
        WebdavStatus.addStatusCodeMap(505, "Http Version Not Supported");
        WebdavStatus.addStatusCodeMap(102, "Processing");
        WebdavStatus.addStatusCodeMap(207, "Multi-Status");
        WebdavStatus.addStatusCodeMap(422, "Unprocessable Entity");
        WebdavStatus.addStatusCodeMap(419, "Insufficient Space On Resource");
        WebdavStatus.addStatusCodeMap(420, "Method Failure");
        WebdavStatus.addStatusCodeMap(423, "Locked");
        WebdavStatus.addStatusCodeMap(507, "Insufficient Storage");
        WebdavStatus.addStatusCodeMap(424, "Failed Dependency");
    }
}

