/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.security.ACLSecurityImpl;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.security.SecurityImpl;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.AbstractWebdavHelper;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.DaslConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.HistoryPathHandler;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.Activity;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliantCollection;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.apache.slide.webdav.util.resourcekind.VersionHistory;
import org.apache.slide.webdav.util.resourcekind.Workspace;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class PropertyHelper
extends AbstractWebdavHelper
implements WebdavConstants,
DeltavConstants,
AclConstants,
DaslConstants,
BindConstants {
    public static final String LOCKDISCOVERY_INCL_PRINCIPAL = "lockdiscoveryIncludesPrincipalURL";
    public static final String PRIVILEGE_NAMESPACE = "privilege-namespace";
    private boolean lockdiscoveryIncludesPrincipalURL = true;
    protected Element checkoutSetQueryElement = null;
    protected Element checkoutSetQueryLiteralElement = null;
    protected Element workspaceCheckoutSetQueryElement = null;
    protected Element workspaceCheckoutSetQueryHrefElement = null;
    private WebdavServletConfig sConf = null;

    public static PropertyHelper getPropertyHelper(SlideToken sToken, NamespaceAccessToken nsaToken, WebdavServletConfig sConf) {
        return new PropertyHelper(sToken, nsaToken, sConf);
    }

    protected PropertyHelper(SlideToken sToken, NamespaceAccessToken nsaToken, WebdavServletConfig sConf) {
        super(sToken, nsaToken);
        this.sConf = sConf;
        if (sConf != null) {
            this.lockdiscoveryIncludesPrincipalURL = !"false".equalsIgnoreCase(sConf.getInitParameter(LOCKDISCOVERY_INCL_PRINCIPAL));
        }
    }

    public List createInitialProperties(ResourceKind resourceKind, String resourcePath) {
        Set sp = resourceKind.getSupportedLiveProperties();
        ArrayList<NodeProperty> result = null;
        if (sp == null) {
            result = Collections.EMPTY_LIST;
        } else {
            result = new ArrayList<NodeProperty>();
            Iterator i = sp.iterator();
            while (i.hasNext()) {
                Object pvalue;
                String propName = (String)i.next();
                if (AbstractResourceKind.isComputedProperty(propName) || (pvalue = this.createDefaultValue(propName, resourceKind, resourcePath)) == null) continue;
                result.add(new NodeProperty(propName, pvalue));
            }
        }
        return result;
    }

    Object createDefaultValue(String propName, ResourceKind resourceKind, String resourcePath) {
        String autoVersion = Domain.getParameter((String)"auto-version", (String)"checkout-checkin", (Store)this.nsaToken.getUri(this.sToken, resourcePath).getStore());
        String checkoutFork = Domain.getParameter((String)"checkout-fork", (String)"forbidden", (Store)this.nsaToken.getUri(this.sToken, resourcePath).getStore());
        String checkinFork = Domain.getParameter((String)"checkin-fork", (String)"forbidden", (Store)this.nsaToken.getUri(this.sToken, resourcePath).getStore());
        String result = null;
        if ("resourcetype".equals(propName)) {
            StringBuffer rtvv = new StringBuffer();
            try {
                if (resourceKind instanceof VersionHistory) {
                    rtvv.append(xmlOut.outputString(new Element("version-history", DNSP)));
                    rtvv.append(xmlOut.outputString(new Element("collection", DNSP)));
                }
                if (resourceKind instanceof DeltavCompliantCollection) {
                    rtvv.append(xmlOut.outputString(new Element("collection", DNSP)));
                }
                if (resourceKind instanceof Activity) {
                    rtvv.append(xmlOut.outputString(new Element("activity", DNSP)));
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            result = rtvv.toString();
        } else if ("supported-method-set".equals(propName)) {
            Iterator i = resourceKind.getSupportedMethods().iterator();
            StringBuffer smsv = new StringBuffer();
            while (i.hasNext()) {
                String m = (String)i.next();
                Element sm = new Element("supported-method", DNSP);
                Attribute na = new Attribute("name", m, DNSP);
                sm.setAttribute(na);
                try {
                    smsv.append(xmlOut.outputString(sm));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            result = smsv.toString();
        } else if ("supported-live-property-set".equals(propName)) {
            Iterator i = resourceKind.getSupportedLiveProperties().iterator();
            StringBuffer spsv = new StringBuffer();
            while (i.hasNext()) {
                String p = (String)i.next();
                Element sp = new Element("supported-live-property", DNSP);
                Element na = new Element("name", DNSP);
                na.addContent(p);
                sp.addContent((org.jdom.Content)na);
                try {
                    spsv.append(xmlOut.outputString(sp));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            result = spsv.toString();
        } else if ("supported-report-set".equals(propName)) {
            Iterator i = resourceKind.getSupportedReports().iterator();
            StringBuffer srsv = new StringBuffer();
            while (i.hasNext()) {
                String r = (String)i.next();
                Element sr = new Element("supported-report", DNSP);
                Element na = new Element("name", DNSP);
                na.addContent(r);
                sr.addContent((org.jdom.Content)na);
                try {
                    srsv.append(xmlOut.outputString(sr));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            result = srsv.toString();
        } else if ("auto-version".equals(propName)) {
            XMLValue xmlValue = new XMLValue();
            if (autoVersion.length() > 0) {
                xmlValue.add(new Element(autoVersion, DNSP));
            }
            if (!resourceKind.isSupportedPropertyValue("auto-version", xmlValue)) {
                Domain.warn((Object)"Auto-version not configured properly; using checkout-checkin");
                xmlValue = new XMLValue(new Element("checkout-checkin", DNSP));
            }
            result = xmlValue.toString();
        } else if ("checkout-fork".equals(propName)) {
            XMLValue xmlValue = new XMLValue();
            if (checkoutFork.length() > 0) {
                xmlValue.add(new Element(checkoutFork, DNSP));
            }
            if (!resourceKind.isSupportedPropertyValue("checkout-fork", xmlValue)) {
                Domain.warn((Object)"Checkout-fork not configured properly; using forbidden");
                xmlValue = new XMLValue(new Element("forbidden", DNSP));
            }
            result = xmlValue.toString();
        } else if ("checkin-fork".equals(propName)) {
            XMLValue xmlValue = new XMLValue();
            if (checkinFork.length() > 0) {
                xmlValue.add(new Element(checkinFork, DNSP));
            }
            if (!resourceKind.isSupportedPropertyValue("checkin-fork", xmlValue)) {
                Domain.warn((Object)"Checkin-fork not configured properly; using forbidden");
                xmlValue = new XMLValue(new Element("forbidden", DNSP));
            }
            result = xmlValue.toString();
        } else if ("getcontentlanguage".equals(propName)) {
            result = "en";
        } else if ("creator-displayname".equals(propName)) {
            CredentialsToken credToken;
            if (this.sToken != null && (credToken = this.sToken.getCredentialsToken()) != null && ((result = credToken.getPublicCredentials()) == null || result.equals("") || result.equals("/"))) {
                result = "unauthenticated";
            }
        } else if ("predecessor-set".equals(propName)) {
            result = "";
        } else if ("checkout-set".equals(propName)) {
            result = "";
        } else if ("comment".equals(propName)) {
            result = "";
        } else if ("label-name-set".equals(propName)) {
            result = "";
        }
        return result;
    }

    public Object createCdataValue(String text) {
        StringBuffer b = new StringBuffer();
        if (text == null) {
            text = "";
        }
        b.append("![CDATA[").append(text).append("]]");
        return b.toString();
    }

    public Object createHrefValue(String uri) {
        String result = "";
        Element href = new Element("href", DNSP);
        href.addContent(uri);
        try {
            result = xmlOut.outputString(href);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return result;
    }

    public Object createHrefSetValue(List uriList) {
        StringBuffer b = new StringBuffer();
        Iterator i = uriList.iterator();
        while (i.hasNext()) {
            b.append(this.createHrefValue((String)i.next()));
        }
        return b.toString();
    }

    public Object createHrefSetValue(String rootElement, List uriList) {
        String result = "";
        Element root = new Element(rootElement, DNSP);
        Iterator i = uriList.iterator();
        while (i.hasNext()) {
            Element href = new Element("href", DNSP);
            href.addContent((String)i.next());
            root.addContent((org.jdom.Content)href);
        }
        try {
            result = xmlOut.outputString(root);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return result;
    }

    public Element parsePropertyValue(String propValue) throws JDOMException, IOException {
        Document d = xmlBuilder.build((Reader)new StringReader(propValue));
        return d.getRootElement();
    }

    public NodeProperty getProperty(String propertyName, String resourcePath) throws SlideException, JDOMException {
        return this.getProperty(propertyName, resourcePath, null);
    }

    public NodeProperty getProperty(String propertyName, String resourcePath, String slideContextPath) throws SlideException, JDOMException {
        UriHandler uriHandler = UriHandler.getUriHandler(resourcePath);
        String uri = null;
        NodeRevisionDescriptors revisionDescriptors = null;
        NodeRevisionDescriptor revisionDescriptor = null;
        Content contentHelper = this.nsaToken.getContentHelper();
        if (uriHandler.isVersionUri()) {
            uri = uriHandler.getAssociatedHistoryUri();
            NodeRevisionNumber revisionNumber = new NodeRevisionNumber(uriHandler.getVersionName());
            revisionDescriptors = contentHelper.retrieve(this.sToken, uri);
            revisionDescriptor = contentHelper.retrieve(this.sToken, revisionDescriptors, revisionNumber);
        } else if (uriHandler.isHistoryUri()) {
            uri = uriHandler.getAssociatedHistoryUri();
            NodeRevisionNumber revisionNumber = new NodeRevisionNumber("0.0");
            revisionDescriptors = contentHelper.retrieve(this.sToken, uri);
            revisionDescriptor = contentHelper.retrieve(this.sToken, revisionDescriptors, revisionNumber);
        } else {
            uri = resourcePath;
            revisionDescriptors = contentHelper.retrieve(this.sToken, uri);
            revisionDescriptor = contentHelper.retrieve(this.sToken, revisionDescriptors);
        }
        return this.getProperty(propertyName, revisionDescriptors, revisionDescriptor, slideContextPath);
    }

    public NodeProperty getProperty(String propertyName, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws SlideException, JDOMException {
        return this.getProperty(propertyName, revisionDescriptors, revisionDescriptor, null);
    }

    public NodeProperty getProperty(String propertyName, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws SlideException, JDOMException {
        NodeProperty property = revisionDescriptor.getProperty(propertyName);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind.isSupportedLiveProperty(propertyName) && AbstractResourceKind.isComputedProperty(propertyName)) {
            property = this.computeProperty(propertyName, revisionDescriptors, revisionDescriptor, slideContextPath);
        }
        return property;
    }

    public NodeProperty computeProperty(String propertyName, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws SlideException, JDOMException {
        NodeProperty property = null;
        if ("successor-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSuccessorSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("version-history".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeVersionHistory(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("root-version".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeRootVersion(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("supported-method-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedMethodSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("supported-live-property-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedLivePropertySet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("supported-report-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedReportSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("checkout-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeCheckoutSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("workspace-checkout-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeWorkspaceCheckoutSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("workspace".equals(propertyName)) {
            XMLValue ws = null;
            ws = Configuration.useBinding((Store)this.nsaToken.getUri(this.sToken, revisionDescriptors.getUri()).getStore()) ? this.computeWorkspace(revisionDescriptors, revisionDescriptor, slideContextPath) : this.computeWorkspaceNoBinding(revisionDescriptors, revisionDescriptor, slideContextPath);
            if (ws != null) {
                property = new NodeProperty(propertyName, (Object)ws);
            }
        } else if ("lockdiscovery".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeLockDiscovery(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("supportedlock".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedlock(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("supported-privilege-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeSupportedPrivilegeSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("current-user-privilege-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeCurrentuserPrivilegeSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("acl".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeAcl(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("principal-collection-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computePrincipalCollectionSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("privilege-collection-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computePrivilegeCollectionSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("owner".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeOwner(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("creationuser".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeCreationUser(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("modificationuser".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeModificationUser(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("inherited-acl-set".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeInheritedAclSet(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("acl-restrictions".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeAclRestrictions(revisionDescriptors, revisionDescriptor, slideContextPath));
        } else if ("group-membership".equals(propertyName)) {
            property = new NodeProperty(propertyName, (Object)this.computeGroupMembership(revisionDescriptors, revisionDescriptor, slideContextPath));
        }
        return property;
    }

    public XMLValue computeSuccessorSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        Element hrefElement = new Element("href", DNSP);
        NodeRevisionNumber successorRevisionNumber = null;
        Enumeration successorEnum = revisionDescriptors.getSuccessors(revisionDescriptor.getRevisionNumber());
        if (successorEnum != null) {
            while (successorEnum.hasMoreElements()) {
                successorRevisionNumber = (NodeRevisionNumber)successorEnum.nextElement();
                hrefElement = (Element)hrefElement.clone();
                StringBuffer buffer = new StringBuffer(revisionDescriptors.getUri());
                if (!revisionDescriptors.getUri().endsWith("/")) {
                    buffer.append("/");
                }
                buffer.append(successorRevisionNumber.toString());
                hrefElement.setText(WebdavUtils.getAbsolutePath(buffer.toString(), slideContextPath, this.sConf));
                xmlValue.add(hrefElement);
            }
        }
        return xmlValue;
    }

    public XMLValue computeVersionHistory(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof Version) {
            Element element = new Element("href", DNSP);
            element.setText(WebdavUtils.getAbsolutePath(revisionDescriptors.getUri(), slideContextPath, this.sConf));
            xmlValue.add(element);
        } else if (resourceKind instanceof CheckedInVersionControlled) {
            Element element = new Element("href", DNSP);
            String checkedInHref = revisionDescriptor.getProperty("checked-in").getValue().toString();
            String checkedInUri = ((Element)new XMLValue(checkedInHref).iterator().next()).getText();
            UriHandler uriHandler = UriHandler.getUriHandler(checkedInUri);
            element.setText(WebdavUtils.getAbsolutePath(uriHandler.getAssociatedHistoryUri(), slideContextPath, this.sConf));
            xmlValue.add(element);
        } else if (resourceKind instanceof CheckedOutVersionControlled) {
            Element element = new Element("href", DNSP);
            String checkedOutHref = revisionDescriptor.getProperty("checked-out").getValue().toString();
            String checkedOutUri = ((Element)new XMLValue(checkedOutHref).iterator().next()).getText();
            UriHandler uriHandler = UriHandler.getUriHandler(checkedOutUri);
            element.setText(WebdavUtils.getAbsolutePath(uriHandler.getAssociatedHistoryUri(), slideContextPath, this.sConf));
            xmlValue.add(element);
        }
        return xmlValue;
    }

    public XMLValue computeRootVersion(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof VersionHistory) {
            Element element = new Element("href", DNSP);
            StringBuffer buffer = new StringBuffer(revisionDescriptors.getUri());
            if (!revisionDescriptors.getUri().endsWith("/")) {
                buffer.append("/");
            }
            buffer.append(revisionDescriptors.getInitialRevision().toString());
            element.setText(WebdavUtils.getAbsolutePath(buffer.toString(), slideContextPath, this.sConf));
            xmlValue.add(element);
        }
        return xmlValue;
    }

    public XMLValue computeSupportedMethodSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        Set supportedMethodNames = resourceKind.getSupportedMethods();
        Iterator iterator = supportedMethodNames.iterator();
        Element supportedMethod = null;
        while (iterator.hasNext()) {
            supportedMethod = new Element("supported-method", DNSP);
            supportedMethod.setAttribute(new Attribute("name", (String)iterator.next()));
            xmlValue.add(supportedMethod);
        }
        return xmlValue;
    }

    public XMLValue computeSupportedLivePropertySet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        Set supportedLivePropertyNames = resourceKind.getSupportedLiveProperties();
        Iterator iterator = supportedLivePropertyNames.iterator();
        Element supportedLivePropertyElement = null;
        Element propElement = null;
        Element propertyElement = null;
        while (iterator.hasNext()) {
            supportedLivePropertyElement = new Element("supported-live-property", DNSP);
            propElement = new Element("prop", DNSP);
            supportedLivePropertyElement.addContent((org.jdom.Content)propElement);
            propertyElement = new Element((String)iterator.next(), DNSP);
            propElement.addContent((org.jdom.Content)propertyElement);
            xmlValue.add(supportedLivePropertyElement);
        }
        return xmlValue;
    }

    public XMLValue computeSupportedReportSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        Set supportedReportNames = resourceKind.getSupportedReports();
        Iterator iterator = supportedReportNames.iterator();
        Element supportedReportElement = null;
        Element reportElement = null;
        Element propertyElement = null;
        while (iterator.hasNext()) {
            supportedReportElement = new Element("supported-report", DNSP);
            reportElement = new Element("report", DNSP);
            supportedReportElement.addContent((org.jdom.Content)reportElement);
            propertyElement = new Element((String)iterator.next(), DNSP);
            reportElement.addContent((org.jdom.Content)propertyElement);
            xmlValue.add(supportedReportElement);
        }
        return xmlValue;
    }

    public XMLValue computeCheckoutSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws SlideException, JDOMException {
        return this.computeCheckoutSet(revisionDescriptors, revisionDescriptor, null);
    }

    public XMLValue computeCheckoutSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws SlideException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof Version) {
            String resourcePath = VersioningHelper.getUri(this.nsaToken, this.sToken, this.nsaToken.getContentHelper(), revisionDescriptors, revisionDescriptor);
            Element basicSearch = this.getCheckoutSetQueryElement(resourcePath);
            String grammarNamespace = basicSearch.getNamespaceURI();
            Search searchHelper = this.nsaToken.getSearchHelper();
            SearchQuery searchQuery = searchHelper.createSearchQuery(grammarNamespace, basicSearch, this.sToken, Integer.MAX_VALUE, slideContextPath);
            SearchQueryResult queryResult = searchHelper.search(this.sToken, searchQuery);
            Iterator queryResultIterator = queryResult.iterator();
            RequestedResource requestedResource = null;
            Element href = null;
            while (queryResultIterator.hasNext()) {
                requestedResource = (RequestedResource)queryResultIterator.next();
                href = new Element("href", DNSP);
                href.setText(WebdavUtils.getAbsolutePath(requestedResource.getUri(), slideContextPath, this.sConf));
                xmlValue.add(href);
            }
        }
        return xmlValue;
    }

    protected Element getCheckoutSetQueryElement(String resourcePath) throws SlideException {
        if (this.checkoutSetQueryElement == null) {
            this.checkoutSetQueryElement = new Element("basicsearch", DNSP);
            Element select = new Element("select", DNSP);
            this.checkoutSetQueryElement.addContent((org.jdom.Content)select);
            Element prop = new Element("prop", DNSP);
            select.addContent((org.jdom.Content)prop);
            Element checkedOut = new Element("checked-out", DNSP);
            prop.addContent((org.jdom.Content)checkedOut);
            Element from = new Element("from", DNSP);
            this.checkoutSetQueryElement.addContent((org.jdom.Content)from);
            Element scope = new Element("scope", DNSP);
            from.addContent((org.jdom.Content)scope);
            Element href = new Element("href", DNSP);
            scope.addContent((org.jdom.Content)href);
            href.setText("");
            Iterator excludeIterator = this.getNonVcrPathExcludeList().iterator();
            while (excludeIterator.hasNext()) {
                scope.addContent((org.jdom.Content)((Element)excludeIterator.next()));
            }
            Element where = new Element("where", DNSP);
            this.checkoutSetQueryElement.addContent((org.jdom.Content)where);
            Element propcontains = new Element("propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
            where.addContent((org.jdom.Content)propcontains);
            propcontains.addContent((org.jdom.Content)((Element)prop.clone()));
            this.checkoutSetQueryLiteralElement = new Element("literal", DNSP);
            propcontains.addContent((org.jdom.Content)this.checkoutSetQueryLiteralElement);
        }
        this.checkoutSetQueryLiteralElement.setText(resourcePath);
        return this.checkoutSetQueryElement;
    }

    public List getNonVcrPathExcludeList() {
        ArrayList excludeList = new ArrayList();
        String usersPath = PropertyHelper.truncateLeadingSlash(this.nsaToken.getNamespaceConfig().getUsersPath());
        this.addExcludeElement(usersPath, excludeList);
        String groupsPath = PropertyHelper.truncateLeadingSlash(this.nsaToken.getNamespaceConfig().getGroupsPath());
        this.addExcludeElement(groupsPath, excludeList);
        String rolesPath = PropertyHelper.truncateLeadingSlash(this.nsaToken.getNamespaceConfig().getRolesPath());
        this.addExcludeElement(rolesPath, excludeList);
        Iterator historyPathIterator = HistoryPathHandler.getHistoryPathHandler().getResolvedHistoryPaths().iterator();
        while (historyPathIterator.hasNext()) {
            String path = PropertyHelper.truncateLeadingSlash(historyPathIterator.next().toString());
            this.addExcludeElement(path, excludeList);
        }
        return excludeList;
    }

    private void addExcludeElement(String path, List excludeList) {
        if (path != null && path.length() > 0) {
            Element excludeElement = new Element("exclude", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
            excludeElement.setText(path);
            excludeList.add(excludeElement);
        }
    }

    public XMLValue computeWorkspaceNoBinding(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws SlideException, JDOMException {
        XMLValue result = null;
        UriHandler hrUh = UriHandler.getUriHandler(revisionDescriptors, revisionDescriptor);
        String associatedWsUri = hrUh.getAssociatedWorkspaceUri();
        if (associatedWsUri != null) {
            result = new XMLValue();
            Element hrElm = new Element("href", DNSP);
            hrElm.setText(associatedWsUri);
            result.add(hrElm);
        }
        return result;
    }

    public XMLValue computeWorkspace(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws SlideException, JDOMException {
        XMLValue result;
        block5: {
            NodeRevisionDescriptor nrd;
            NodeRevisionDescriptors nrds;
            result = null;
            UriHandler rUh = new UriHandler(revisionDescriptors.getUri());
            if (rUh.getAssociatedWorkspaceUri() != null) {
                result = new XMLValue();
                Element hrElm = new Element("href", DNSP);
                hrElm.setText(rUh.getAssociatedWorkspaceUri());
                result.add(hrElm);
                return result;
            }
            NodeProperty psProp = revisionDescriptor.getProperty("parent-set");
            if (psProp == null) {
                return new XMLValue();
            }
            ArrayList<UriHandler> psUris = new ArrayList<UriHandler>();
            XMLValue xv = new XMLValue(String.valueOf(psProp.getValue()));
            Iterator i = xv.getList().iterator();
            while (i.hasNext()) {
                Element pElm = (Element)i.next();
                UriHandler hrUh = new UriHandler(pElm.getChild("href", DNSP).getText());
                if (hrUh.getAssociatedWorkspaceUri() != null) {
                    result = new XMLValue();
                    Element hrElm = new Element("href", DNSP);
                    hrElm.setText(hrUh.getAssociatedWorkspaceUri());
                    result.add(hrElm);
                    break;
                }
                if (hrUh.isRootUri()) continue;
                psUris.add(hrUh);
            }
            if (result != null) break block5;
            i = psUris.iterator();
            while (i.hasNext() && (result = this.computeWorkspace(nrds = this.nsaToken.getContentHelper().retrieve(this.sToken, ((UriHandler)i.next()).getUri()), nrd = this.nsaToken.getContentHelper().retrieve(this.sToken, nrds), slideContextPath)) == null) {
            }
        }
        return result;
    }

    public XMLValue computeWorkspaceCheckoutSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws SlideException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, revisionDescriptors, revisionDescriptor);
        if (resourceKind instanceof Workspace) {
            Element basicSearch = this.getWorkspaceCheckoutSetQueryElement(revisionDescriptors.getUri());
            String grammarNamespace = basicSearch.getNamespaceURI();
            Search searchHelper = this.nsaToken.getSearchHelper();
            SearchQuery searchQuery = searchHelper.createSearchQuery(grammarNamespace, basicSearch, this.sToken, Integer.MAX_VALUE, slideContextPath);
            SearchQueryResult queryResult = searchHelper.search(this.sToken, searchQuery);
            Iterator queryResultIterator = queryResult.iterator();
            RequestedResource requestedResource = null;
            Element hrefElement = null;
            while (queryResultIterator.hasNext()) {
                requestedResource = (RequestedResource)queryResultIterator.next();
                hrefElement = new Element("href", DNSP);
                hrefElement.setText(WebdavUtils.getAbsolutePath(requestedResource.getUri(), slideContextPath, this.sConf));
                xmlValue.add(hrefElement);
            }
        }
        return xmlValue;
    }

    protected Element getWorkspaceCheckoutSetQueryElement(String scopePath) {
        if (this.workspaceCheckoutSetQueryElement == null) {
            this.workspaceCheckoutSetQueryElement = new Element("basicsearch", DNSP);
            Element select = new Element("select", DNSP);
            this.workspaceCheckoutSetQueryElement.addContent((org.jdom.Content)select);
            Element prop = new Element("prop", DNSP);
            select.addContent((org.jdom.Content)prop);
            Element checkedOut = new Element("checked-out", DNSP);
            prop.addContent((org.jdom.Content)checkedOut);
            Element from = new Element("from", DNSP);
            this.workspaceCheckoutSetQueryElement.addContent((org.jdom.Content)from);
            Element scope = new Element("scope", DNSP);
            from.addContent((org.jdom.Content)scope);
            this.workspaceCheckoutSetQueryHrefElement = new Element("href", DNSP);
            scope.addContent((org.jdom.Content)this.workspaceCheckoutSetQueryHrefElement);
            Element where = new Element("where", DNSP);
            this.workspaceCheckoutSetQueryElement.addContent((org.jdom.Content)where);
            Element isdefined = new Element("is-defined", DNSP);
            where.addContent((org.jdom.Content)isdefined);
            isdefined.addContent((org.jdom.Content)((Element)prop.clone()));
        }
        this.workspaceCheckoutSetQueryHrefElement.setText(PropertyHelper.truncateLeadingSlash(scopePath));
        return this.workspaceCheckoutSetQueryElement;
    }

    private XMLValue computeLockDiscovery(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ServiceAccessException, LinkedObjectNotFoundException, ObjectNotFoundException, LockTokenNotFoundException {
        XMLValue xmlValue = new XMLValue();
        Lock lock = this.nsaToken.getLockHelper();
        NodeLock objectLockToken = null;
        Enumeration lockTokens = lock.enumerateLocks(this.sToken, revisionDescriptors.getUri(), true);
        HashSet<String> addedLockIDs = new HashSet<String>();
        while (lockTokens.hasMoreElements()) {
            Element activelock;
            objectLockToken = (NodeLock)lockTokens.nextElement();
            if (!revisionDescriptors.getUri().equals(objectLockToken.getObjectUri()) && !objectLockToken.isInheritable() || addedLockIDs.contains(objectLockToken.getLockId()) || (activelock = this.createActiveLockElement(objectLockToken, slideContextPath)) == null) continue;
            xmlValue.add(activelock);
            addedLockIDs.add(objectLockToken.getLockId());
        }
        return xmlValue;
    }

    public XMLValue computeLockDiscovery(NodeLock objectLockToken, String slideContextPath) {
        XMLValue xmlValue = new XMLValue();
        Element activelock = this.createActiveLockElement(objectLockToken, slideContextPath);
        if (activelock != null) {
            xmlValue.add(activelock);
        }
        return xmlValue;
    }

    private Element createActiveLockElement(NodeLock objectLockToken, String slideContextPath) {
        Element activelock = null;
        if (objectLockToken != null) {
            activelock = new Element("activelock", DNSP);
            Element locktype = new Element("locktype", DNSP);
            activelock.addContent((org.jdom.Content)locktype);
            if (objectLockToken.isLocal()) {
                Element transaction = new Element("transaction", DNSP);
                Element groupoperation = new Element("groupoperation", DNSP);
                transaction.addContent((org.jdom.Content)groupoperation);
                locktype.addContent((org.jdom.Content)transaction);
            } else {
                Element write = new Element("write", DNSP);
                locktype.addContent((org.jdom.Content)write);
            }
            Element lockscope = new Element("lockscope", DNSP);
            activelock.addContent((org.jdom.Content)lockscope);
            Element lockscopeValue = null;
            if (objectLockToken.isExclusive()) {
                lockscopeValue = new Element("exclusive", DNSP);
            } else if (objectLockToken.isShared()) {
                lockscopeValue = new Element("shared", DNSP);
            } else if (objectLockToken.isLocal()) {
                lockscopeValue = new Element("local", DNSP);
            }
            lockscope.addContent((org.jdom.Content)lockscopeValue);
            Element depth = new Element("depth", DNSP);
            activelock.addContent((org.jdom.Content)depth);
            if (objectLockToken.isInheritable()) {
                depth.setText("infinity");
            } else {
                depth.setText("0");
            }
            Element owner = new Element("owner", DNSP);
            activelock.addContent((org.jdom.Content)owner);
            if (objectLockToken.getOwnerInfo() != null && !objectLockToken.getOwnerInfo().equals("")) {
                try {
                    Document d = new SAXBuilder().build((Reader)new StringReader(objectLockToken.getOwnerInfo()));
                    owner.addContent((org.jdom.Content)d.detachRootElement());
                }
                catch (Throwable e) {
                    owner.addContent((org.jdom.Content)new CDATA(objectLockToken.getOwnerInfo()));
                }
            }
            Element timeout = new Element("timeout", DNSP);
            activelock.addContent((org.jdom.Content)timeout);
            long seconds = new Long((objectLockToken.getExpirationDate().getTime() - new Date().getTime()) / 1000L);
            if ((double)seconds > 1.61061273525E9) {
                timeout.setText("Infinite");
            } else {
                timeout.setText("Second-" + seconds);
            }
            Element locktoken = new Element("locktoken", DNSP);
            activelock.addContent((org.jdom.Content)locktoken);
            Element href = new Element("href", DNSP);
            locktoken.addContent((org.jdom.Content)href);
            href.setText("opaquelocktoken:" + objectLockToken.getLockId());
            if (this.lockdiscoveryIncludesPrincipalURL) {
                Element principalUrl = new Element("principal-URL", DNSP);
                activelock.addContent((org.jdom.Content)principalUrl);
                SubjectNode snode = SubjectNode.getSubjectNode((String)objectLockToken.getSubjectUri());
                String subjectUri = objectLockToken.getSubjectUri();
                if (snode.equals((Object)SubjectNode.UNAUTHENTICATED)) {
                    String userspath = this.nsaToken.getNamespaceConfig().getUsersPath();
                    subjectUri = userspath + "/" + snode.toString();
                }
                Element puhref = new Element("href", DNSP);
                principalUrl.addContent((org.jdom.Content)puhref);
                puhref.setText(WebdavUtils.getAbsolutePath(subjectUri, slideContextPath, this.sConf));
            }
        }
        return activelock;
    }

    public XMLValue computeSupportedlock(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        Element lockentry = new Element("lockentry", DNSP);
        Element lockscope = new Element("lockscope", DNSP);
        lockentry.addContent((org.jdom.Content)lockscope);
        Element exclusive = new Element("exclusive", DNSP);
        lockscope.addContent((org.jdom.Content)exclusive);
        Element locktype = new Element("locktype", DNSP);
        lockentry.addContent((org.jdom.Content)locktype);
        Element write = new Element("write", DNSP);
        locktype.addContent((org.jdom.Content)write);
        xmlValue.add(lockentry);
        lockentry = new Element("lockentry", DNSP);
        lockscope = new Element("lockscope", DNSP);
        lockentry.addContent((org.jdom.Content)lockscope);
        Element shared = new Element("shared", DNSP);
        lockscope.addContent((org.jdom.Content)shared);
        locktype = new Element("locktype", DNSP);
        lockentry.addContent((org.jdom.Content)locktype);
        write = new Element("write", DNSP);
        locktype.addContent((org.jdom.Content)write);
        xmlValue.add(lockentry);
        return xmlValue;
    }

    public XMLValue computeSupportedPrivilegeSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        Map actionAggregation = ((SecurityImpl)this.nsaToken.getSecurityHelper()).getActionAggregation(this.sToken);
        HashSet rootSet = new HashSet(actionAggregation.keySet());
        Iterator actions = actionAggregation.keySet().iterator();
        while (actions.hasNext()) {
            ActionNode a = (ActionNode)actions.next();
            Iterator aggregates = ((Set)actionAggregation.get(a)).iterator();
            while (aggregates.hasNext()) {
                ActionNode c = (ActionNode)aggregates.next();
                rootSet.remove(c);
            }
        }
        Element rootSp = new Element("supported-privilege", DNSP);
        Element p = new Element("privilege", DNSP);
        p.addContent((org.jdom.Content)new Element("all", DNSP));
        rootSp.addContent((org.jdom.Content)p);
        Iterator roots = rootSet.iterator();
        this.addElementsForAggregatedActions(rootSp, roots, actionAggregation);
        return new XMLValue(rootSp);
    }

    private void addElementsForAggregatedActions(Element parentActionElement, Iterator aggregatedActions, Map actionAggregation) {
        while (aggregatedActions.hasNext()) {
            ActionNode a = (ActionNode)aggregatedActions.next();
            Element sp = new Element("supported-privilege", DNSP);
            Element p = new Element("privilege", DNSP);
            Namespace actionNamespace = a.getNamespace();
            if (actionNamespace == null) {
                actionNamespace = DNSP;
            }
            p.addContent((org.jdom.Content)new Element(a.getPath().lastSegment(), actionNamespace));
            this.addElementsForAggregatedActions(p, ((Set)actionAggregation.get(a)).iterator(), actionAggregation);
            sp.addContent((org.jdom.Content)p);
            parentActionElement.addContent((org.jdom.Content)sp);
        }
    }

    private Element createPrivilege(ActionNode privilege, Uri privilegeUri) throws RevisionDescriptorNotFoundException, ServiceAccessException {
        return this.createPrivilege(privilege, true, privilegeUri);
    }

    private Element createPrivilege(ActionNode privilege, boolean useDavNamespace, Uri privilegeUri) throws RevisionDescriptorNotFoundException, ServiceAccessException {
        NodeRevisionNumber latestRevisionNumber = privilegeUri.getStore().retrieveRevisionDescriptors(privilegeUri).getLatestRevision();
        NodeProperty privilegeNamespaceProperty = privilegeUri.getStore().retrieveRevisionDescriptor(privilegeUri, latestRevisionNumber).getProperty(PRIVILEGE_NAMESPACE, "DAV:");
        Namespace privilegeNamespace = null;
        if (privilegeNamespaceProperty != null && privilegeNamespaceProperty.getValue() instanceof String) {
            privilegeNamespace = Namespace.getNamespace((String)((String)privilegeNamespaceProperty.getValue()));
        } else {
            privilegeNamespace = DNSP;
            if (!useDavNamespace) {
                privilegeNamespace = NodeProperty.NamespaceCache.SLIDE_NAMESPACE;
            }
        }
        Element privilegeElement = new Element("privilege", DNSP);
        Element privilegeNameElement = new Element(privilege.getPath().lastSegment(), privilegeNamespace);
        privilegeElement.addContent((org.jdom.Content)privilegeNameElement);
        return privilegeElement;
    }

    public XMLValue computeCurrentuserPrivilegeSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        try {
            NamespaceConfig config = this.nsaToken.getNamespaceConfig();
            Structure structure = this.nsaToken.getStructureHelper();
            ObjectNode object = structure.retrieve(this.sToken, revisionDescriptors.getUri());
            Security security = this.nsaToken.getSecurityHelper();
            security.checkCredentials(this.sToken, object, config.getReadOwnPermissionsAction());
            String actionsPath = config.getActionsPath();
            Uri actionsPathUri = this.nsaToken.getUri(this.sToken, actionsPath);
            ObjectNode actionsPathNode = actionsPathUri.getStore().retrieveObject(actionsPathUri);
            Enumeration actions = actionsPathNode.enumerateChildren();
            this.addGrantedActionsToPrivilegeSet(xmlValue, object, actions);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (SlideException e) {
            return xmlValue;
        }
        return xmlValue;
    }

    private void addGrantedActionsToPrivilegeSet(XMLValue xmlValue, ObjectNode object, Enumeration actions) throws ServiceAccessException, ObjectNotFoundException, RevisionDescriptorNotFoundException {
        while (actions.hasMoreElements()) {
            Uri aNodeUri = this.nsaToken.getUri(this.sToken, (String)actions.nextElement());
            ObjectNode oNode = aNodeUri.getStore().retrieveObject(aNodeUri);
            if (oNode.hasChildren()) {
                this.addGrantedActionsToPrivilegeSet(xmlValue, object, oNode.enumerateChildren());
                continue;
            }
            ActionNode aNode = ActionNode.getActionNode((String)oNode.getUri());
            if (!this.nsaToken.getSecurityHelper().hasPermission(this.sToken, object, aNode)) continue;
            xmlValue.add(this.createPrivilege(aNode, aNodeUri));
        }
    }

    public XMLValue computeAcl(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException, VetoException {
        XMLValue xmlValue = new XMLValue();
        NamespaceConfig config = this.nsaToken.getNamespaceConfig();
        Structure structure = this.nsaToken.getStructureHelper();
        ObjectNode objectNode = structure.retrieve(this.sToken, revisionDescriptors.getUri());
        Security security = this.nsaToken.getSecurityHelper();
        security.checkCredentials(this.sToken, objectNode, config.getReadPermissionsAction());
        String currentSubjectUri = "";
        boolean currentNegative = false;
        String currentInheritedFrom = "";
        Element currentAceElm = null;
        Element currentGrantDenyElm = null;
        Enumeration permissions = security.enumeratePermissions(this.sToken, objectNode, true);
        while (permissions.hasMoreElements()) {
            NodePermission perm = (NodePermission)permissions.nextElement();
            if (!perm.getSubjectUri().equals(currentSubjectUri) || perm.isNegative() && !currentNegative || !perm.isNegative() && currentNegative || !currentInheritedFrom.equals(perm.getInheritedFrom())) {
                if (currentAceElm != null) {
                    xmlValue.add(currentAceElm);
                }
                currentAceElm = new Element("ace", DNSP);
                if (perm.isInvert()) {
                    Element invertElm = new Element("invert", DNSP);
                    invertElm.addContent((org.jdom.Content)this.createPrincipalElement(perm.getSubjectUri()));
                    currentAceElm.addContent((org.jdom.Content)invertElm);
                } else {
                    currentAceElm.addContent((org.jdom.Content)this.createPrincipalElement(perm.getSubjectUri()));
                }
                currentGrantDenyElm = perm.isNegative() ? new Element("deny", DNSP) : new Element("grant", DNSP);
                currentAceElm.addContent((org.jdom.Content)currentGrantDenyElm);
                String inheritedFrom = perm.getInheritedFrom();
                if (inheritedFrom != null && inheritedFrom.length() > 0) {
                    currentAceElm.addContent((org.jdom.Content)this.createInheritedElement(inheritedFrom));
                }
                if (perm.isProtected()) {
                    currentAceElm.addContent((org.jdom.Content)new Element("protected", DNSP));
                }
                currentSubjectUri = perm.getSubjectUri();
                currentNegative = perm.isNegative();
                currentInheritedFrom = inheritedFrom != null ? inheritedFrom : "";
            }
            currentGrantDenyElm.addContent((org.jdom.Content)this.createPrivilegeElement(perm.getActionUri()));
        }
        if (currentAceElm != null) {
            xmlValue.add(currentAceElm);
        }
        return xmlValue;
    }

    private Element createInheritedElement(String inheritedFrom) {
        Element inheritedElm = new Element("inherited", DNSP);
        Element hrefElm = new Element("href", DNSP);
        hrefElm.addContent((org.jdom.Content)new Text(inheritedFrom));
        inheritedElm.addContent((org.jdom.Content)hrefElm);
        return inheritedElm;
    }

    private Element createPrincipalElement(String subjectUri) {
        Element principalElm = new Element("principal", DNSP);
        if (subjectUri.equals("all")) {
            Element allElm = new Element("all", DNSP);
            principalElm.addContent((org.jdom.Content)allElm);
        } else if (subjectUri.equals("authenticated")) {
            Element authenticatedElm = new Element("authenticated", DNSP);
            principalElm.addContent((org.jdom.Content)authenticatedElm);
        } else if (subjectUri.equals("unauthenticated")) {
            Element unauthenticatedElm = new Element("unauthenticated", DNSP);
            principalElm.addContent((org.jdom.Content)unauthenticatedElm);
        } else if (subjectUri.equals("owner")) {
            Element propertyElm = new Element("property", DNSP);
            propertyElm.addContent((org.jdom.Content)new Element("owner", DNSP));
            principalElm.addContent((org.jdom.Content)propertyElm);
        } else if (subjectUri.equals("self")) {
            Element selfElm = new Element("self", DNSP);
            principalElm.addContent((org.jdom.Content)selfElm);
        } else {
            Element hrefElm = new Element("href", DNSP);
            hrefElm.addContent((org.jdom.Content)new Text(subjectUri));
            principalElm.addContent((org.jdom.Content)hrefElm);
        }
        return principalElm;
    }

    private Element createPrivilegeElement(String actionUriAsString) throws RevisionDescriptorNotFoundException, ServiceAccessException {
        Element privilegeElm = new Element("privilege", DNSP);
        if (actionUriAsString.equals("all")) {
            Element allElm = new Element("all", DNSP);
            privilegeElm.addContent((org.jdom.Content)allElm);
        } else {
            Uri actionUri = this.nsaToken.getUri(this.sToken, actionUriAsString);
            NodeRevisionNumber latestRevisionNumber = actionUri.getStore().retrieveRevisionDescriptors(actionUri).getLatestRevision();
            NodeProperty privilegeNamespace = actionUri.getStore().retrieveRevisionDescriptor(actionUri, latestRevisionNumber).getProperty(PRIVILEGE_NAMESPACE, "DAV:");
            Namespace actionNamespace = null;
            actionNamespace = privilegeNamespace != null && privilegeNamespace.getValue() instanceof String ? Namespace.getNamespace((String)((String)privilegeNamespace.getValue())) : DNSP;
            Element actionElm = new Element(new UriPath(actionUriAsString).lastSegment(), actionNamespace);
            privilegeElm.addContent((org.jdom.Content)actionElm);
        }
        return privilegeElm;
    }

    public XMLValue computePrincipalCollectionSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        NamespaceConfig namespaceConfig = this.nsaToken.getNamespaceConfig();
        xmlValue.addHref(WebdavUtils.getAbsolutePath(namespaceConfig.getUsersPath(), slideContextPath, this.sConf));
        if (namespaceConfig.getGroupsPath() != null) {
            xmlValue.addHref(WebdavUtils.getAbsolutePath(namespaceConfig.getGroupsPath(), slideContextPath, this.sConf));
        }
        if (namespaceConfig.getRolesPath() != null) {
            xmlValue.addHref(WebdavUtils.getAbsolutePath(namespaceConfig.getRolesPath(), slideContextPath, this.sConf));
        }
        return xmlValue;
    }

    public XMLValue computePrivilegeCollectionSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        XMLValue xmlValue = new XMLValue();
        NamespaceConfig namespaceConfig = this.nsaToken.getNamespaceConfig();
        String absUri = WebdavUtils.getAbsolutePath(namespaceConfig.getActionsPath(), slideContextPath, this.sConf);
        xmlValue.addHref(absUri);
        return xmlValue;
    }

    public XMLValue computeOwner(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        NodeProperty ownerProperty = revisionDescriptor.getProperty("owner", "DAV:");
        XMLValue xmlValue = this.createUserPath(ownerProperty, slideContextPath);
        return xmlValue;
    }

    public XMLValue computeCreationUser(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        NodeProperty creationUserProperty = revisionDescriptor.getProperty("creationuser", "DAV:");
        XMLValue xmlValue = this.createUserPath(creationUserProperty, slideContextPath);
        return xmlValue;
    }

    public XMLValue computeModificationUser(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        NodeProperty modificationUserProperty = revisionDescriptor.getProperty("modificationuser", "DAV:");
        XMLValue xmlValue = this.createUserPath(modificationUserProperty, slideContextPath);
        return xmlValue;
    }

    public XMLValue computeInheritedAclSet(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        if (revisionDescriptor.getProperty("inherited-acl-set") != null) {
            Object v = revisionDescriptor.getProperty("inherited-acl-set").getValue();
            return v instanceof XMLValue ? (XMLValue)v : new XMLValue((String)v);
        }
        return new XMLValue();
    }

    public XMLValue computeAclRestrictions(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        if (revisionDescriptor.getProperty("acl-restrictions") != null) {
            Object v = revisionDescriptor.getProperty("acl-restrictions").getValue();
            return v instanceof XMLValue ? (XMLValue)v : new XMLValue((String)v);
        }
        return new XMLValue();
    }

    public XMLValue computeGroupMembership(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String slideContextPath) throws ObjectLockedException, RevisionDescriptorNotFoundException, ServiceAccessException, LinkedObjectNotFoundException, AccessDeniedException, ObjectNotFoundException, LockTokenNotFoundException, JDOMException {
        if (revisionDescriptor.getProperty("group-membership") != null) {
            Object v = revisionDescriptor.getProperty("group-membership").getValue();
            return v instanceof XMLValue ? (XMLValue)v : new XMLValue((String)v);
        }
        XMLValue xmlValue = new XMLValue();
        Uri principalUri = this.nsaToken.getUri(this.sToken, revisionDescriptors.getUri());
        SubjectNode principalNode = (SubjectNode)principalUri.getStore().retrieveObject(principalUri);
        Enumeration roles = ((ACLSecurityImpl)this.nsaToken.getSecurityHelper()).getGroupMembership(this.sToken, principalNode);
        while (roles.hasMoreElements()) {
            String rolePath = (String)roles.nextElement();
            String roleHref = slideContextPath + rolePath;
            xmlValue.addHref(roleHref);
        }
        return xmlValue;
    }

    private XMLValue createUserPath(NodeProperty userProperty, String slideContextPath) throws IllegalArgumentException {
        XMLValue xmlValue = new XMLValue();
        String userHref = "";
        NamespaceConfig config = this.nsaToken.getNamespaceConfig();
        if (userProperty != null && userProperty.getValue() != null && !"".equals(userProperty.getValue().toString())) {
            userHref = slideContextPath + config.getUsersPath() + "/" + userProperty.getValue().toString();
            xmlValue.addHref(userHref);
        } else {
            xmlValue.add(new Element("unauthenticated", DNSP));
        }
        return xmlValue;
    }

    public static String getAbsoluteURL(String serverURL, String contextPath, String uri) {
        StringBuffer buffer = new StringBuffer();
        String lastAppended = null;
        if (contextPath != null) {
            if (lastAppended != null && !lastAppended.endsWith("/") && !contextPath.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(contextPath);
            lastAppended = buffer.toString();
        }
        if (uri != null) {
            if (lastAppended != null && !lastAppended.endsWith("/") && !uri.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(uri);
        }
        return WebdavUtils.encodeURL(buffer.toString());
    }

    public static boolean isAbsoluteURL(String servletContextPath, String uri) {
        if (uri.startsWith("urn:uuid:")) {
            return true;
        }
        if (uri.startsWith("opaquelocktoken:")) {
            return true;
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri.startsWith(servletContextPath);
    }

    public static boolean addHrefToProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String uri) throws JDOMException {
        return PropertyHelper.addElementToProperty(revisionDescriptor, propertyName, "href", uri);
    }

    public static boolean addElementToProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String elementName, String elementValue) throws JDOMException {
        NodeProperty property = revisionDescriptor.getProperty(propertyName);
        if (property == null) {
            property = new NodeProperty(propertyName, null);
        }
        XMLValue xmlValue = new XMLValue((String)property.getValue());
        Iterator iterator = xmlValue.iterator();
        boolean alreadyContained = false;
        Element element = null;
        while (iterator.hasNext() && !alreadyContained) {
            element = (Element)iterator.next();
            if (!element.getName().equals(elementName) || !element.getText().equals(elementValue)) continue;
            alreadyContained = true;
        }
        if (!alreadyContained) {
            element = new Element(elementName);
            element.setText(elementValue);
            xmlValue.add(element);
        }
        revisionDescriptor.setProperty(propertyName, (Object)xmlValue.toString());
        return !alreadyContained;
    }

    public static boolean removeHrefFromProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String uri) throws JDOMException {
        return PropertyHelper.removeElementFromProperty(revisionDescriptor, propertyName, "href", uri);
    }

    public static boolean removeElementFromProperty(NodeRevisionDescriptor revisionDescriptor, String propertyName, String elementName, String elementValue) throws JDOMException {
        NodeProperty property = revisionDescriptor.getProperty(propertyName);
        boolean found = false;
        if (property != null) {
            XMLValue xmlValue = new XMLValue((String)property.getValue());
            Iterator iterator = xmlValue.iterator();
            Element element = null;
            while (iterator.hasNext() && !found) {
                element = (Element)iterator.next();
                if (!element.getName().equals(elementName) || !element.getText().equals(elementValue)) continue;
                found = true;
                iterator.remove();
            }
            if (found) {
                revisionDescriptor.setProperty(propertyName, (Object)xmlValue.toString());
            }
        }
        return found;
    }

    public static String truncateLeadingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        while (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    public static String computeEtag(String uri, NodeRevisionDescriptor nrd) {
        StringBuffer sb = new StringBuffer();
        sb.append(System.currentTimeMillis()).append('_').append(uri.hashCode()).append('_').append(nrd.getLastModified()).append('_').append(nrd.getContentLength());
        return new String(DigestUtils.md5Hex((String)sb.toString()));
    }
}

