/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.util.UriHandler;

public class HistoryPathHandler
extends UriHandler {
    static final String HISTORY_PATH = Domain.getParameter((String)"historypath", (String)"/history");
    static HistoryPathHandler historyPathHandler = new HistoryPathHandler(HISTORY_PATH);
    static boolean parameterized = HISTORY_PATH.indexOf("${store}") >= 0;
    private Set resolvedHistoryPaths = null;

    public static HistoryPathHandler getHistoryPathHandler() {
        return historyPathHandler;
    }

    public static UriHandler getResolvedHistoryPathHandler(String namespaceName, UriHandler uh) {
        if (parameterized) {
            return HistoryPathHandler.getResolvedHistoryPathHandler(uh.getAssociatedBaseStoreName(namespaceName));
        }
        return historyPathHandler;
    }

    public static UriHandler getResolvedHistoryPathHandler(String storeName) {
        if (parameterized) {
            String rp = historyPathHandler.toString();
            int k = rp.indexOf("${store}");
            if (k >= 0) {
                StringBuffer b = new StringBuffer(rp);
                while (k >= 0) {
                    b.replace(k, k + "${store}".length(), storeName);
                    k = b.toString().indexOf("${store}");
                }
                rp = b.toString();
            }
            return new UriHandler(rp);
        }
        return historyPathHandler;
    }

    public static String getHistoryPath() {
        return HISTORY_PATH;
    }

    protected HistoryPathHandler(String uri) {
        super(uri);
    }

    public boolean isHistoryPathUri(UriHandler uh) {
        if (!parameterized) {
            return this.equals(uh);
        }
        if (!Domain.namespacesAreInitialized()) {
            return false;
        }
        if (this.resolvedHistoryPaths == null) {
            this.resolve();
        }
        return this.resolvedHistoryPaths.contains(uh);
    }

    public List getResolvedHistoryPaths() {
        return this.getResolvedHistoryPaths(null);
    }

    public List getResolvedHistoryPaths(String storeName) {
        ArrayList<Object> result;
        if (parameterized) {
            if (storeName != null) {
                result = new ArrayList();
                result.add(HistoryPathHandler.getResolvedHistoryPathHandler(storeName));
            } else {
                this.resolve();
                result = new ArrayList(this.resolvedHistoryPaths);
            }
        } else {
            result = new ArrayList<Object>();
            result.add(HISTORY_PATH);
        }
        return result;
    }

    private void resolve() {
        this.resolvedHistoryPaths = new HashSet();
        Iterator i = allStoreNames.iterator();
        while (i.hasNext()) {
            String storeName = (String)i.next();
            UriHandler rpuh = HistoryPathHandler.getResolvedHistoryPathHandler(storeName);
            if (!allScopes.contains(rpuh)) continue;
            this.resolvedHistoryPaths.add(rpuh);
        }
    }
}

