/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.JDOMException;

public class ComputedPropertyProvider
implements PropertyProvider {
    protected String slideContextPath = null;
    protected Content contentHelper = null;
    protected NamespaceAccessToken nsaToken = null;
    protected SlideToken slideToken = null;
    protected PropertyHelper propertyHelper = null;
    protected NodeRevisionDescriptors revisionDescriptors = null;
    protected NodeRevisionDescriptor revisionDescriptor = null;
    protected String lastResourceUri = null;

    public ComputedPropertyProvider(NamespaceAccessToken nsaToken, SlideToken slideToken, String slideContextPath, WebdavServletConfig sConf) {
        this(nsaToken, slideToken, PropertyHelper.getPropertyHelper(slideToken, nsaToken, sConf), slideContextPath);
    }

    public ComputedPropertyProvider(NamespaceAccessToken nsaToken, SlideToken slideToken, String contextPath, String servletPath, WebdavServletConfig sConf) {
        this(nsaToken, slideToken, PropertyHelper.getPropertyHelper(slideToken, nsaToken, sConf), contextPath, servletPath);
    }

    public ComputedPropertyProvider(NamespaceAccessToken nsaToken, SlideToken slideToken, String contextPath, String servletPath) {
        this(nsaToken, slideToken, PropertyHelper.getPropertyHelper(slideToken, nsaToken, null), contextPath, servletPath);
    }

    public ComputedPropertyProvider(NamespaceAccessToken nsaToken, SlideToken slideToken, PropertyHelper propertyHelper, String slideContextPath) {
        this.nsaToken = nsaToken;
        this.slideToken = slideToken;
        this.propertyHelper = propertyHelper;
        this.slideContextPath = slideContextPath;
        this.contentHelper = nsaToken.getContentHelper();
    }

    public ComputedPropertyProvider(NamespaceAccessToken nsaToken, SlideToken slideToken, PropertyHelper propertyHelper, String contextPath, String servletPath) {
        this.nsaToken = nsaToken;
        this.slideToken = slideToken;
        this.propertyHelper = propertyHelper;
        this.slideContextPath = contextPath + servletPath;
        this.contentHelper = nsaToken.getContentHelper();
    }

    public boolean isSupportedProperty(String resourceUri, String propertyName, String propertyNamespace) throws SlideException {
        this.updateDescriptors(resourceUri);
        return this.getComputedPropertiesNames().contains(propertyName);
    }

    protected Set getComputedPropertiesNames() {
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, this.revisionDescriptors, this.revisionDescriptor);
        Set computedLivePropertyNames = resourceKind.getSupportedLiveProperties("computed-only");
        return computedLivePropertyNames;
    }

    public Iterator getSupportedPropertiesNames(String resourceUri) throws SlideException {
        this.updateDescriptors(resourceUri);
        Set computedLivePropertyNames = this.getComputedPropertiesNames();
        ArrayList<PropertyName> propertiesNamesList = new ArrayList<PropertyName>(computedLivePropertyNames.size());
        Iterator iterator = computedLivePropertyNames.iterator();
        while (iterator.hasNext()) {
            propertiesNamesList.add(new PropertyName((String)iterator.next(), "DAV:"));
        }
        return propertiesNamesList.iterator();
    }

    public NodeProperty getProperty(String resourceUri, String propertyName, String propertyNamespace) throws SlideException {
        this.updateDescriptors(resourceUri);
        try {
            return this.propertyHelper.getProperty(propertyName, this.revisionDescriptors, this.revisionDescriptor, this.slideContextPath);
        }
        catch (JDOMException e) {
            throw new SlideException("ComputedPropertyProvider.getProperty(): " + e.getMessage());
        }
    }

    public Iterator getSupportedProperties(String resourceUri) throws SlideException {
        this.updateDescriptors(resourceUri);
        Set propertyNames = this.getComputedPropertiesNames();
        ArrayList<NodeProperty> supportedProperties = new ArrayList<NodeProperty>(propertyNames.size());
        Iterator iterator = propertyNames.iterator();
        while (iterator.hasNext()) {
            supportedProperties.add(this.getProperty(resourceUri, (String)iterator.next(), "DAV:"));
        }
        return supportedProperties.iterator();
    }

    protected void updateDescriptors(String resourceUri) throws SlideException {
        if (this.lastResourceUri == null || !this.lastResourceUri.equals(resourceUri)) {
            this.revisionDescriptors = this.contentHelper.retrieve(this.slideToken, resourceUri);
            this.revisionDescriptor = this.contentHelper.retrieve(this.slideToken, this.revisionDescriptors);
            this.lastResourceUri = resourceUri;
        }
    }
}

