/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.UriPath;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.resourcekind.PrincipalImpl;
import org.jdom.Content;
import org.jdom.Element;

public class PrincipalSearchPropertySetReport
extends AbstractReport
implements AclConstants {
    public PrincipalSearchPropertySetReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element principalSearchPropertySetElm) throws PreconditionViolationException {
        if (principalSearchPropertySetElm.getChildren().size() > 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("empty-principal-search-property-set-element", 400, "DAV:principal-search-property-set element must be empty"), resourcePath);
        }
    }

    public void execute(String resourcePath, Element principalSearchPropertySetElm, int depth) throws SlideException, IOException {
        Iterator props = this.retriever.getAllPropertyNames(PrincipalImpl.getInstance()).getRequestedProperties();
        while (props.hasNext()) {
            RequestedProperty p = (RequestedProperty)props.next();
            Element principalSearchPropertyElm = new Element("principal-search-property", DNSP);
            principalSearchPropertyElm.addContent((Content)new Element(p.getName(), DNSP));
            principalSearchPropertySetElm.addContent((Content)principalSearchPropertyElm);
        }
    }

    public void checkPreconditions(String resourcePath, int depth) throws PreconditionViolationException, ServiceAccessException {
        UriPath rolespath;
        if (depth != 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("depth-must-be-zero", 400, "This report is only defined for depth=0."), resourcePath);
        }
        UriPath resourcepath = new UriPath(resourcePath);
        NamespaceConfig namespaceConfig = this.token.getNamespaceConfig();
        UriPath userspath = namespaceConfig.getUsersPath() != null ? new UriPath(namespaceConfig.getUsersPath()) : null;
        UriPath groupspath = namespaceConfig.getGroupsPath() != null ? new UriPath(namespaceConfig.getGroupsPath()) : null;
        UriPath uriPath = rolespath = namespaceConfig.getRolesPath() != null ? new UriPath(namespaceConfig.getRolesPath()) : null;
        if (!(resourcepath.equals((Object)userspath) || resourcepath.equals((Object)groupspath) || resourcepath.equals((Object)rolespath))) {
            throw new PreconditionViolationException(new ViolatedPrecondition("valid-request-uri", 400, "This report is only defined for one of the collections identified in the value of the DAV:principal-collection-set property."), resourcePath);
        }
    }
}

