/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PrincipalPropertySearchReport
extends AbstractReport
implements AclConstants {
    private RequestedProperties requestedProperties = null;
    private List conditionList = null;

    public PrincipalPropertySearchReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element principalPropertySearchElm) throws PreconditionViolationException {
        if (principalPropertySearchElm.getChildren().size() == 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-least-one-child-element", 400, "DAV:principal-property-search element must have at least one child"), resourcePath);
        }
        List propertySearchElmL = principalPropertySearchElm.getChildren("property-search", DNSP);
        if (propertySearchElmL.size() == 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-least-one-property-search-element", 400, "DAV:principal-property-search element must contain at least one DAV:property-search element"), resourcePath);
        }
        Iterator ps = propertySearchElmL.iterator();
        this.conditionList = new ArrayList();
        while (ps.hasNext()) {
            Element propertySearchElm = (Element)ps.next();
            Element matchElm = propertySearchElm.getChild("match", DNSP);
            if (matchElm == null) continue;
            Element propElm = propertySearchElm.getChild("prop", DNSP);
            Iterator pElms = propElm.getChildren().iterator();
            while (pElms.hasNext()) {
                Element pElm = (Element)pElms.next();
                Element newpropElm = new Element("prop", DNSP);
                newpropElm.addContent((Content)new Element(pElm.getName(), pElm.getNamespace()));
                Element propcontainsElm = new Element("propcontains", Namespace.getNamespace((String)"http://jakarta.apache.org/slide/"));
                Element literalElm = new Element("literal", DNSP);
                literalElm.addContent(matchElm.getTextTrim());
                propcontainsElm.addContent((Content)newpropElm);
                propcontainsElm.addContent((Content)literalElm);
                this.conditionList.add(propcontainsElm);
            }
        }
        List propElmL = principalPropertySearchElm.getChildren("prop", DNSP);
        if (propElmL.size() > 1) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-most-one-prop-element", 400, "DAV:principal-property-search element must have at most one DAV:prop child"), resourcePath);
        }
        if (propElmL.size() == 1) {
            Element propElm = (Element)propElmL.get(0);
            try {
                this.requestedProperties = new RequestedPropertiesImpl(propElm);
            }
            catch (PropertyParseException e) {
                throw new PreconditionViolationException(new ViolatedPrecondition("invalid-prop", 400, e.getMessage()), resourcePath);
            }
        }
    }

    public void execute(String resourcePath, Element multistatusElm, int depth) throws SlideException, IOException {
        SubjectNode currentUserNode = (SubjectNode)this.security.getPrincipal(this.slideToken);
        Element queryElm = this.getQueryElement(resourcePath, currentUserNode);
        new XMLOutputter(Format.getPrettyFormat()).output(queryElm, (OutputStream)System.out);
        String absUri = WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config);
        SearchQuery query = this.search.createSearchQuery(queryElm.getNamespaceURI(), queryElm, this.slideToken, this.config.getDepthLimit(), absUri);
        Iterator result = query.execute().iterator();
        while (result.hasNext()) {
            RequestedResource r = (RequestedResource)result.next();
            multistatusElm.addContent((Content)this.getResponseElement(this.slideToken, r.getUri(), new NodeRevisionNumber(), this.requestedProperties));
        }
    }

    private Element getQueryElement(String resourcePath, SubjectNode currentUserNode) {
        Element result = new Element("basicsearch", DNSP);
        Element selectElm = new Element("select", DNSP);
        result.addContent((Content)selectElm);
        Element propElm = new Element("prop", DNSP);
        selectElm.addContent((Content)propElm);
        Iterator props = this.requestedProperties.getRequestedProperties();
        while (props.hasNext()) {
            RequestedProperty p = (RequestedProperty)props.next();
            Namespace nsp = DNSP.getURI().equals(p.getNamespace()) ? DNSP : Namespace.getNamespace((String)p.getNamespace());
            propElm.addContent((Content)new Element(p.getName(), nsp));
        }
        Element fromElm = new Element("from", DNSP);
        result.addContent((Content)fromElm);
        Element scopeElm = new Element("scope", DNSP);
        fromElm.addContent((Content)scopeElm);
        Element hrefElm = new Element("href", DNSP);
        hrefElm.setText(WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config));
        scopeElm.addContent((Content)hrefElm);
        if (this.conditionList.size() > 0) {
            Element whereElm = new Element("where", DNSP);
            result.addContent((Content)whereElm);
            if (this.conditionList.size() == 1) {
                whereElm.addContent((Content)((Element)this.conditionList.get(0)));
            } else {
                Element andElm = new Element("and", DNSP);
                whereElm.addContent((Content)andElm);
                Iterator conditions = this.conditionList.iterator();
                while (conditions.hasNext()) {
                    andElm.addContent((Content)((Element)conditions.next()));
                }
            }
        }
        return result;
    }

    public void checkPreconditions(String resourcePath, int depth) throws PreconditionViolationException, ServiceAccessException {
        if (depth != 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("depth-must-be-zero", 400, "This report is only defined for depth=0."), resourcePath);
        }
    }
}

