/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class ExpandPropertyReport
extends AbstractReport
implements DeltavConstants {
    private static final String PROPERTY_LIST = "propertylist";
    private List propertyElmList;

    public ExpandPropertyReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element expandPropertyElm) throws PreconditionViolationException {
        this.propertyElmList = expandPropertyElm.getChildren("property", DNSP);
    }

    public void execute(String resourcePath, Element multistatusElm, int depth) throws SlideException, IOException {
        if (depth < 0) {
            return;
        }
        this.writeReport(resourcePath, multistatusElm, this.propertyElmList);
        ObjectNode onode = this.structure.retrieve(this.slideToken, resourcePath);
        Enumeration childrenEnum = this.structure.getChildren(this.slideToken, onode);
        while (childrenEnum.hasMoreElements()) {
            ObjectNode cnode = (ObjectNode)childrenEnum.nextElement();
            this.execute(cnode.getUri(), multistatusElm, depth - 1);
        }
    }

    private void writeReport(String resourcePath, Element multistatusElm, List propertyElmList) {
        try {
            NodeRevisionDescriptors nrds = this.content.retrieve(this.slideToken, resourcePath);
            NodeRevisionDescriptor nrd = this.content.retrieve(this.slideToken, nrds);
            Element response = this.getResponseElement(this.slideToken, resourcePath, nrd.getRevisionNumber(), this.createRequestedProperties(propertyElmList));
            multistatusElm.addContent((Content)response);
            Iterator iterator = propertyElmList.iterator();
            while (iterator.hasNext()) {
                Element propertyElement = (Element)iterator.next();
                List childPropertyList = propertyElement.getChildren();
                if (childPropertyList.size() <= 0) continue;
                try {
                    Namespace propertyNamespace = DNSP;
                    String propertyNamespaceStr = propertyElement.getAttributeValue("namespace");
                    if (propertyNamespaceStr != null) {
                        propertyNamespace = Namespace.getNamespace((String)propertyNamespaceStr);
                    }
                    List hrefElements = response.getChild("propstat", DNSP).getChild("prop", DNSP).getChild(propertyElement.getAttribute("name").getValue(), propertyNamespace).getChildren("href", DNSP);
                    Iterator hrefs = new ArrayList(hrefElements).iterator();
                    while (hrefs.hasNext()) {
                        Element hrefElement = (Element)hrefs.next();
                        if (hrefElement.getText() == null) continue;
                        this.writeReport(WebdavUtils.getSlidePath(hrefElement.getTextTrim(), this.slideContextPath), (Element)hrefElement.getParent(), childPropertyList);
                        hrefElement.getParent().removeContent((Content)hrefElement);
                    }
                }
                catch (NullPointerException e) {
                }
            }
        }
        catch (Exception e) {
            multistatusElm.addContent((Content)this.getErrorResponse(resourcePath, WebdavUtils.getErrorCode(e), null));
        }
    }

    private RequestedProperties createRequestedProperties(List propertyElements) throws PropertyParseException {
        Element propertyListElement = new Element(PROPERTY_LIST);
        Iterator iterator = propertyElements.iterator();
        while (iterator.hasNext()) {
            propertyListElement.addContent((Content)((Element)((Element)iterator.next()).clone()));
        }
        return new RequestedPropertiesImpl(propertyListElement);
    }
}

