/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.method.MethodUtil;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyRetriever;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavStatus;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class UpdateMethod
extends AbstractMultistatusResponseMethod
implements DeltavConstants,
WriteMethod {
    private String resourcePath;
    private String updateSourcePath;
    private String updateLabelName;
    private RequestedProperties requestedProps;
    protected VersioningHelper versioningHelper = null;
    protected String serverUri = null;
    protected PropertyRetriever propertyRetriever = null;

    public UpdateMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
        this.serverUri = this.req.getServerName() + ":" + this.req.getServerPort();
        this.propertyRetriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        if (this.req.getContentLength() == 0) {
            int statusCode = 400;
            this.sendError(statusCode, this.getClass().getName() + ".missingRequestBody");
            throw new WebdavException(statusCode);
        }
        try {
            this.parseUpdateRequestContent();
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (PropertyParseException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private void parseUpdateRequestContent() throws IOException, JDOMException, PropertyParseException {
        Element ve = null;
        Iterator i = this.parseRequestContent("update").getChildren().iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (e.getName().equals("version")) {
                if (this.updateSourcePath != null) {
                    throw new JDOMException("At most one &lt;version&gt; element allowed");
                }
                if (this.updateLabelName != null) {
                    throw new JDOMException("Either a &lt;version&gt; OR a &lt;label-name&gt; element allowed");
                }
                ve = e;
                try {
                    Element hre = (Element)ve.getChildren().get(0);
                    if (hre == null || !hre.getName().equals("href")) {
                        throw new Exception();
                    }
                    this.updateSourcePath = this.getSlidePath(hre.getText());
                }
                catch (Exception x) {
                    throw new JDOMException("&lt;version&gt; element must contain &lt;href&gt; element");
                }
            }
            if (e.getName().equals("prop")) {
                if (this.requestedProps != null) {
                    throw new JDOMException("At most one prop element allowed");
                }
                this.requestedProps = new RequestedPropertiesImpl(e);
            }
            if (!e.getName().equals("label-name")) continue;
            if (this.updateSourcePath != null) {
                throw new JDOMException("Either a &lt;version&gt; OR a &lt;label-name&gt; element allowed");
            }
            if (this.updateLabelName != null) {
                throw new JDOMException("At most one &lt;label-name&gt; element allowed");
            }
            this.updateLabelName = e.getText();
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        Element multistatusElement;
        block12: {
            this.slideToken.setForceStoreEnlistment(true);
            try {
                if (this.isLockNull(this.resourcePath)) {
                    int statusCode = 404;
                    this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                    throw new WebdavException(statusCode);
                }
            }
            catch (ServiceAccessException e) {
                int statusCode = this.getErrorCode((Throwable)e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            multistatusElement = new Element("multistatus", DNSP);
            try {
                if (WebdavEvent.UPDATE.isEnabled()) {
                    EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.UPDATE, (EventObject)new WebdavEvent(this));
                }
                this.update(this.updateSourcePath, this.updateLabelName, this.resourcePath, this.getDepth(), multistatusElement);
            }
            catch (NestedSlideException nestedSlideException) {
                if (this.requestHeaders.isDefined("Depth")) break block12;
                SlideException exception = (SlideException)((Object)nestedSlideException.enumerateExceptions().nextElement());
                this.resp.setStatus(this.getErrorCode(exception));
                if (exception instanceof PreconditionViolationException) {
                    try {
                        this.sendPreconditionViolation((PreconditionViolationException)exception);
                    }
                    catch (IOException e) {
                        int statusCode = 500;
                        this.sendError(statusCode, e);
                        throw new WebdavException(statusCode);
                    }
                }
                throw new WebdavException(this.getErrorCode(exception), false);
            }
            catch (SlideException e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
        try {
            this.resp.setStatus(207);
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            Format format = Format.getPrettyFormat();
            format.setIndent("    ");
            new XMLOutputter(format).output(new Document(multistatusElement), (Writer)this.resp.getWriter());
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected void update(String updateSourcePath, String updateLabelName, String resourcePath, int depth, Element multistatusElement) throws NestedSlideException {
        NestedSlideException nestedSlideException = new NestedSlideException(null);
        this.update(updateSourcePath, updateLabelName, resourcePath, depth, multistatusElement, nestedSlideException);
        if (!nestedSlideException.isEmpty()) {
            throw nestedSlideException;
        }
    }

    protected void update(String updateSourcePath, String updateLabelName, String resourcePath, int depth, Element multistatusElement, NestedSlideException nestedSlideException) {
        Element responseElement = new Element("response", DNSP);
        multistatusElement.addContent((Content)responseElement);
        Element hrefElement = new Element("href", DNSP);
        String absUri = WebdavUtils.getAbsolutePath(resourcePath, this.req, this.getConfig());
        hrefElement.setText(absUri);
        responseElement.addContent((Content)hrefElement);
        Element statusElement = new Element("status", DNSP);
        responseElement.addContent((Content)statusElement);
        Enumeration childrenEnum = null;
        try {
            if (this.isCollection(resourcePath) && depth > 0) {
                ObjectNode currentNode = this.structure.retrieve(this.slideToken, resourcePath);
                childrenEnum = this.structure.getChildren(this.slideToken, currentNode);
            }
            this.checkPreconditions(updateSourcePath, updateLabelName, resourcePath);
            if (updateLabelName != null) {
                updateSourcePath = this.versioningHelper.getLabeledResourceUri(resourcePath, updateLabelName);
            }
            this.versioningHelper.update(resourcePath, updateSourcePath);
            statusElement.setText("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
            this.appendRequestedProps(resourcePath, responseElement);
        }
        catch (SlideException e) {
            this.handleException(e, statusElement, responseElement, nestedSlideException);
        }
        catch (JDOMException e) {
            this.handleException(e, statusElement, responseElement, nestedSlideException);
        }
        if (childrenEnum != null) {
            while (childrenEnum.hasMoreElements()) {
                this.update(updateSourcePath, updateLabelName, ((ObjectNode)childrenEnum.nextElement()).getUri(), depth - 1, multistatusElement, nestedSlideException);
            }
        }
    }

    private void appendRequestedProps(String resourcePath, Element responseElement) throws SlideException, JDOMException {
        if (this.requestedProps != null) {
            List propStatList = this.propertyRetriever.getPropertiesOfObject(this.requestedProps, resourcePath, this.getSlideContextPath(), true);
            Iterator iterator = propStatList.iterator();
            while (iterator.hasNext()) {
                responseElement.addContent((Content)((Element)iterator.next()));
            }
        }
    }

    private void checkPreconditions(String updateSourcePath, String updateLabelName, String resourcePath) throws SlideException, PreconditionViolationException {
        ViolatedPrecondition violatedPrecondition = this.getPreconditionViolation(updateSourcePath, updateLabelName, resourcePath);
        if (violatedPrecondition != null) {
            throw new PreconditionViolationException(violatedPrecondition, resourcePath);
        }
    }

    private void handleException(JDOMException exception, Element statusElement, Element responseElement, NestedSlideException nestedSlideException) {
        this.handleException(new SlideException("Nested exception: " + (Object)((Object)exception)), statusElement, responseElement, nestedSlideException);
    }

    private void handleException(SlideException exception, Element statusElement, Element responseElement, NestedSlideException nestedSlideException) {
        nestedSlideException.addException(exception);
        int errorCode = this.getErrorCode(exception);
        statusElement.setText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
        if (exception instanceof PreconditionViolationException) {
            Element responseDescriptionElement = new Element("responsedescription", DNSP);
            responseElement.addContent((Content)responseDescriptionElement);
            Element errorElement = MethodUtil.getPreconditionViolationError(((PreconditionViolationException)exception).getViolatedPrecondition());
            responseDescriptionElement.addContent((Content)errorElement);
        }
    }

    protected ViolatedPrecondition getPreconditionViolation(String updateSourcePath, String updateSourceLabel, String resourcePath) throws SlideException {
        NodeRevisionDescriptor revisionDescriptor;
        ViolatedPrecondition violatedPrecondition = null;
        NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, resourcePath);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors));
        if (!(resourceKind instanceof CheckedInVersionControlled)) {
            return new ViolatedPrecondition("must-be-checked-in-version-controlled-resource", 409);
        }
        if (updateSourceLabel != null) {
            try {
                updateSourcePath = this.versioningHelper.getLabeledResourceUri(resourcePath, this.updateLabelName);
            }
            catch (LabeledRevisionNotFoundException e) {
                return new ViolatedPrecondition("must-select-version-in-history", 409);
            }
        }
        String associatedVrUri = this.versioningHelper.getUriOfAssociatedVR(resourcePath);
        String vcrHistoryUri = UriHandler.getUriHandler(associatedVrUri).getAssociatedHistoryUri();
        UriHandler vrUriHandler = UriHandler.getUriHandler(updateSourcePath);
        boolean isVersionOfVcrHistory = false;
        if (vrUriHandler.isVersionUri() && vcrHistoryUri.equals(vrUriHandler.getAssociatedHistoryUri())) {
            NodeRevisionDescriptors vrDescriptors = this.content.retrieve(this.slideToken, updateSourcePath);
            try {
                this.content.retrieve(this.slideToken, vrDescriptors);
                isVersionOfVcrHistory = true;
            }
            catch (RevisionDescriptorNotFoundException e) {
                // empty catch block
            }
        }
        if (!isVersionOfVcrHistory) {
            return new ViolatedPrecondition("must-select-version-in-history", 409);
        }
        return violatedPrecondition;
    }

    protected int getDepth() throws WebdavException {
        return this.requestHeaders.getDepth(0);
    }
}

