/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.Enumeration;
import java.util.EventObject;
import javax.transaction.Transaction;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.transaction.ExternalTransactionContext;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class UnlockMethod
extends AbstractWebdavMethod
implements WebdavConstants,
WriteMethod {
    public static final String LOCK_TOKEN_HEADER_MISSING = "Lock-Token header missing";
    public static final String INVALID_LOCK_TOKEN = "Lock-Token is invalid";
    public static final String UNLOCK_NOT_ALLOWED = "Principal is neither the lock-owner nor has DAV:unlock privilege";
    public static final String IS_NOT_LOCK_ROOT = "Please try to unlock the root of the lock: ";
    public static final int NO_TRANSACTION = 0;
    public static final int ABORT_TRANSACTION = 1;
    public static final int COMMIT_TRANSACTION = 2;
    private String resourcePath;
    private String lockId;
    private int command = 0;

    public UnlockMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    public int getCommand() {
        return this.command;
    }

    protected void parseRequest() throws WebdavException {
        block8: {
            this.resourcePath = this.requestUri;
            if (this.resourcePath == null) {
                this.resourcePath = "/";
            }
            this.lockId = this.requestHeaders.getLockToken().trim();
            if (this.lockId == null) {
                this.sendError(412, LOCK_TOKEN_HEADER_MISSING);
                throw new WebdavException(412);
            }
            try {
                Element transactioninfo;
                Document requestContent = this.parseRequestContent();
                if (requestContent == null || !"transactioninfo".equals((transactioninfo = requestContent.getRootElement()).getName())) break block8;
                this.slideToken.setExternalTx();
                Element transactionstatus = transactioninfo.getChild("transactionstatus", Namespace.getNamespace((String)"DAV:"));
                if (transactionstatus == null) break block8;
                Element action = (Element)transactionstatus.getChildren().get(0);
                if (action != null) {
                    if ("commit".equals(action.getName())) {
                        this.command = 2;
                        break block8;
                    }
                    if ("abort".equals(action.getName())) {
                        this.command = 1;
                        break block8;
                    }
                    this.sendError(400, "transactionstatus must be one of commit or abort");
                    throw new WebdavException(400);
                }
                this.sendError(400, "transactionstatus must contain one of commit or abort");
                throw new WebdavException(400);
            }
            catch (WebdavException e) {
                throw e;
            }
            catch (Exception exception) {
                this.sendError(400, exception);
                throw new WebdavException(400);
            }
        }
    }

    protected void executeRequest() throws WebdavException {
        this.slideToken.setForceStoreEnlistment(true);
        if (this.command == 2 || this.command == 1) {
            String fullTxId = "<opaquelocktoken:" + this.lockId + ">";
            ExternalTransactionContext externalTransaction = ExternalTransactionContext.lookupContext((Object)fullTxId);
            if (externalTransaction != null) {
                Transaction tx = externalTransaction.getTransaction();
                try {
                    this.token.getTransactionManager().resume(tx);
                }
                catch (Exception exception) {
                    this.sendError(420, "No such transaction");
                }
            } else {
                this.sendError(420, "No such transaction");
            }
            if (this.command == 2) {
                try {
                    this.token.commit();
                }
                catch (Exception exception) {
                    this.sendError(420, "Could not commit transaction");
                }
            } else if (this.command == 1) {
                try {
                    this.token.rollback();
                }
                catch (Exception exception) {
                    this.sendError(420, "Could not roll back transaction");
                }
            }
            ExternalTransactionContext.deregisterContext((Object)this.lockId);
            this.resp.setStatus(204);
        } else {
            try {
                if (WebdavEvent.UNLOCK.isEnabled()) {
                    EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.UNLOCK, (EventObject)new WebdavEvent(this));
                }
                this.checkPreconditions();
                this.lock.unlock(this.slideToken, this.requestUri, this.lockId);
                NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.requestUri);
                NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, this.requestUri, revisionDescriptor);
                if (Configuration.useVersionControl() && resourceKind instanceof CheckedOutVersionControlled) {
                    NodeProperty checkinLocktokenProperty = revisionDescriptor.getProperty("checkin-locktoken", "http://jakarta.apache.org/slide/");
                    if (checkinLocktokenProperty == null) {
                        checkinLocktokenProperty = revisionDescriptor.getProperty("checkin-locktoken");
                    }
                    if (checkinLocktokenProperty != null && checkinLocktokenProperty.getValue() != null && this.lockId.equals(checkinLocktokenProperty.getValue().toString())) {
                        VersioningHelper versionHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
                        versionHelper.checkin(revisionDescriptors, revisionDescriptor, false, false, true);
                    }
                }
                ObjectNode node = this.structure.retrieve(this.slideToken, this.requestUri);
                if (this.isLockNull(revisionDescriptor)) {
                    this.content.remove(this.slideToken, this.requestUri, revisionDescriptor);
                    this.content.remove(this.slideToken, revisionDescriptors);
                    this.structure.remove(this.slideToken, node);
                }
                this.resp.setStatus(204);
            }
            catch (PreconditionViolationException e) {
                try {
                    this.sendPreconditionViolation(e);
                    throw e;
                }
                catch (IOException x) {
                    throw new WebdavException(e.getStatusCode());
                }
            }
            catch (Exception e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (RevisionDescriptorNotFoundException e) {
            return 200;
        }
        catch (LinkedObjectNotFoundException e) {
            return 404;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    private void checkPreconditions() throws SlideException {
        Enumeration locksAll = this.lock.enumerateLocks(this.slideToken, this.resourcePath, true);
        if (!locksAll.hasMoreElements()) {
            return;
        }
        NodeLock nodeLock = this.findMatchingNodeLock(false);
        if (nodeLock != null) {
            if (!this.lock.checkLockOwner(this.slideToken, nodeLock)) {
                throw new PreconditionViolationException(new ViolatedPrecondition("lock-owner-or-unlock-privilege", 403, UNLOCK_NOT_ALLOWED), this.resourcePath);
            }
        } else {
            nodeLock = this.findMatchingNodeLock(true);
            if (nodeLock != null) {
                throw new PreconditionViolationException(new ViolatedPrecondition("lock-root", 409, IS_NOT_LOCK_ROOT + this.getFullPath(nodeLock.getObjectUri())), this.resourcePath);
            }
            throw new PreconditionViolationException(new ViolatedPrecondition("valid-lock-token", 409, INVALID_LOCK_TOKEN), this.resourcePath);
        }
    }

    private NodeLock findMatchingNodeLock(boolean inherited) throws ObjectNotFoundException, LockTokenNotFoundException, ServiceAccessException {
        NodeLock nodeLock = null;
        Enumeration locks = this.lock.enumerateLocks(this.slideToken, this.resourcePath, inherited);
        while (nodeLock == null && locks.hasMoreElements()) {
            NodeLock nl = (NodeLock)locks.nextElement();
            if (!nl.getLockId().equals(this.lockId)) continue;
            nodeLock = nl;
        }
        return nodeLock;
    }
}

