/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.structure.CrossServerBindingException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.MethodUtil;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.jdom.JDOMException;

public class RebindMethod
extends AbstractWebdavMethod
implements BindConstants,
WriteMethod {
    private String sourceUri;
    private String sourceSegment;
    private String sourceParentUri;
    private String collectionUri;
    private String segment;
    private boolean overwrite;
    private ObjectNode sourceNode = null;
    private ObjectNode sourceParentNode = null;
    private ObjectNode collectionNode = null;

    public RebindMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.collectionUri = this.requestUri;
        if (this.collectionUri == null) {
            this.collectionUri = "/";
        }
        try {
            List content = this.parseRequestContent("rebind").getChildren();
            this.segment = MethodUtil.getChildText(content, "segment");
            this.sourceUri = this.parseUri(MethodUtil.getChildUrl(content, "href"));
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        this.collectionUri = this.requestUri;
        if (this.collectionUri == null) {
            this.collectionUri = "/";
        }
        this.overwrite = this.requestHeaders.getOverwrite(true);
    }

    private void checkPreconditions() throws PreconditionViolationException, ServiceAccessException {
        this.resp.setStatus(201);
        UriHandler sourceUh = UriHandler.getUriHandler(this.sourceUri);
        UriHandler sourceParentUh = sourceUh.getParentUriHandler();
        this.sourceSegment = sourceUh.getName();
        if (sourceParentUh != null) {
            this.sourceParentUri = sourceUh.getParentUriHandler().toString();
        }
        try {
            this.collectionNode = this.structure.retrieve(this.slideToken, this.collectionUri);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (SlideException e) {
            // empty catch block
        }
        try {
            this.sourceNode = this.structure.retrieve(this.slideToken, this.sourceUri);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (SlideException e) {
            // empty catch block
        }
        try {
            this.sourceParentNode = this.structure.retrieve(this.slideToken, this.sourceParentUri);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (SlideException slideException) {
            // empty catch block
        }
        if (this.collectionNode == null || !this.isCollection(this.collectionUri)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("rebind-into-collection", 409), this.collectionUri);
        }
        if (!MethodUtil.isValidSegment(this.segment)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("name-allowed", 403), this.segment);
        }
        if (this.sourceNode == null) {
            throw new PreconditionViolationException(new ViolatedPrecondition("rebind-source-exists", 409), this.sourceUri);
        }
        if (this.collectionNode.hasBinding(this.segment)) {
            if (this.overwrite) {
                this.resp.setStatus(204);
            } else {
                throw new PreconditionViolationException(new ViolatedPrecondition("can-overwrite", 403), this.segment);
            }
        }
        if (this.isCollection(this.sourceUri) && this.isDescendant(this.collectionNode, this.sourceNode)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("cycle-allowed", 403), this.sourceUri);
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.collectionUri)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.collectionUri});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            if (WebdavEvent.REBIND.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.REBIND, (EventObject)new WebdavEvent(this));
            }
            this.checkPreconditions();
            this.structure.addBinding(this.slideToken, this.collectionNode, this.segment, this.sourceNode);
            this.structure.removeBinding(this.slideToken, this.sourceParentNode, this.sourceSegment);
        }
        catch (CrossServerBindingException e) {
            this.sendPreconditionViolation(new PreconditionViolationException(new ViolatedPrecondition("cross-server-binding", 403), this.collectionNode.getUri()));
        }
        catch (ObjectLockedException e) {
            ViolatedPrecondition violatedPrecondition = this.collectionUri.equals(e.getObjectUri()) ? new ViolatedPrecondition("locked-update-allowed", 423) : (this.sourceParentUri.equals(e.getObjectUri()) ? new ViolatedPrecondition("locked-source-collection-update-allowed", 409) : (this.sourceUri.equals(e.getObjectUri()) ? new ViolatedPrecondition("protected-source-url-deletion-allowed", 409) : new ViolatedPrecondition("protected-url-modification-allowed", 409)));
            this.sendPreconditionViolation(new PreconditionViolationException(violatedPrecondition, this.collectionNode.getUri()));
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

