/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.lock.UnlockListener;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.StructureException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.ReadMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.UnlockListenerImpl;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.WebdavStatus;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PropFindMethod
extends AbstractWebdavMethod
implements DeltavConstants,
AclConstants,
ReadMethod {
    protected static final int FIND_BY_PROPERTY = 0;
    protected static final int FIND_ALL_PROP = 1;
    protected static final int FIND_PROPERTY_NAMES = 2;
    protected int depth;
    protected int propFindType;
    protected boolean extendedAllprop = false;
    protected static SAXBuilder saxBuilder = null;
    protected RequestedProperties requestedProperties = null;
    protected String resourcePath;
    protected VersioningHelper versioningHelper = null;
    protected String labelHeader = null;
    protected boolean outputOptimized = true;

    public PropFindMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        block12: {
            this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            this.depth = Integer.MAX_VALUE;
            this.propFindType = 1;
            this.extendedAllprop = this.getBooleanInitParameter("extendedAllprop");
            this.outputOptimized = this.getBooleanInitParameter("optimizePropfindOutput");
            this.resourcePath = this.requestUri;
            if (this.resourcePath == null) {
                this.resourcePath = "/";
            }
            this.labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
            this.retrieveDepth();
            if (this.req.getContentLength() == 0) {
                this.requestedProperties = new RequestedPropertiesImpl();
                this.requestedProperties.setIsAllProp(true);
                this.propFindType = 1;
            } else {
                try {
                    Element element = this.parseRequestContent("propfind");
                    try {
                        element = (Element)element.getChildren().get(0);
                    }
                    catch (Exception e) {
                        int statusCode = 400;
                        this.sendError(statusCode, this.getClass().getName() + ".missingRootElementChildren", new Object[]{"DAV:propfind"});
                        throw new WebdavException(statusCode);
                    }
                    if (element.getName().equalsIgnoreCase("propname")) {
                        this.propFindType = 2;
                        break block12;
                    }
                    if (element.getName().equalsIgnoreCase("prop")) {
                        this.requestedProperties = new RequestedPropertiesImpl(element);
                        this.propFindType = 0;
                        break block12;
                    }
                    if (element.getName().equalsIgnoreCase("allprop")) {
                        this.requestedProperties = new RequestedPropertiesImpl(element);
                        this.propFindType = 1;
                        break block12;
                    }
                    int statusCode = 400;
                    this.sendError(statusCode, this.getClass().getName() + ".invalidChildOfRootElement", new Object[]{element.getNamespace() + ":" + element.getName(), "DAV:propfind"});
                    throw new WebdavException(statusCode);
                }
                catch (JDOMException e) {
                    int statusCode = 400;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (PropertyParseException e) {
                    int statusCode = 400;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (IOException e) {
                    int statusCode = 500;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
        }
    }

    private void retrieveDepth() throws WebdavException {
        this.depth = this.requestHeaders.getDepth(Integer.MAX_VALUE);
        if (this.depth > this.getConfig().getDepthLimit()) {
            this.depth = this.getConfig().getDepthLimit();
        }
    }

    protected void executeRequest() throws IOException, WebdavException {
        this.resp.setStatus(207);
        ObjectNode resource = null;
        try {
            if (WebdavEvent.PROPFIND.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.PROPFIND, (EventObject)new WebdavEvent(this));
            }
            resource = this.structure.retrieve(this.slideToken, this.resourcePath);
        }
        catch (StructureException e) {
            int statusCode = 404;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        this.resp.setContentType("text/xml; charset=\"UTF-8\"");
        Element multistatusElement = new Element("multistatus", DNSP);
        Format format = Format.getPrettyFormat();
        format.setIndent("    ");
        XMLOutputter xmlOutputter = new XMLOutputter(format);
        if (resource != null) {
            if (this.depth == 0) {
                multistatusElement.addContent((Content)this.getPropertiesOfObject(resource.getUri()));
                xmlOutputter.output(new Document(multistatusElement), (Writer)this.resp.getWriter());
            } else {
                Stack<ObjectNode> stack = new Stack<ObjectNode>();
                stack.push(resource);
                Stack<ObjectNode> stackBelow = new Stack<ObjectNode>();
                StringBuffer buffer = new StringBuffer();
                if (this.outputOptimized) {
                    String namespaceUri;
                    this.resp.getWriter().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.resp.getWriter().write("\n");
                    String namespacePrefix = multistatusElement.getNamespacePrefix();
                    if (namespacePrefix != null && namespacePrefix.length() == 0) {
                        namespacePrefix = null;
                    }
                    if ((namespaceUri = multistatusElement.getNamespaceURI()) != null && namespaceUri.length() == 0) {
                        namespaceUri = null;
                    }
                    buffer.append("<");
                    buffer.append(multistatusElement.getQualifiedName());
                    if (namespaceUri != null) {
                        buffer.append(" xmlns");
                        if (namespacePrefix != null) {
                            buffer.append(":");
                            buffer.append(namespacePrefix);
                        }
                        buffer.append("=\"");
                        buffer.append(namespaceUri);
                        buffer.append("\"");
                    }
                    buffer.append(">");
                    this.resp.getWriter().write(buffer.toString());
                    this.resp.getWriter().write("\n");
                }
                while (!stack.isEmpty() && this.depth >= 0) {
                    ObjectNode cur = (ObjectNode)stack.pop();
                    Element response = this.getPropertiesOfObject(cur.getUri());
                    if (this.outputOptimized) {
                        xmlOutputter.output(response, (Writer)this.resp.getWriter());
                    } else {
                        multistatusElement.addContent((Content)response);
                    }
                    if (this.depth > 0) {
                        Enumeration enumeration = null;
                        try {
                            enumeration = this.structure.getChildren(this.slideToken, cur);
                        }
                        catch (Exception e) {
                            int statusCode = this.getErrorCode(e);
                            this.sendError(statusCode, e);
                            throw new WebdavException(statusCode);
                        }
                        while (enumeration.hasMoreElements()) {
                            ObjectNode node = (ObjectNode)enumeration.nextElement();
                            UnlockListenerImpl listener = new UnlockListenerImpl(this.slideToken, this.token, this.config, this.req, this.resp);
                            try {
                                this.lock.clearExpiredLocks(this.slideToken, node.getUri(), (UnlockListener)listener);
                                if (listener.isRemovedLockResource(node.getUri())) continue;
                                stackBelow.push(node);
                            }
                            catch (SlideException e) {}
                        }
                    }
                    if (!stack.isEmpty()) continue;
                    --this.depth;
                    stack = stackBelow;
                    stackBelow = new Stack();
                }
                if (this.outputOptimized) {
                    this.resp.getWriter().write("\n");
                    buffer.setLength(0);
                    buffer.append("</");
                    buffer.append(multistatusElement.getQualifiedName());
                    buffer.append(">");
                    this.resp.getWriter().write(buffer.toString());
                    this.resp.getWriter().write("\n");
                } else {
                    xmlOutputter.output(new Document(multistatusElement), (Writer)this.resp.getWriter());
                }
            }
        }
    }

    protected Element getPropertiesOfObject(String resourceUri) throws WebdavException {
        SlideTokenWrapper lightSToken = new SlideTokenWrapper(this.slideToken);
        lightSToken.setForceLock(false);
        if (Configuration.useVersionControl()) {
            try {
                resourceUri = this.versioningHelper.getLabeledResourceUri(resourceUri, this.labelHeader);
            }
            catch (LabeledRevisionNotFoundException e) {
                return this.getErrorResponse(resourceUri, 409, "must-select-version-in-history");
            }
            catch (RevisionDescriptorNotFoundException x) {
            }
            catch (SlideException e) {
                return this.getErrorResponse(resourceUri, this.getErrorCode(e), null);
            }
        }
        ObjectNode object = null;
        try {
            object = this.structure.retrieve((SlideToken)lightSToken, resourceUri);
        }
        catch (SlideException e) {
            return this.getErrorResponse(resourceUri, this.getErrorCode(e), null);
        }
        Element responseElement = new Element("response", DNSP);
        String status = new String("HTTP/1.1200 " + WebdavStatus.getStatusText(200));
        NodeRevisionDescriptors revisionDescriptors = null;
        NodeRevisionDescriptor revisionDescriptor = null;
        try {
            Element hrefElement = new Element("href", DNSP);
            String resourcePath = object.getUri();
            revisionDescriptors = this.content.retrieve((SlideToken)lightSToken, resourcePath);
            try {
                revisionDescriptor = this.content.retrieve((SlideToken)lightSToken, revisionDescriptors);
                hrefElement.setText(WebdavUtils.getAbsolutePath(object.getUri(), this.req, this.getConfig()));
            }
            catch (RevisionDescriptorNotFoundException e) {
                revisionDescriptor = new NodeRevisionDescriptor(0L);
                if (!Configuration.useBinding((Store)this.token.getUri((SlideToken)lightSToken, object.getUri()).getStore())) {
                    revisionDescriptor.setName(new UriPath(object.getUri()).lastSegment());
                }
                hrefElement.setText(WebdavUtils.getAbsolutePath(object.getUri(), this.req, this.getConfig()));
            }
            responseElement.addContent((Content)hrefElement);
        }
        catch (AccessDeniedException e) {
            if (revisionDescriptor == null) {
                revisionDescriptor = new NodeRevisionDescriptor(0L);
            }
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        PropertyRetrieverImpl propertyRetriever = new PropertyRetrieverImpl(this.token, (SlideToken)lightSToken, this.getConfig());
        switch (this.propFindType) {
            case 0: 
            case 1: {
                try {
                    List propstatList = propertyRetriever.getPropertiesOfObject(this.requestedProperties, revisionDescriptors, revisionDescriptor, this.getSlideContextPath(), this.extendedAllprop);
                    Iterator iterator = propstatList.iterator();
                    while (iterator.hasNext()) {
                        responseElement.addContent((Content)((Element)iterator.next()));
                    }
                    break;
                }
                catch (ServiceAccessException e) {
                    int statusCode = 403;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (Exception e) {
                    int statusCode = this.getErrorCode(e);
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
            case 2: {
                try {
                    status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
                    Element propstatElement = new Element("propstat", DNSP);
                    Element propElement = new Element("prop", DNSP);
                    RequestedProperties propnames = propertyRetriever.getAllPropertyNames(object.getUri(), true);
                    Iterator iterator = propnames.getRequestedProperties();
                    while (iterator.hasNext()) {
                        RequestedProperty p = (RequestedProperty)iterator.next();
                        Namespace nsp = DNSP.getURI().equals(p.getNamespace()) ? DNSP : Namespace.getNamespace((String)p.getNamespace());
                        propElement.addContent((Content)new Element(p.getName(), nsp));
                    }
                    Element statusElement = new Element("status", DNSP);
                    statusElement.setText(status);
                    propstatElement.addContent((Content)propElement);
                    propstatElement.addContent((Content)statusElement);
                    responseElement.addContent((Content)propstatElement);
                    break;
                }
                catch (ServiceAccessException e) {
                    int statusCode = 403;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
                catch (Exception e) {
                    int statusCode = this.getErrorCode(e);
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
        }
        return responseElement;
    }

    private Element getErrorResponse(String resourcePath, int errorCode, String condition) {
        Element response = new Element("response", DNSP);
        Element href = new Element("href", DNSP);
        href.setText("http://" + this.req.getServerName() + ":" + this.req.getServerPort() + this.getSlideContextPath() + resourcePath);
        response.addContent((Content)href);
        Element propStat = new Element("propstat", DNSP);
        response.addContent((Content)propStat);
        Element status = new Element("status", DNSP);
        status.setText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
        propStat.addContent((Content)status);
        if (condition != null) {
            Element responseDescriptiont = new Element("responsedescription", DNSP);
            Element errorElement = new Element("error", DNSP);
            responseDescriptiont.addContent((Content)errorElement);
            Element conditionElement = new Element(condition, DNSP);
            errorElement.addContent((Content)conditionElement);
            propStat.addContent((Content)responseDescriptiont);
        }
        return response;
    }
}

