/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.Writer;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.RemoteInformation;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.NotificationTrigger;
import org.apache.slide.webdav.event.Subscriber;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.NotificationConstants;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PollMethod
extends AbstractWebdavMethod
implements NotificationConstants {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$webdav$method$PollMethod == null ? (class$org$apache$slide$webdav$method$PollMethod = PollMethod.class$("org.apache.slide.webdav.method.PollMethod")) : class$org$apache$slide$webdav$method$PollMethod).getName();
    protected static final Namespace NNSP = Namespace.getNamespace((String)"N", (String)"http://schemas.microsoft.com/Exchange/");
    private XMLOutputter xmlOut;
    static /* synthetic */ Class class$org$apache$slide$webdav$method$PollMethod;

    public PollMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
        Format format = Format.getPrettyFormat();
        format.setIndent("    ");
        this.xmlOut = new XMLOutputter(format);
    }

    protected void parseRequest() throws WebdavException {
    }

    protected void executeRequest() throws WebdavException {
        try {
            if (WebdavEvent.POLL.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.POLL, (EventObject)new WebdavEvent(this));
            }
            int[] subscriptionID = this.requestHeaders.getSubscriptionId();
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            this.resp.setStatus(207);
            Element multistatus = new Element("multistatus", DNSP);
            boolean content = false;
            boolean noContent = false;
            Element contentResponse = new Element("response", DNSP);
            int statusCode = 200;
            this.generateStatusText(contentResponse, this.requestUri, statusCode);
            Element noContentResponse = new Element("response", DNSP);
            statusCode = 204;
            this.generateStatusText(noContentResponse, this.requestUri, statusCode);
            Element subscriptionIdContent = new Element("subscriptionID", NNSP);
            Element subscriptionIdNoContent = new Element("subscriptionID", NNSP);
            contentResponse.addContent((Content)subscriptionIdContent);
            noContentResponse.addContent((Content)subscriptionIdNoContent);
            for (int i = 0; i < subscriptionID.length; ++i) {
                Element listener;
                Subscriber subscriber = NotificationTrigger.getInstance().getSubscriber(subscriptionID[i]);
                if (subscriber == null) continue;
                NotificationTrigger.getInstance().refreshSubscriber(subscriber, true);
                List events = subscriber.getEvents();
                if (events.size() == 0) {
                    noContent = true;
                    listener = new Element("li");
                    listener.addContent(String.valueOf(subscriber.getId()));
                    subscriptionIdNoContent.addContent((Content)listener);
                    continue;
                }
                content = true;
                listener = new Element("li");
                listener.addContent(String.valueOf(subscriber.getId()));
                subscriptionIdContent.addContent((Content)listener);
                Iterator j = events.iterator();
                while (j.hasNext()) {
                    EventObject event = (EventObject)j.next();
                    if (!(event instanceof RemoteInformation)) continue;
                    Element eventElement = new Element("event", NNSP);
                    String[][] information = ((RemoteInformation)event).getInformation();
                    for (int k = 0; k < information.length; ++k) {
                        Element entry = new Element("information", NNSP);
                        entry.setAttribute("name", information[k][0]);
                        if ("uri".equals(information[k][0])) {
                            entry.addContent(this.getSlideContextPath() + String.valueOf(information[k][1]));
                        } else {
                            entry.addContent(String.valueOf(information[k][1]));
                        }
                        eventElement.addContent((Content)entry);
                    }
                    subscriptionIdContent.addContent((Content)eventElement);
                }
                subscriber.clearEvents();
            }
            if (content) {
                multistatus.addContent((Content)contentResponse);
            }
            if (noContent) {
                multistatus.addContent((Content)noContentResponse);
            }
            this.xmlOut.output(new Document(multistatus), (Writer)this.resp.getWriter());
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

