/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.macro.CopyListener;
import org.apache.slide.macro.DeleteListener;
import org.apache.slide.macro.Macro;
import org.apache.slide.macro.MacroException;
import org.apache.slide.macro.MacroParameters;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.DeltavCompliantUnmappedUrl;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.VersionControlled;
import org.apache.slide.webdav.util.resourcekind.Working;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class MoveMethod
extends AbstractMultistatusResponseMethod
implements DeltavConstants,
DeleteListener,
CopyListener,
WriteMethod {
    protected VersioningHelper versioningHelper = null;
    protected PropertyHelper propertyHelper = null;
    protected boolean isRequestSourceWorkspace = false;
    protected boolean isCopySourceVCR = false;
    protected Element basicSearch = null;
    protected Element literal = null;
    private boolean destinationExistsBefore = false;

    public MoveMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.propertyHelper = PropertyHelper.getPropertyHelper(this.slideToken, this.token, this.getConfig());
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.sourceUri)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.sourceUri});
                throw new WebdavException(statusCode);
            }
            if (this.isLocked(this.sourceUri)) {
                int statusCode = 423;
                this.sendError(statusCode, this.getClass().getName() + ".noLocked", new Object[]{this.sourceUri});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        int depth = this.requestHeaders.getDepth(Integer.MAX_VALUE);
        if (depth < Integer.MAX_VALUE) {
            int sc = 412;
            this.sendError(sc, "Invalid header Depth: " + depth);
            throw new WebdavException(sc);
        }
        MacroParameters macroParameters = null;
        boolean isCollection = this.isCollection(this.sourceUri);
        macroParameters = this.overwrite ? Macro.RECURSIVE_OVERWRITE_PARAMETERS : Macro.DEFAULT_PARAMETERS;
        UriHandler destinationUriHandler = UriHandler.getUriHandler(this.destinationUri);
        if (destinationUriHandler.isRestrictedUri()) {
            int statusCode = 403;
            this.sendError(statusCode, this.getClass().getName() + ".restrictedDestinationUri", new Object[]{this.destinationUri});
            throw new WebdavException(statusCode);
        }
        UriHandler sourceUriHandler = UriHandler.getUriHandler(this.sourceUri);
        this.isRequestSourceWorkspace = sourceUriHandler.isWorkspaceUri();
        try {
            ViolatedPrecondition violatedPrecondition = this.getPreconditionViolation(this.sourceUri, this.destinationUri);
            if (violatedPrecondition != null) {
                PreconditionViolationException e = new PreconditionViolationException(violatedPrecondition, this.sourceUri);
                this.sendPreconditionViolation(e);
                throw e;
            }
            this.destinationExistsBefore = this.exists(this.destinationUri);
            if (!this.overwrite && this.destinationExistsBefore) {
                int statusCode = 412;
                this.sendError(statusCode, this.getClass().getName() + ".noOverwrite", new Object[]{this.destinationUri});
                throw new WebdavException(statusCode);
            }
            if (WebdavEvent.MOVE.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.MOVE, (EventObject)new WebdavEvent(this));
            }
            this.macro.move(this.slideToken, this.sourceUri, this.destinationUri, macroParameters, null, (CopyListener)this, null, (DeleteListener)this);
            if (this.overwrite && this.destinationExistsBefore) {
                this.resp.setStatus(204);
            } else {
                this.resp.setStatus(201);
            }
        }
        catch (MacroException e) {
            if (MoveMethod.generateMultiStatusResponse(isCollection, (NestedSlideException)((Object)e), this.requestUri)) {
                String errorMessage = this.generateErrorMessage((NestedSlideException)((Object)e));
                this.resp.setStatus(207);
                try {
                    this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                    this.resp.getWriter().write(errorMessage);
                }
                catch (IOException ex) {
                    int statusCode = 500;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            } else {
                SlideException exception = (SlideException)((Object)e.enumerateExceptions().nextElement());
                if (exception instanceof PreconditionViolationException) {
                    try {
                        this.sendPreconditionViolation((PreconditionViolationException)exception);
                    }
                    catch (IOException ex) {
                        int statusCode = 500;
                        this.sendError(statusCode, e);
                        throw new WebdavException(statusCode);
                    }
                } else {
                    int statusCode = this.getErrorCode(exception);
                    this.sendError(statusCode, exception);
                    throw new WebdavException(statusCode);
                }
            }
            throw new WebdavException(202, false);
        }
        catch (SlideException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (RevisionNotFoundException e) {
            return 404;
        }
        catch (SlideException e) {
            return super.getErrorCode(e);
        }
    }

    private ViolatedPrecondition getPreconditionViolation(String sourceUri, String destinationUri) throws SlideException {
        ObjectNode sourceNode;
        ObjectNode destinationParentNode;
        UriHandler destinationUriHandler;
        ViolatedPrecondition violatedPrecondition = null;
        if (Configuration.useVersionControl() && this.isRequestSourceWorkspace) {
            destinationUriHandler = UriHandler.getUriHandler(destinationUri);
            NodeRevisionDescriptors destinationRevisionDescriptors = null;
            NodeRevisionDescriptor destinationRevisionDescriptor = null;
            try {
                destinationRevisionDescriptors = this.content.retrieve(this.slideToken, destinationUri);
                destinationRevisionDescriptor = this.content.retrieve(this.slideToken, destinationRevisionDescriptors);
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            ResourceKind destinationResourceKind = AbstractResourceKind.determineResourceKind(this.token, destinationUri, destinationRevisionDescriptor);
            if (!(destinationResourceKind instanceof DeltavCompliantUnmappedUrl)) {
                return new ViolatedPrecondition("resource-must-be-null", 409);
            }
            if (!destinationUriHandler.isWorkspaceUri()) {
                return new ViolatedPrecondition("workspace-location-ok", 409);
            }
        }
        if (this.isCollection(sourceUri) && this.isDescendant(destinationParentNode = this.structure.retrieve(this.slideToken, (destinationUriHandler = UriHandler.getUriHandler(destinationUri)).getParentUriHandler().toString()), sourceNode = this.structure.retrieve(this.slideToken, sourceUri))) {
            return new ViolatedPrecondition("cycle-allowed", 403);
        }
        return violatedPrecondition;
    }

    public void beforeCopy(String sourceUri, String destinationUri, boolean isRootOfCopy) throws SlideException {
        if (Configuration.useVersionControl()) {
            UriHandler uriHandler = UriHandler.getUriHandler(sourceUri);
            if (uriHandler.isVersionUri()) {
                throw new PreconditionViolationException(new ViolatedPrecondition("cannot-rename-version", 403), sourceUri);
            }
            if (uriHandler.isHistoryUri()) {
                throw new PreconditionViolationException(new ViolatedPrecondition("cannot-rename-history", 403), sourceUri);
            }
            if (uriHandler.isWorkingresourceUri()) {
                throw new PreconditionViolationException(new ViolatedPrecondition("cannot-rename-working-resource", 403), sourceUri);
            }
            NodeRevisionDescriptors sourceRevisionDescriptors = this.content.retrieve(this.slideToken, sourceUri);
            NodeRevisionDescriptor sourceRevisionDescriptor = this.content.retrieve(this.slideToken, sourceRevisionDescriptors);
            ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, sourceRevisionDescriptors, sourceRevisionDescriptor);
            this.isCopySourceVCR = resourceKind instanceof VersionControlled;
            if (resourceKind instanceof CheckedOutVersionControlled || resourceKind instanceof Working) {
                String vrUri = VersioningHelper.getUriOfAssociatedVR(this.token, this.slideToken, this.content, sourceUri);
                NodeRevisionDescriptors vrNrds = this.content.retrieve(this.slideToken, vrUri);
                NodeRevisionDescriptor vrNrd = this.content.retrieve(this.slideToken, vrNrds);
                try {
                    PropertyHelper.removeHrefFromProperty(vrNrd, "checkout-set", sourceUri);
                    PropertyHelper.addHrefToProperty(vrNrd, "checkout-set", destinationUri);
                    this.content.store(this.slideToken, vrNrds.getUri(), vrNrd, null);
                }
                catch (JDOMException e) {
                    throw new SlideException("Unable to update DAV:checkout-set of " + vrUri + ": " + e.getMessage());
                }
            }
        }
    }

    public void afterCopy(String sourceUri, String destinationUri, boolean isRootOfCopy, boolean destinationExists) throws SlideException {
        if (Configuration.useVersionControl()) {
            NodeRevisionDescriptors sourceNrds = this.content.retrieve(this.slideToken, sourceUri);
            NodeRevisionDescriptors destinationNrds = this.content.retrieve(this.slideToken, destinationUri);
            NodeRevisionDescriptor destinationNrd = this.content.retrieve(this.slideToken, destinationNrds);
            try {
                NodeRevisionDescriptor sourceNrd00 = this.content.retrieve(this.slideToken, sourceNrds, NodeRevisionNumber.HIDDEN_0_0);
                NodeRevisionDescriptor destinationNrd00 = sourceNrd00.cloneObject();
                try {
                    this.content.retrieve(this.slideToken, destinationNrds, NodeRevisionNumber.HIDDEN_0_0);
                    this.content.store(this.slideToken, destinationUri, destinationNrd00, null);
                }
                catch (RevisionDescriptorNotFoundException x) {
                    this.content.create(this.slideToken, destinationUri, null, destinationNrd00, null);
                }
            }
            catch (ServiceAccessException e) {
                throw e;
            }
            catch (SlideException e) {
                // empty catch block
            }
            this.handleWorkspacePostconditions(destinationNrd, destinationUri);
            this.handleWorkingResourcePostconditions(sourceUri, destinationUri);
        }
    }

    private void handleWorkingResourcePostconditions(String sourceUri, String destinationUri) throws SlideException {
        if (this.isCopySourceVCR) {
            Element basicSearch = this.getWorkingResourceSearchElement(sourceUri);
            String grammarNamespace = basicSearch.getNamespaceURI();
            Search searchHelper = this.token.getSearchHelper();
            SearchQuery searchQuery = searchHelper.createSearchQuery(grammarNamespace, basicSearch, this.slideToken, Integer.MAX_VALUE, this.getSlideContextPath() + sourceUri);
            SearchQueryResult queryResult = searchHelper.search(this.slideToken, searchQuery);
            Iterator queryResultIterator = queryResult.iterator();
            RequestedResource requestedResource = null;
            NodeRevisionDescriptors workingResourceRevisionDescriptors = null;
            NodeRevisionDescriptor workingResourceRevisionDescriptor = null;
            NodeProperty autoUpdateProperty = null;
            String workingResourceUri = null;
            while (queryResultIterator.hasNext()) {
                requestedResource = (RequestedResource)queryResultIterator.next();
                workingResourceUri = requestedResource.getUri();
                workingResourceRevisionDescriptors = this.content.retrieve(this.slideToken, workingResourceUri);
                workingResourceRevisionDescriptor = this.content.retrieve(this.slideToken, workingResourceRevisionDescriptors);
                autoUpdateProperty = new NodeProperty("auto-update", this.propertyHelper.createHrefValue(destinationUri));
                workingResourceRevisionDescriptor.setProperty(autoUpdateProperty);
                this.content.store(this.slideToken, workingResourceRevisionDescriptors.getUri(), workingResourceRevisionDescriptor, null);
            }
        }
    }

    protected Element getWorkingResourceSearchElement(String resourcePath) {
        if (this.basicSearch == null) {
            this.basicSearch = new Element("basicsearch", DNSP);
            Element select = new Element("select", DNSP);
            this.basicSearch.addContent((Content)select);
            Element prop = new Element("prop", DNSP);
            select.addContent((Content)prop);
            Element autoUpdate = new Element("auto-update", DNSP);
            prop.addContent((Content)autoUpdate);
            Element from = new Element("from", DNSP);
            this.basicSearch.addContent((Content)from);
            Element scope = new Element("scope", DNSP);
            from.addContent((Content)scope);
            Element href = new Element("href", DNSP);
            scope.addContent((Content)href);
            href.setText("");
            Iterator excludeIterator = this.propertyHelper.getNonVcrPathExcludeList().iterator();
            while (excludeIterator.hasNext()) {
                scope.addContent((Content)((Element)excludeIterator.next()));
            }
            Element where = new Element("where", DNSP);
            this.basicSearch.addContent((Content)where);
            Element propcontains = new Element("propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
            where.addContent((Content)propcontains);
            propcontains.addContent((Content)((Element)prop.clone()));
            this.literal = new Element("literal", DNSP);
            propcontains.addContent((Content)this.literal);
        }
        this.literal.setText(resourcePath);
        return this.basicSearch;
    }

    protected void handleWorkspacePostconditions(NodeRevisionDescriptor revisionDescriptor, String resourceUri) throws SlideException {
        if (Configuration.useVersionControl()) {
            if (this.isRequestSourceWorkspace) {
                revisionDescriptor.setProperty(new NodeProperty("workspace", this.propertyHelper.createHrefValue(this.destinationUri)));
            } else {
                this.versioningHelper.setWorkspaceProperty(resourceUri, revisionDescriptor);
            }
            this.content.store(this.slideToken, resourceUri, revisionDescriptor, null);
        }
    }

    public void beforeDelete(String targetUri) throws SlideException {
    }

    public void afterDelete(String targetUri) throws SlideException {
    }
}

