/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.util.List;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public abstract class MethodUtil {
    public static String getErrorMessage(Throwable ex) {
        if (!(ex instanceof SlideException)) {
            return "";
        }
        return MethodUtil.getErrorMessage((SlideException)ex);
    }

    public static String getErrorMessage(SlideException ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ConflictException e) {
            return e.getObjectUri();
        }
        catch (ForbiddenException e) {
            return e.getObjectUri();
        }
        catch (AccessDeniedException e) {
            return e.getObjectUri();
        }
        catch (ObjectAlreadyExistsException e) {
            return e.getObjectUri();
        }
        catch (ServiceAccessException e) {
            return MethodUtil.getErrorMessage(e);
        }
        catch (LinkedObjectNotFoundException e) {
            return e.getTargetUri();
        }
        catch (RevisionNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ObjectLockedException e) {
            return e.getObjectUri();
        }
        catch (PreconditionViolationException e) {
            return e.getObjectUri();
        }
        catch (SlideException e) {
            return e.getMessage();
        }
    }

    public static String getErrorMessage(ServiceAccessException ex) {
        Throwable cause = ex.getCauseException();
        if (cause == null || !(cause instanceof SlideException)) {
            return "";
        }
        return MethodUtil.getErrorMessage((SlideException)cause);
    }

    public static Element getPreconditionViolationError(ViolatedPrecondition violatedPrecondition) {
        return MethodUtil.getPreconditionViolationError(violatedPrecondition, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
    }

    public static Element getPreconditionViolationError(ViolatedPrecondition violatedPrecondition, Namespace namespace) {
        Element error = new Element("error", namespace);
        Element violatedPreconditionElement = new Element(violatedPrecondition.getPrecondition(), namespace);
        error.addContent((Content)violatedPreconditionElement);
        return error;
    }

    public static Element getPreconditionViolationResponseDescription(PreconditionViolationException pve) {
        Element responseDescription = new Element("responsedescription", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        responseDescription.addContent((Content)MethodUtil.getPreconditionViolationError(pve.getViolatedPrecondition()));
        return responseDescription;
    }

    public static String getURI(Throwable ex) {
        if (!(ex instanceof SlideException)) {
            return "";
        }
        return MethodUtil.getURI((SlideException)ex);
    }

    public static String getURI(SlideException ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ConflictException e) {
            return e.getObjectUri();
        }
        catch (ForbiddenException e) {
            return e.getObjectUri();
        }
        catch (AccessDeniedException e) {
            return e.getObjectUri();
        }
        catch (ObjectAlreadyExistsException e) {
            return e.getObjectUri();
        }
        catch (ServiceAccessException e) {
            return MethodUtil.getURI((ServiceAccessException)((Object)ex));
        }
        catch (LinkedObjectNotFoundException e) {
            return e.getTargetUri();
        }
        catch (RevisionNotFoundException e) {
            return e.getObjectUri();
        }
        catch (ObjectLockedException e) {
            return e.getObjectUri();
        }
        catch (SlideException e) {
            return "";
        }
    }

    private static String getURI(ServiceAccessException ex) {
        Throwable cause = ex.getCauseException();
        if (cause == null || !(cause instanceof SlideException)) {
            return "";
        }
        return MethodUtil.getURI((SlideException)cause);
    }

    public static boolean isValidSegment(String segment) {
        return segment.indexOf(47) == -1;
    }

    public static String getChildUrl(List children, String elementName) throws JDOMException {
        return MethodUtil.getChildText(children, elementName);
    }

    public static String getChildText(List children, String elementName) throws JDOMException {
        Element found = null;
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            Element child = (Element)children.get(i);
            if (!child.getName().equals(elementName)) continue;
            if (found != null) {
                throw new JDOMException("multiple child elements '" + elementName + "' found.");
            }
            found = child;
        }
        if (found == null) {
            throw new JDOMException("child element '" + elementName + "' not found.");
        }
        return found.getText();
    }
}

