/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavMethod;
import org.apache.slide.webdav.WebdavMethodFactory;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AclMethod;
import org.apache.slide.webdav.method.BindMethod;
import org.apache.slide.webdav.method.CheckinMethod;
import org.apache.slide.webdav.method.CheckoutMethod;
import org.apache.slide.webdav.method.CopyMethod;
import org.apache.slide.webdav.method.DeleteMethod;
import org.apache.slide.webdav.method.EventMethod;
import org.apache.slide.webdav.method.GetMethod;
import org.apache.slide.webdav.method.HeadMethod;
import org.apache.slide.webdav.method.LabelMethod;
import org.apache.slide.webdav.method.LockMethod;
import org.apache.slide.webdav.method.MkcolMethod;
import org.apache.slide.webdav.method.MkworkspaceMethod;
import org.apache.slide.webdav.method.MoveMethod;
import org.apache.slide.webdav.method.OptionsMethod;
import org.apache.slide.webdav.method.PollMethod;
import org.apache.slide.webdav.method.PostMethod;
import org.apache.slide.webdav.method.PropFindMethod;
import org.apache.slide.webdav.method.PropPatchMethod;
import org.apache.slide.webdav.method.PutMethod;
import org.apache.slide.webdav.method.RebindMethod;
import org.apache.slide.webdav.method.ReportMethod;
import org.apache.slide.webdav.method.SearchMethod;
import org.apache.slide.webdav.method.SubscribeMethod;
import org.apache.slide.webdav.method.UnbindMethod;
import org.apache.slide.webdav.method.UncheckoutMethod;
import org.apache.slide.webdav.method.UnlockMethod;
import org.apache.slide.webdav.method.UnsubscribeMethod;
import org.apache.slide.webdav.method.UpdateMethod;
import org.apache.slide.webdav.method.VersionControlMethod;

public class DefaultMethodFactory
extends WebdavMethodFactory {
    private WebdavServletConfig config;
    private NamespaceAccessToken token;

    public WebdavMethod createMethod(String name) {
        if (this.config == null || this.token == null) {
            throw new IllegalStateException();
        }
        if (name.equals("GET")) {
            return new GetMethod(this.token, this.config);
        }
        if (name.equals("PROPFIND")) {
            return new PropFindMethod(this.token, this.config);
        }
        if (name.equals("HEAD")) {
            return new HeadMethod(this.token, this.config);
        }
        if (name.equals("LOCK")) {
            return new LockMethod(this.token, this.config);
        }
        if (name.equals("UNLOCK")) {
            return new UnlockMethod(this.token, this.config);
        }
        if (name.equals("OPTIONS")) {
            return new OptionsMethod(this.token, this.config);
        }
        if (name.equals("PUT")) {
            return new PutMethod(this.token, this.config);
        }
        if (name.equals("MKCOL")) {
            return new MkcolMethod(this.token, this.config);
        }
        if (name.equals("POST")) {
            return new PostMethod(this.token, this.config);
        }
        if (name.equals("COPY")) {
            return new CopyMethod(this.token, this.config);
        }
        if (name.equals("MOVE")) {
            return new MoveMethod(this.token, this.config);
        }
        if (name.equals("DELETE")) {
            return new DeleteMethod(this.token, this.config);
        }
        if (name.equals("PROPPATCH")) {
            return new PropPatchMethod(this.token, this.config);
        }
        if (name.equals("REPORT")) {
            return new ReportMethod(this.token, this.config);
        }
        if (name.equals("SUBSCRIBE")) {
            return new SubscribeMethod(this.token, this.config);
        }
        if (name.equals("UNSUBSCRIBE")) {
            return new UnsubscribeMethod(this.token, this.config);
        }
        if (name.equals("POLL")) {
            return new PollMethod(this.token, this.config);
        }
        if (name.equals("EVENT")) {
            return new EventMethod(this.token, this.config);
        }
        if (Configuration.useIntegratedSecurity() && name.equals("ACL")) {
            return new AclMethod(this.token, this.config);
        }
        if (Configuration.useSearch() && name.equals("SEARCH")) {
            return new SearchMethod(this.token, this.config);
        }
        if (Configuration.useVersionControl()) {
            if (name.equals("VERSION-CONTROL")) {
                return new VersionControlMethod(this.token, this.config);
            }
            if (name.equals("CHECKIN")) {
                return new CheckinMethod(this.token, this.config);
            }
            if (name.equals("CHECKOUT")) {
                return new CheckoutMethod(this.token, this.config);
            }
            if (name.equals("UNCHECKOUT")) {
                return new UncheckoutMethod(this.token, this.config);
            }
            if (name.equals("MKWORKSPACE")) {
                return new MkworkspaceMethod(this.token, this.config);
            }
            if (name.equals("LABEL")) {
                return new LabelMethod(this.token, this.config);
            }
            if (name.equals("UPDATE")) {
                return new UpdateMethod(this.token, this.config);
            }
        }
        if (Configuration.useGlobalBinding()) {
            if (name.equals("BIND")) {
                return new BindMethod(this.token, this.config);
            }
            if (name.equals("UNBIND")) {
                return new UnbindMethod(this.token, this.config);
            }
            if (name.equals("REBIND")) {
                return new RebindMethod(this.token, this.config);
            }
        }
        return null;
    }

    protected boolean getBooleanInitParameter(String name) {
        return !"false".equalsIgnoreCase(this.config.getInitParameter(name));
    }

    protected void setConfig(WebdavServletConfig config) {
        this.config = config;
        this.token = (NamespaceAccessToken)config.getServletContext().getAttribute("org.apache.slide.NamespaceAccessToken");
    }
}

