/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CheckinMethod
extends AbstractWebdavMethod
implements DeltavConstants,
WriteMethod {
    private String resourcePath;
    private boolean forkOk = false;
    private boolean keepCheckedOut = false;

    public CheckinMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        if (this.req.getContentLength() > 0) {
            try {
                Iterator i = this.parseRequestContent("checkin").getChildren().iterator();
                while (i.hasNext()) {
                    Element e = (Element)i.next();
                    if (e.getName().equals("fork-ok")) {
                        this.forkOk = true;
                    }
                    if (!e.getName().equals("keep-checked-out")) continue;
                    this.keepCheckedOut = true;
                }
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (JDOMException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeRequest() throws WebdavException, IOException {
        String locationValue = null;
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            try {
                VersioningHelper vh = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
                if (WebdavEvent.CHECKIN.isEnabled()) {
                    EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.CHECKIN, (EventObject)new WebdavEvent(this));
                }
                locationValue = vh.checkin(this.resourcePath, this.forkOk, this.keepCheckedOut, false);
            }
            catch (PreconditionViolationException e) {
                this.sendPreconditionViolation(e);
                throw e;
            }
            catch (Exception e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.resp.setHeader("Cache-Control", "no-cache");
            if (locationValue == null) throw throwable;
            if (locationValue.length() <= 0) throw throwable;
            locationValue = this.getFullPath(locationValue);
            this.resp.setHeader("Location", WebdavUtils.encodeURL(locationValue, "utf-8"));
            throw throwable;
        }
        this.resp.setHeader("Cache-Control", "no-cache");
        if (locationValue == null) return;
        if (locationValue.length() <= 0) return;
        locationValue = this.getFullPath(locationValue);
        this.resp.setHeader("Location", WebdavUtils.encodeURL(locationValue, "utf-8"));
    }
}

