/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.PrintWriterLogger;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.UnlockListener;
import org.apache.slide.macro.Macro;
import org.apache.slide.search.Search;
import org.apache.slide.security.Security;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.transaction.ExternalTransactionContext;
import org.apache.slide.util.Messages;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavMethod;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.MethodUtil;
import org.apache.slide.webdav.method.ReadMethod;
import org.apache.slide.webdav.method.UnlockMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.NotificationConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.TransactionConstants;
import org.apache.slide.webdav.util.UnlockListenerImpl;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavStatus;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractWebdavMethod
implements WebdavMethod,
WebdavConstants,
DeltavConstants,
BindConstants,
NotificationConstants,
TransactionConstants {
    protected static final String NO_CACHE = "no-cache";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTP_VERSION = "HTTP/1.1";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=\"UTF-8\"";
    public static final String XML_RESPONSE_INDENT = "    ";
    private static final String LOG_CHANNEL = (class$org$apache$slide$webdav$method$AbstractWebdavMethod == null ? (class$org$apache$slide$webdav$method$AbstractWebdavMethod = AbstractWebdavMethod.class$("org.apache.slide.webdav.method.AbstractWebdavMethod")) : class$org$apache$slide$webdav$method$AbstractWebdavMethod).getName();
    public static final int INFINITY = Integer.MAX_VALUE;
    protected static final Namespace DNSP = NodeProperty.NamespaceCache.DEFAULT_NAMESPACE;
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private static final MultiLevelLock GLOBAL_LOCK = new GenericLock((Object)"global", 2, (LoggerFacade)new PrintWriterLogger(new PrintWriter(System.out), LOG_CHANNEL, false));
    protected String requestUri;
    protected HttpServletRequest req;
    protected HttpServletResponse resp;
    protected WebdavServletConfig config;
    protected String slideContextPath;
    protected String requestBody;
    protected NamespaceAccessToken token;
    protected Structure structure;
    protected Content content;
    protected Security security;
    protected Lock lock;
    protected Search search;
    protected Macro macro;
    protected SlideToken slideToken;
    private Document requestContentDocument = null;
    private boolean isRequestContentParsed = false;
    protected RequestHeaders requestHeaders = new RequestHeaders();
    static /* synthetic */ Class class$org$apache$slide$webdav$method$AbstractWebdavMethod;

    public AbstractWebdavMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        this.config = config;
        this.token = token;
        this.structure = token.getStructureHelper();
        this.content = token.getContentHelper();
        this.security = token.getSecurityHelper();
        this.lock = token.getLockHelper();
        this.macro = token.getMacroHelper();
    }

    /*
     * Loose catch block
     */
    public void run(HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        block50: {
            UriHandler.setGloballyUseHistoryCollectionHack(this.useHistoryCollectionHack());
            this.req = req;
            this.resp = resp;
            this.slideToken = WebdavUtils.getSlideToken(req);
            String forceLowercaseLogin = this.token.getNamespaceConfig().getParameter("force-lowercase-login");
            if ("true".equals(forceLowercaseLogin)) {
                String name = this.slideToken.getCredentialsToken().getPrincipal().getName().toLowerCase();
                this.slideToken.setCredentialsToken(new CredentialsToken(name));
            }
            this.requestUri = WebdavUtils.getRelativePath(req, this.config);
            this.slideContextPath = req.getContextPath();
            if (!this.config.isDefaultServlet()) {
                this.slideContextPath = this.slideContextPath + req.getServletPath();
            }
            this.slideToken.addParameter("slideContextPath", (Object)this.slideContextPath);
            this.parseRequestHeaders();
            boolean transactionIsStarted = false;
            boolean globalLockObtained = false;
            String txId = null;
            try {
                block45: {
                    UnlockMethod meth;
                    this.parseRequest();
                    ExternalTransactionContext externalTransaction = null;
                    txId = this.requestHeaders.getTxId();
                    if (txId != null && (externalTransaction = ExternalTransactionContext.lookupContext((Object)txId)) != null) {
                        Domain.log((Object)("Using external transaction " + txId), (String)LOG_CHANNEL, (int)6);
                        this.slideToken.setExternalTx();
                        this.slideToken.setForceStoreEnlistment(true);
                        Transaction tx = externalTransaction.getTransaction();
                        this.token.getTransactionManager().resume(tx);
                        transactionIsStarted = true;
                    }
                    if (!this.slideToken.isExternalTransaction()) {
                        this.token.begin();
                        transactionIsStarted = true;
                        if (this.txForAllRequests()) {
                            this.slideToken.setForceStoreEnlistment(true);
                        }
                        if (this instanceof ReadMethod) {
                            this.assureGlobalReadLock();
                        } else if (this instanceof WriteMethod) {
                            this.assureGlobalWriteLock();
                        }
                        globalLockObtained = true;
                    }
                    boolean isEndofTransactionxUnlock = false;
                    if (this instanceof UnlockMethod && (meth = (UnlockMethod)this).getCommand() != 0) {
                        isEndofTransactionxUnlock = true;
                    }
                    if (!isEndofTransactionxUnlock) {
                        try {
                            this.structure.retrieve(this.slideToken, this.requestUri);
                            UnlockListenerImpl listener = new UnlockListenerImpl(this.slideToken, this.token, this.config, req, resp);
                            this.lock.clearExpiredLocks(this.slideToken, this.requestUri, (UnlockListener)listener);
                            if (listener.getUnlockCount() > 0) {
                                this.token.commit();
                                this.token.begin();
                            }
                        }
                        catch (ObjectNotFoundException e) {
                            // empty catch block
                        }
                    }
                    this.executeRequest();
                    if (this.slideToken.isExternalTransaction() || !transactionIsStarted) break block45;
                    this.token.commit();
                    transactionIsStarted = false;
                }
                Object var11_18 = null;
            }
            catch (Throwable throwable) {
                Object var11_21 = null;
                if (!this.slideToken.isExternalTransaction() && transactionIsStarted) {
                    try {
                        this.token.rollback();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.slideToken.isExternalTransaction()) {
                    try {
                        Transaction transaction;
                        if (this.token.getStatus() == 0 && (transaction = this.token.getTransactionManager().suspend()) != null) {
                            ExternalTransactionContext.registerContext((Object)txId, (Transaction)transaction);
                        }
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
                if (globalLockObtained) {
                    this.releaseGlobalLock();
                }
                throw throwable;
            }
            if (!this.slideToken.isExternalTransaction() && transactionIsStarted) {
                try {
                    this.token.rollback();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.slideToken.isExternalTransaction()) {
                try {
                    Transaction transaction;
                    if (this.token.getStatus() == 0 && (transaction = this.token.getTransactionManager().suspend()) != null) {
                        ExternalTransactionContext.registerContext((Object)txId, (Transaction)transaction);
                    }
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
            if (globalLockObtained) {
                this.releaseGlobalLock();
            }
            break block50;
            {
                catch (WebdavException ex) {
                    Object var11_19 = null;
                    if (!this.slideToken.isExternalTransaction() && transactionIsStarted) {
                        try {
                            this.token.rollback();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.slideToken.isExternalTransaction()) {
                        try {
                            Transaction transaction;
                            if (this.token.getStatus() == 0 && (transaction = this.token.getTransactionManager().suspend()) != null) {
                                ExternalTransactionContext.registerContext((Object)txId, (Transaction)transaction);
                            }
                        }
                        catch (SystemException e) {
                            e.printStackTrace();
                        }
                    }
                    if (globalLockObtained) {
                        this.releaseGlobalLock();
                    }
                    break block50;
                }
                catch (SlideException ex) {
                    int statusCode = this.getErrorCode(ex);
                    this.sendError(statusCode, ex);
                    Object var11_20 = null;
                    if (!this.slideToken.isExternalTransaction() && transactionIsStarted) {
                        try {
                            this.token.rollback();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.slideToken.isExternalTransaction()) {
                        try {
                            Transaction transaction;
                            if (this.token.getStatus() == 0 && (transaction = this.token.getTransactionManager().suspend()) != null) {
                                ExternalTransactionContext.registerContext((Object)txId, (Transaction)transaction);
                            }
                        }
                        catch (SystemException e) {
                            e.printStackTrace();
                        }
                    }
                    if (globalLockObtained) {
                        this.releaseGlobalLock();
                    }
                    break block50;
                }
                catch (Exception ex) {
                    this.token.getLogger().log((Object)ex, LOG_CHANNEL, 2);
                    int statusCode = 500;
                    this.sendError(statusCode, ex);
                    throw new WebdavException(statusCode);
                }
            }
        }
    }

    public WebdavServletConfig getConfig() {
        return this.config;
    }

    public String getFullPath(String slidePath) {
        return WebdavUtils.getAbsolutePath(slidePath, this.req, this.getConfig());
    }

    public String getSlidePath(String fullpath) {
        return WebdavUtils.getSlidePath(fullpath, this.getSlideContextPath());
    }

    public String getSlideContextPath() {
        return this.slideContextPath;
    }

    protected void readRequestContent() {
        if (this.req.getContentLength() == 0) {
            return;
        }
        try {
            this.requestBody = new String(NodeRevisionContent.read((InputStream)this.req.getInputStream()), AbstractWebdavMethod.getEncodingString(this.req.getCharacterEncoding()));
        }
        catch (Exception e) {
            this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
        }
    }

    public static String getEncodingString(String httpEncoding) {
        String result = httpEncoding;
        if (result == null) {
            result = System.getProperty("file.encoding");
        }
        if (result.startsWith("\"")) {
            result = result.substring(1, result.length());
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void parseRequestHeaders() throws WebdavException {
        this.requestHeaders.parse();
    }

    protected boolean isCollection(String path) {
        return WebdavUtils.isCollection(this.token, this.slideToken, path);
    }

    protected boolean isDescendant(ObjectNode lowerNode, ObjectNode upperNode) throws ServiceAccessException {
        if (lowerNode.getUuri().equals(upperNode.getUuri())) {
            return true;
        }
        if (upperNode.hasBinding(lowerNode)) {
            return true;
        }
        NodeRevisionDescriptors lowerNrds = null;
        NodeRevisionDescriptor lowerNrd = null;
        try {
            lowerNrds = this.content.retrieve(this.slideToken, lowerNode.getUri());
            lowerNrd = this.content.retrieve(this.slideToken, lowerNrds);
            NodeProperty psProp = lowerNrd.getProperty("parent-set");
            XMLValue xv = new XMLValue(String.valueOf(psProp.getValue()));
            Iterator i = xv.getList().iterator();
            if (i.hasNext()) {
                Element pElm = (Element)i.next();
                String hrPath = pElm.getChild("href", DNSP).getText();
                ObjectNode hrNode = this.structure.retrieve(this.slideToken, hrPath);
                return this.isDescendant(hrNode, upperNode);
            }
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    protected boolean isRequestChunked() {
        String te = this.req.getHeader("Transfer-Encoding");
        if (te == null) {
            return false;
        }
        return te.indexOf("chunked") != -1;
    }

    protected abstract void parseRequest() throws WebdavException;

    protected Document getRequestContent() {
        return this.requestContentDocument;
    }

    protected String parseUri(String uri) throws WebdavException {
        String servletPath;
        String pathInfo;
        int protocolIndex = uri.indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = uri.indexOf("/", protocolIndex + 4);
            uri = firstSeparator < 0 ? "/" : uri.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = this.req.getServerName();
            if (hostName != null && uri.startsWith(hostName)) {
                uri = uri.substring(hostName.length());
            }
            if ((portIndex = uri.indexOf(":")) >= 0) {
                uri = uri.substring(portIndex);
            }
            if (uri.startsWith(":")) {
                int firstSeparator = uri.indexOf("/");
                uri = firstSeparator < 0 ? "/" : uri.substring(firstSeparator);
            }
        }
        uri = WebdavUtils.decodeURL(uri);
        String contextPath = this.req.getContextPath();
        if (contextPath != null && uri.startsWith(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        if ((pathInfo = this.req.getPathInfo()) != null && (servletPath = this.req.getServletPath()) != null && uri.startsWith(servletPath)) {
            uri = uri.substring(servletPath.length());
        }
        uri = this.getConfig().getScope() + uri;
        return uri;
    }

    protected Element parseRequestContent(String rootName) throws JDOMException, IOException {
        Document document = this.parseRequestContent();
        if (document == null) {
            throw new JDOMException("Request content missing");
        }
        Element root = document.getRootElement();
        if (root == null || !root.getName().equals(rootName)) {
            Domain.warn((Object)("Root element must be " + rootName));
            throw new JDOMException("Root element must be <" + rootName + ">");
        }
        return root;
    }

    protected Document parseRequestContent() throws JDOMException, IOException {
        if (this.isRequestContentParsed) {
            return this.requestContentDocument;
        }
        if (this.req.getContentLength() == 0 || this.req.getContentLength() == -1) {
            return this.requestContentDocument;
        }
        try {
            this.requestContentDocument = new SAXBuilder().build((InputStream)this.req.getInputStream());
            this.isRequestContentParsed = true;
        }
        catch (JDOMException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return this.requestContentDocument;
    }

    protected abstract void executeRequest() throws WebdavException, IOException;

    protected boolean isMsProprietarySupport() {
        return this.token.getNamespaceConfig().getParameter("ms") != null;
    }

    protected void sendPreconditionViolation(PreconditionViolationException pve) throws IOException {
        if (pve != null) {
            ViolatedPrecondition violatedPrecondition = pve.getViolatedPrecondition();
            int statusCode = violatedPrecondition.getStatusCode();
            this.printStackTrace((Throwable)((Object)pve), statusCode);
            String statusText = WebdavStatus.getStatusText(statusCode);
            if (violatedPrecondition.getExplanation() != null) {
                statusText = statusText + ": " + violatedPrecondition.getExplanation();
            }
            this.resp.setStatus(statusCode, statusText);
            this.resp.setContentType(TEXT_XML_UTF_8);
            Format format = Format.getPrettyFormat();
            format.setIndent(XML_RESPONSE_INDENT);
            new XMLOutputter(format).output(new Document(MethodUtil.getPreconditionViolationError(pve.getViolatedPrecondition())), (Writer)this.resp.getWriter());
        }
    }

    protected int getErrorCode(Throwable ex) {
        return WebdavUtils.getErrorCode(ex);
    }

    protected int getErrorCode(SlideException ex) {
        return WebdavUtils.getErrorCode(ex);
    }

    protected int getErrorCode(ServiceAccessException ex) {
        return WebdavUtils.getErrorCode(ex);
    }

    protected boolean getBooleanInitParameter(String name) {
        return "true".equalsIgnoreCase(this.getConfig().getInitParameter(name));
    }

    protected boolean useHistoryCollectionHack() {
        return "true".equalsIgnoreCase(this.token.getNamespaceConfig().getParameter("history-collection-hack"));
    }

    protected boolean txForAllRequests() {
        return "true".equalsIgnoreCase(this.token.getNamespaceConfig().getParameter("all-methods-in-transactions"));
    }

    protected boolean isSequentialWrite() {
        String sm = this.token.getNamespaceConfig().getParameter("sequential-mode");
        return "write".equalsIgnoreCase(sm) || "full".equalsIgnoreCase(sm);
    }

    protected boolean isSequentialRead() {
        return "full".equalsIgnoreCase(this.token.getNamespaceConfig().getParameter("sequential-mode"));
    }

    protected void assureGlobalReadLock() {
        if (this.isSequentialRead()) {
            try {
                GLOBAL_LOCK.acquire((Object)this, 1, true, true, Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void assureGlobalWriteLock() {
        if (this.isSequentialWrite()) {
            try {
                GLOBAL_LOCK.acquire((Object)this, 2, true, true, Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void releaseGlobalLock() {
        GLOBAL_LOCK.release((Object)this);
    }

    protected int getIntInitParameter(String name) {
        int result = -1;
        try {
            result = Integer.parseInt(this.getConfig().getInitParameter(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected void sendError(int statusCode) {
        try {
            this.resp.sendError(statusCode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void sendError(int statusCode, String message) {
        String statusText = WebdavStatus.getStatusText(statusCode) + (message != null ? ": " + Messages.format((String)message, (Object)null) : "");
        try {
            this.resp.sendError(statusCode, statusText);
        }
        catch (Throwable x) {
            // empty catch block
        }
    }

    protected void sendError(int statusCode, String message, Object[] args) {
        String statusText = WebdavStatus.getStatusText(statusCode) + ": " + Messages.format((String)message, (Object[])args);
        try {
            this.resp.sendError(statusCode, statusText);
        }
        catch (Throwable x) {
            // empty catch block
        }
    }

    protected void sendError(int statusCode, Throwable t) {
        this.printStackTrace(t, statusCode);
        String explanation = t == null || t.getMessage() == null || "".equals(t.getMessage()) ? Messages.format((String)t.getClass().getName(), (Object)null) : t.getMessage();
        String statusText = WebdavStatus.getStatusText(statusCode) + ": " + explanation;
        try {
            this.resp.sendError(statusCode, statusText);
        }
        catch (Throwable x) {
            // empty catch block
        }
    }

    protected void printStackTrace(Throwable x, int statusCode) {
        int printStackTraceFrom = this.getIntInitParameter("printStackTrace");
        if (printStackTraceFrom < 0) {
            printStackTraceFrom = 500;
        }
        if (statusCode >= printStackTraceFrom) {
            x.printStackTrace();
        }
    }

    protected void generateStatusText(Element parentElement, String href, int statusCode) {
        Element hrefElement = new Element("href", DNSP);
        parentElement.addContent((org.jdom.Content)hrefElement);
        hrefElement.setText(this.getFullPath(href));
        Element statusElement = new Element("status", DNSP);
        parentElement.addContent((org.jdom.Content)statusElement);
        statusElement.setText("HTTP/1.1 " + statusCode + " " + WebdavStatus.getStatusText(statusCode));
    }

    protected String generateErrorMessage(NestedSlideException nestedException) {
        Element multistatus = new Element("multistatus", DNSP);
        Enumeration nestedExceptionsList = nestedException.enumerateExceptions();
        while (nestedExceptionsList.hasMoreElements()) {
            Element response = new Element("response", DNSP);
            multistatus.addContent((org.jdom.Content)response);
            SlideException ex = (SlideException)((Object)nestedExceptionsList.nextElement());
            this.generateStatusText(response, MethodUtil.getErrorMessage(ex), this.getErrorCode(ex));
            if (!(ex instanceof PreconditionViolationException)) continue;
            response.addContent((org.jdom.Content)MethodUtil.getPreconditionViolationResponseDescription((PreconditionViolationException)ex));
        }
        StringWriter stringWriter = new StringWriter();
        try {
            new XMLOutputter().output(multistatus, (Writer)stringWriter);
        }
        catch (IOException e) {
            Domain.log((Object)e);
        }
        return stringWriter.toString();
    }

    protected boolean exists(String uriStr) throws SlideException {
        boolean destinationExists = true;
        try {
            this.content.retrieve(this.slideToken, uriStr);
        }
        catch (ObjectNotFoundException x) {
            destinationExists = false;
        }
        return destinationExists;
    }

    protected boolean isLocked(String uriStr) throws ServiceAccessException {
        boolean isLocked = false;
        try {
            Enumeration locks = this.lock.enumerateLocks(this.slideToken, uriStr, false);
            while (locks.hasMoreElements()) {
                if (!this.lock.isLocked(this.slideToken, (NodeLock)locks.nextElement(), false)) continue;
                isLocked = true;
            }
        }
        catch (ServiceAccessException x) {
            throw x;
        }
        catch (SlideException slideException) {
            // empty catch block
        }
        return isLocked;
    }

    protected boolean isLockNull(String uriStr) throws ServiceAccessException {
        boolean isLockNull = false;
        try {
            NodeRevisionDescriptor nrd = this.content.retrieve(this.slideToken, this.content.retrieve(this.slideToken, uriStr));
            isLockNull = this.isLockNull(nrd);
        }
        catch (ServiceAccessException x) {
            throw x;
        }
        catch (SlideException slideException) {
            // empty catch block
        }
        return isLockNull;
    }

    protected boolean isLockNull(NodeRevisionDescriptor nrd) {
        return nrd.propertyValueContains("resourcetype", "lock-null");
    }

    protected boolean isAutoVersionControl(String resourcePath) {
        return new Boolean(Domain.getParameter((String)"auto-version-control", (String)"false", (Store)this.token.getUri(this.slideToken, resourcePath).getStore()));
    }

    protected boolean isExcludedForVersionControl(String resourcePath) {
        String versionControlExcludePaths = Domain.getParameter((String)"versioncontrol-exclude", (String)"", (Store)this.token.getUri(this.slideToken, resourcePath).getStore());
        if (versionControlExcludePaths != null && versionControlExcludePaths.length() > 0) {
            StringTokenizer st = new StringTokenizer(versionControlExcludePaths, ";");
            while (st.hasMoreTokens()) {
                if (!this.isExcluded(resourcePath, st.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcluded(String resourcePath, String excludePath) {
        UriHandler exUh;
        UriHandler uh = UriHandler.getUriHandler(resourcePath);
        return excludePath != null && excludePath.length() > 0 && (exUh = UriHandler.getUriHandler(excludePath)).isAncestorOf(uh);
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        Date date;
        StringTokenizer commaTokenizer;
        String eTag = this.getETagValue(resourceInfo, true);
        long lastModified = resourceInfo.date;
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null) {
            if (headerValue.indexOf("*") == -1) {
                commaTokenizer = new StringTokenizer(headerValue, ", \"");
                boolean matchingTagFound = false;
                while (!matchingTagFound && commaTokenizer.hasMoreTokens()) {
                    matchingTagFound = commaTokenizer.nextToken().equals(eTag);
                }
                if (!matchingTagFound) {
                    response.sendError(412);
                    return false;
                }
            } else if (!resourceInfo.exists()) {
                response.sendError(412);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-Modified-Since")) != null && request.getHeader("If-None-Match") == null && (date = this.parseHttpDate(headerValue)) != null && lastModified <= date.getTime() + 1000L) {
            response.sendError(304);
            return false;
        }
        headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            if (headerValue.indexOf("*") == -1) {
                commaTokenizer = new StringTokenizer(headerValue, ", \"");
                while (commaTokenizer.hasMoreTokens()) {
                    if (!commaTokenizer.nextToken().equals(eTag)) continue;
                    if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                        response.sendError(304);
                        return false;
                    }
                    response.sendError(412);
                    return false;
                }
            } else if (resourceInfo.exists()) {
                response.sendError(412);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-Unmodified-Since")) != null && (date = this.parseHttpDate(headerValue)) != null && lastModified > date.getTime()) {
            response.sendError(412);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseHttpDate(String headerValue) {
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    date = formats[i].parse(headerValue);
                    continue;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return date;
    }

    protected String getETagValue(ResourceInfo resourceInfo, boolean strong) {
        if (resourceInfo.exists()) {
            return resourceInfo.etag;
        }
        return resourceInfo.length + "-" + resourceInfo.date;
    }

    protected String getETag(ResourceInfo resourceInfo, boolean strong) {
        if (strong) {
            return "\"" + this.getETagValue(resourceInfo, strong) + "\"";
        }
        return "W/\"" + this.getETagValue(resourceInfo, strong) + "\"";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RequestHeaders {
        private static final int ST_UNDEFINED = 0;
        private static final int ST_INVALID = 1;
        private static final int ST_DEFINED = 2;
        private String hIfStr;
        private String hLockTokenStr;
        private String hDepthStr;
        private String hDestinationStr;
        private String hOverwriteStr;
        private String hTimeoutStr;
        private String hLabelStr;
        private String hNotificationTypeStr;
        private String hCallbackStr;
        private String hSubscriptionIdStr;
        private String hNotificationDelayStr;
        private String hSubscriptionLifetimeStr;
        private String hTxIdStr;
        private String hTxMethodStr;
        private String hContentTypeStr;
        private List hIf;
        private String hLockToken;
        private int hDepth;
        private String hDestination;
        private boolean hOverwrite;
        private int hTimeout;
        private String hLabel;
        private String hNotificationType;
        private String hCallback;
        private int[] hSubscriptionId;
        private int hNotificationDelay;
        private int hSubscriptionLifetime;
        private String hTxId;
        private String hTxMethod;
        private String hContentType;
        private int stIf = 0;
        private int stLockToken = 0;
        private int stDepth = 0;
        private int stDestination = 0;
        private int stOverwrite = 0;
        private int stTimeout = 0;
        private int stLabel = 0;
        private int stNotificationType = 0;
        private int stCallback = 0;
        private int stSubscriptionId = 0;
        private int stNotificationDelay = 0;
        private int stSubscriptionLifetime = 0;
        private int stTxId = 0;
        private int stTxMethod = 0;
        private int stContentType = 0;

        protected RequestHeaders() {
        }

        protected boolean isDefined(String header) {
            return AbstractWebdavMethod.this.req.getHeader(header) != null;
        }

        protected List getIf() throws WebdavException {
            if (this.stIf == 0) {
                return Collections.EMPTY_LIST;
            }
            if (this.stIf == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header If: " + this.hIfStr);
                throw new WebdavException(sc);
            }
            return this.hIf;
        }

        protected String getLockToken() throws WebdavException {
            if (this.stLockToken == 0) {
                return null;
            }
            if (this.stLockToken == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header LockToken: " + this.hLockTokenStr);
                throw new WebdavException(sc);
            }
            return this.hLockToken;
        }

        protected int getDepth(int defaultValue) throws WebdavException {
            if (this.stDepth == 0) {
                return defaultValue;
            }
            if (this.stDepth == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header Depth: " + this.hDepthStr);
                throw new WebdavException(sc);
            }
            return this.hDepth;
        }

        protected String getDestination() throws WebdavException {
            if (this.stDestination == 0) {
                return null;
            }
            if (this.stDestination == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header Destination: " + this.hDestinationStr);
                throw new WebdavException(sc);
            }
            return this.hDestination;
        }

        protected boolean getOverwrite(boolean defaultValue) throws WebdavException {
            if (this.stOverwrite == 0) {
                return defaultValue;
            }
            if (this.stOverwrite == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header Overwrite: " + this.hOverwriteStr);
                throw new WebdavException(sc);
            }
            return this.hOverwrite;
        }

        protected String getLabel() throws WebdavException {
            if (this.stLabel == 0) {
                return null;
            }
            if (this.stLabel == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header Label: " + this.hLabelStr);
                throw new WebdavException(sc);
            }
            return this.hLabel;
        }

        protected int getTimeout(int defaultValue) throws WebdavException {
            if (this.stTimeout == 0) {
                return defaultValue;
            }
            if (this.stTimeout == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid header Timeout: " + this.hTimeoutStr);
                throw new WebdavException(sc);
            }
            return this.hTimeout;
        }

        protected String getNotificationType() throws WebdavException {
            if (this.stNotificationType == 0) {
                return null;
            }
            if (this.stNotificationType == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid notification type: " + this.hNotificationTypeStr);
                throw new WebdavException(sc);
            }
            return this.hNotificationType;
        }

        protected int[] getSubscriptionId() throws WebdavException {
            if (this.stSubscriptionId == 0) {
                return new int[0];
            }
            if (this.stSubscriptionId == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid subscription ID: " + this.hSubscriptionIdStr);
                throw new WebdavException(sc);
            }
            return this.hSubscriptionId;
        }

        protected String getCallback() throws WebdavException {
            if (this.stCallback == 0) {
                return null;
            }
            if (this.stCallback == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid callback: " + this.hCallbackStr);
                throw new WebdavException(sc);
            }
            return this.hCallback;
        }

        protected int getNotificationDelay(int defaultValue) throws WebdavException {
            if (this.stNotificationDelay == 0) {
                return defaultValue;
            }
            if (this.stNotificationDelay == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid notification delay: " + this.hNotificationDelayStr);
                throw new WebdavException(sc);
            }
            return this.hNotificationDelay;
        }

        protected int getSubscriptionLifetime(int defaultValue) throws WebdavException {
            if (this.stSubscriptionLifetime == 0) {
                return defaultValue;
            }
            if (this.stSubscriptionLifetime == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid subscription lifetime: " + this.hSubscriptionLifetimeStr);
                throw new WebdavException(sc);
            }
            return this.hSubscriptionLifetime;
        }

        protected String getTxId() throws WebdavException {
            if (this.stTxId == 0) {
                return null;
            }
            if (this.stTxId == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid transaction id: " + this.hTxIdStr);
                throw new WebdavException(sc);
            }
            return this.hTxId;
        }

        protected String getTxMethod() throws WebdavException {
            if (this.stTxMethod == 0) {
                return null;
            }
            if (this.stTxMethod == 1) {
                int sc = 412;
                AbstractWebdavMethod.this.sendError(sc, "Invalid transaction method: " + this.hTxMethodStr);
                throw new WebdavException(sc);
            }
            return this.hTxMethod;
        }

        protected String getContentType() {
            if (this.stContentType == 0) {
                return null;
            }
            return this.hContentType;
        }

        protected void parse() {
            String hOverwriteStr;
            this.hTxIdStr = AbstractWebdavMethod.this.req.getHeader("Transaction");
            if (this.hTxIdStr != null) {
                this.stTxId = 2;
                try {
                    this.hTxId = this.hTxIdStr;
                }
                catch (Exception e) {
                    this.stTxId = 1;
                }
            }
            this.hTxMethodStr = AbstractWebdavMethod.this.req.getHeader("Tx-Method");
            if (this.hTxMethodStr != null) {
                this.stTxMethod = 2;
                try {
                    this.hTxMethod = this.hTxMethodStr;
                }
                catch (Exception e) {
                    this.stTxMethod = 1;
                }
            }
            this.hNotificationTypeStr = AbstractWebdavMethod.this.req.getHeader("Notification-type");
            if (this.hNotificationTypeStr != null) {
                this.stNotificationType = 2;
                try {
                    this.hNotificationType = this.hNotificationTypeStr;
                }
                catch (Exception e) {
                    this.stNotificationType = 1;
                }
            }
            this.hNotificationDelayStr = AbstractWebdavMethod.this.req.getHeader("Notification-delay");
            if (this.hNotificationDelayStr != null) {
                this.stNotificationDelay = 2;
                try {
                    this.hNotificationDelay = Integer.parseInt(this.hNotificationDelayStr);
                }
                catch (Exception e) {
                    this.stNotificationDelay = 1;
                }
            }
            this.hSubscriptionLifetimeStr = AbstractWebdavMethod.this.req.getHeader("Subscription-lifetime");
            if (this.hSubscriptionLifetimeStr != null) {
                this.stSubscriptionLifetime = 2;
                try {
                    this.hSubscriptionLifetime = Integer.parseInt(this.hSubscriptionLifetimeStr);
                }
                catch (Exception e) {
                    this.stSubscriptionLifetime = 1;
                }
            }
            this.hSubscriptionIdStr = AbstractWebdavMethod.this.req.getHeader("Subscription-ID");
            if (this.hSubscriptionIdStr != null) {
                this.stSubscriptionId = 2;
                try {
                    StringTokenizer tokenizer = new StringTokenizer(this.hSubscriptionIdStr, ",");
                    this.hSubscriptionId = new int[tokenizer.countTokens()];
                    int i = 0;
                    while (tokenizer.hasMoreTokens()) {
                        this.hSubscriptionId[i] = Integer.parseInt(tokenizer.nextToken().trim());
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.stSubscriptionId = 1;
                }
            }
            this.hCallbackStr = AbstractWebdavMethod.this.req.getHeader("Call-back");
            if (this.hCallbackStr != null) {
                this.stCallback = 2;
                try {
                    this.hCallback = this.hCallbackStr;
                }
                catch (Exception e) {
                    this.stCallback = 1;
                }
            }
            this.hIfStr = AbstractWebdavMethod.this.req.getHeader("If");
            if (this.hIfStr != null) {
                this.stIf = 2;
                try {
                    this.hIf = this.extractLockTokens(this.hIfStr);
                }
                catch (Exception e) {
                    this.stIf = 1;
                }
            }
            this.hLockTokenStr = AbstractWebdavMethod.this.req.getHeader("Lock-Token");
            if (this.hLockTokenStr != null) {
                this.stLockToken = 2;
                try {
                    List tl = this.extractLockTokens(this.hLockTokenStr);
                    this.hLockToken = (String)tl.get(0);
                }
                catch (Exception e) {
                    this.stLockToken = 1;
                }
            }
            this.hDepthStr = AbstractWebdavMethod.this.req.getHeader("Depth");
            if (this.hDepthStr != null) {
                this.stDepth = 2;
                if ("0".equals(this.hDepthStr)) {
                    this.hDepth = 0;
                } else if ("1".equals(this.hDepthStr)) {
                    this.hDepth = 1;
                } else if ("infinity".equalsIgnoreCase(this.hDepthStr)) {
                    this.hDepth = Integer.MAX_VALUE;
                } else {
                    this.stDepth = 1;
                    this.hDepth = Integer.parseInt(this.hDepthStr);
                }
            }
            this.hDestinationStr = AbstractWebdavMethod.this.req.getHeader("Destination");
            if (this.hDestinationStr != null) {
                this.stDestination = 2;
                this.hDestination = this.hDestinationStr;
            }
            if ((hOverwriteStr = AbstractWebdavMethod.this.req.getHeader("Overwrite")) != null) {
                this.stOverwrite = 2;
                if ("T".equalsIgnoreCase(hOverwriteStr)) {
                    this.hOverwrite = true;
                } else if ("F".equalsIgnoreCase(hOverwriteStr)) {
                    this.hOverwrite = false;
                } else {
                    this.stOverwrite = 1;
                }
            }
            this.hTimeoutStr = AbstractWebdavMethod.this.req.getHeader("Timeout");
            if (this.hTimeoutStr != null) {
                this.stTimeout = 2;
                try {
                    this.hTimeout = this.extractLockDuration(this.hTimeoutStr);
                }
                catch (Exception e) {
                    this.stTimeout = 1;
                }
            }
            this.hLabelStr = AbstractWebdavMethod.this.req.getHeader("Label");
            if (this.hLabelStr != null) {
                this.stLabel = 2;
                this.hLabel = this.hLabelStr;
            }
            this.hContentTypeStr = AbstractWebdavMethod.this.req.getHeader("Content-Type");
            if (this.hContentTypeStr != null) {
                this.stContentType = 2;
                this.hContentType = this.hContentTypeStr;
            }
        }

        private List extractLockTokens(String hStr) {
            ArrayList<String> result = new ArrayList<String>();
            int pos = hStr.indexOf("opaquelocktoken:");
            int endPos = -1;
            int offset = "opaquelocktoken:".length();
            String lockToken = null;
            while (pos != -1) {
                endPos = hStr.indexOf(62, pos + offset);
                if (endPos == -1) {
                    lockToken = hStr;
                    endPos = hStr.length();
                } else {
                    lockToken = hStr.substring(pos + offset, endPos);
                }
                AbstractWebdavMethod.this.slideToken.addLockToken(lockToken);
                result.add(lockToken);
                pos = hStr.indexOf("opaquelocktoken:", endPos);
            }
            return result;
        }

        private int extractLockDuration(String hStr) {
            int firstCommaPos = hStr.indexOf(44);
            if (firstCommaPos != -1) {
                hStr = hStr.substring(0, firstCommaPos);
            }
            int result = hStr.startsWith("Second-") ? Integer.parseInt(hStr.substring("Second-".length())) : (hStr.equalsIgnoreCase("Infinite") ? Integer.MAX_VALUE : Integer.parseInt(hStr));
            return result;
        }
    }

    protected class ResourceInfo {
        public String path;
        public long creationDate;
        public String httpDate;
        public long date;
        public long length;
        public String etag;
        public boolean exists;

        public ResourceInfo(String path, NodeRevisionDescriptor properties) {
            this.path = path;
            this.exists = true;
            this.creationDate = properties.getCreationDateAsDate().getTime();
            this.date = properties.getLastModifiedAsDate().getTime();
            this.httpDate = properties.getLastModified();
            this.length = properties.getContentLength();
            this.etag = properties.getETag();
        }

        public ResourceInfo(String path) {
            this.path = path;
            this.exists = false;
            this.length = 0L;
            this.date = System.currentTimeMillis();
        }

        public boolean exists() {
            return this.exists;
        }

        public String toString() {
            return this.path;
        }
    }
}

