/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.logger.XByteBuffer;

public class XServletInputStreamFacade
extends ServletInputStream {
    private ServletInputStream in;
    private XByteBuffer byteBuf;

    public XServletInputStreamFacade(ServletInputStream in) {
        if (Domain.isInitialized()) {
            Domain.debug((Object)"Create XServletInputStreamFacade");
        }
        this.in = in;
        this.byteBuf = new XByteBuffer();
    }

    public int read() throws IOException {
        if (Domain.isInitialized()) {
            Domain.debug((Object)"ENTER: XServletInputStreamFacade:read()");
        }
        int result = this.in.read();
        this.byteBuf.write(result);
        if (Domain.isInitialized()) {
            Domain.debug((Object)("LEAVE: XServletInputStreamFacade:read() result = " + result));
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        if (Domain.isInitialized()) {
            Domain.debug((Object)"ENTER: XServletInputStreamFacade:read(byte[] b)");
        }
        int result = this.in.read(b);
        this.byteBuf.write(b, 0, result);
        if (Domain.isInitialized()) {
            Domain.debug((Object)("LEAVE: XServletInputStreamFacade:read(byte[] b) result = " + result));
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (Domain.isInitialized()) {
            Domain.debug((Object)("ENTER: XServletInputStreamFacade:read(byte[] b, off=" + off + " len=" + len + " )"));
        }
        int result = this.in.read(b, off, len);
        this.byteBuf.write(b, off, result);
        if (Domain.isInitialized()) {
            Domain.debug((Object)("LEAVE: XServletInputStreamFacade:read(byte[] b, off=" + off + " len=" + len + " ) result = " + result));
        }
        return result;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public synchronized int available() throws IOException {
        return this.in.available();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getBufferContent() {
        return this.byteBuf.getBufferContent();
    }

    public int getNumberOfBytesWritten() {
        return this.byteBuf.getNumberOfBytesWritten();
    }
}

