/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.logger.XServletInputStreamFacade;

public class XHttpServletRequestFacade
extends HttpServletRequestWrapper {
    public static final String DEFAULT_CHAR_ENCODING = "8859_1";
    private XServletInputStreamFacade inStreamFacade = null;
    private BufferedReader reader = null;
    private boolean usingReader = false;
    private boolean usingStream = false;

    public XHttpServletRequestFacade(HttpServletRequest request) {
        super(request);
        Domain.debug((Object)"Create XHttpServletRequestFacade");
    }

    public ServletInputStream getInputStream() throws IOException {
        Domain.debug((Object)"ENTER: XHttpServletRequestFacade:getInputStream()");
        if (this.usingReader) {
            throw new IllegalStateException("getReader() method has been called on this request");
        }
        this.usingStream = true;
        if (this.inStreamFacade == null) {
            this.inStreamFacade = new XServletInputStreamFacade(super.getInputStream());
        }
        Domain.debug((Object)"LEAVE: XHttpServletRequestFacade:getInputStream()");
        return this.inStreamFacade;
    }

    public int doRead() throws IOException {
        return this.inStreamFacade.read();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.inStreamFacade.read(b, off, len);
    }

    public BufferedReader getReader() throws IOException {
        Domain.debug((Object)"ENTER: XHttpServletRequestFacade:getReader()");
        if (this.usingStream) {
            throw new IllegalStateException("getInputStream() method has been called on this request");
        }
        this.usingReader = true;
        if (this.inStreamFacade == null) {
            this.inStreamFacade = new XServletInputStreamFacade(super.getInputStream());
        }
        if (this.reader != null) {
            Domain.debug((Object)"LEAVE: XHttpServletRequestFacade:getReader() - reader != null");
            return this.reader;
        }
        String encoding = super.getCharacterEncoding();
        if (encoding == null) {
            encoding = DEFAULT_CHAR_ENCODING;
        }
        InputStreamReader r = new InputStreamReader((InputStream)((Object)this.inStreamFacade), encoding);
        this.reader = new BufferedReader(r);
        Domain.debug((Object)"LEAVE: XHttpServletRequestFacade:getReader() - new BufferedReader");
        return this.reader;
    }

    public String getRequestBody() throws IOException {
        if (this.usingStream) {
            Domain.debug((Object)"XHttpServletRequestFacade:getRequestBody() - usingStream");
            return this.inStreamFacade.getBufferContent();
        }
        if (this.usingReader) {
            Domain.debug((Object)"XHttpServletRequestFacade:getRequestBody() - usingReader");
            return this.reader.toString();
        }
        Domain.debug((Object)"XHttpServletRequestFacade:getRequestBody() - nor Reader nor Stream - do nothing");
        return "";
    }
}

