/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.filter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.webdav.logger.XHttpServletRequestFacade;
import org.apache.slide.webdav.logger.XHttpServletResponseFacade;
import org.apache.slide.webdav.logger.XMLTestCaseGenerator;

public class XmlLogFilter
implements Filter {
    FilterConfig config;
    boolean outputToFile = false;
    String outputFilePath = null;
    File outputFile = null;
    BufferedOutputStream fout = null;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        String p = config.getInitParameter("outputToFile");
        if (p != null && !"".equals(p)) {
            this.outputFilePath = p;
            this.outputFile = new File(this.outputFilePath);
            try {
                if (this.outputFile.canWrite() || this.outputFile.createNewFile()) {
                    this.fout = new BufferedOutputStream(new FileOutputStream(this.outputFilePath, true));
                    this.outputToFile = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        XHttpServletRequestFacade reqFac = new XHttpServletRequestFacade((HttpServletRequest)req);
        XHttpServletResponseFacade respFac = new XHttpServletResponseFacade((HttpServletResponse)resp);
        chain.doFilter((ServletRequest)reqFac, (ServletResponse)respFac);
        this.logXML(reqFac, respFac);
    }

    private void logXML(XHttpServletRequestFacade req, XHttpServletResponseFacade resp) throws IOException {
        String thread = Thread.currentThread().getName();
        XMLTestCaseGenerator xmlGen = new XMLTestCaseGenerator(req, resp);
        xmlGen.setThreadName(thread);
        if (this.outputToFile) {
            this.fout.write(xmlGen.toString().getBytes("UTF-8"));
            this.fout.flush();
        }
    }

    public void destroy() {
        try {
            if (this.outputToFile) {
                this.fout.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

